/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class TailwindUtil {
    private TailwindUtil() {
    }

    public static boolean canBeTailwindCssClassNamePart(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            TailwindUtil.$$$reportNull$$$0(0);
        }
        IElementType type = (node = element.getNode()) != null ? node.getElementType() : null;
        return type == CssElementTypes.CSS_IDENT || type == CssElementTypes.CSS_COLON || type == CssElementTypes.CSS_NUMBER || type == CssElementTypes.CSS_SLASH;
    }

    @NotNull
    public static PsiElement getFirstElementInTailwindClassName(@NotNull PsiElement namePartElement) {
        if (namePartElement == null) {
            TailwindUtil.$$$reportNull$$$0(1);
        }
        PsiElement identStart = namePartElement;
        for (PsiElement prev = identStart.getPrevSibling(); prev != null && TailwindUtil.canBeTailwindCssClassNamePart(prev); prev = prev.getPrevSibling()) {
            identStart = prev;
        }
        PsiElement psiElement = identStart;
        if (psiElement == null) {
            TailwindUtil.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getLastElementInTailwindClassName(@NotNull PsiElement namePartElement) {
        if (namePartElement == null) {
            TailwindUtil.$$$reportNull$$$0(3);
        }
        PsiElement identEnd = namePartElement;
        for (PsiElement next = identEnd.getNextSibling(); next != null && TailwindUtil.canBeTailwindCssClassNamePart(next); next = next.getNextSibling()) {
            identEnd = next;
        }
        PsiElement psiElement = identEnd;
        if (psiElement == null) {
            TailwindUtil.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePartElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/util/TailwindUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/util/TailwindUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstElementInTailwindClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastElementInTailwindClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeTailwindCssClassNamePart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFirstElementInTailwindClassName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLastElementInTailwindClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

