/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.service;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.tailwind.service.TailwindCssParser;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TailwindService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TailwindService.class);
    private static final String TAILWIND_CONFIG_FILE_NAME = "tailwind.config.js";
    private static final String TAILWIND_CSS_PACKAGE_NAME = "tailwindcss";
    private static final String TAILWIND_CSS_FILE_NAME = "tailwind.css";
    private static final String TEMP_FILE_NAME = "intellij-tailwindcss-temporary-file.css";
    private static final int ERROR_LOG_MAX_LENGTH = 500;
    private static final int PROCESS_TIMEOUT = 30000;
    @NotNull
    private final Project myProject;
    private final Object myCacheLock;
    @Nullable
    private CachedInfo myCache;
    private final Object myProcessHandlerLock;
    @Nullable
    private OSProcessHandler myProcessHandler;

    @NotNull
    public static TailwindService getInstance(@NotNull Project project) {
        if (project == null) {
            TailwindService.$$$reportNull$$$0(0);
        }
        TailwindService tailwindService = (TailwindService)project.getService(TailwindService.class);
        if (tailwindService == null) {
            TailwindService.$$$reportNull$$$0(1);
        }
        return tailwindService;
    }

    public TailwindService(@NotNull Project project) {
        if (project == null) {
            TailwindService.$$$reportNull$$$0(2);
        }
        this.myCacheLock = new Object();
        this.myProcessHandlerLock = new Object();
        this.myProject = project;
        LowMemoryWatcher.register(this::clearCache, (Disposable)this);
    }

    public static void ensureTailwindConfigFileSaved(@NotNull Project project, @NotNull VirtualFile contextFile) {
        TailwindProjectInfo tailwindProjectInfo;
        if (project == null) {
            TailwindService.$$$reportNull$$$0(3);
        }
        if (contextFile == null) {
            TailwindService.$$$reportNull$$$0(4);
        }
        if ((tailwindProjectInfo = TailwindService.getTailwindProjectInfo(project, contextFile)) == null) {
            return;
        }
        VirtualFile configFile = tailwindProjectInfo.myTailwindConfigFile;
        if (configFile != null && FileDocumentManager.getInstance().isFileModified(configFile)) {
            WriteAction.run(() -> {
                Document document;
                Document document2 = document = configFile.isValid() ? FileDocumentManager.getInstance().getCachedDocument(configFile) : null;
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.clearCache();
        Object object = this.myProcessHandlerLock;
        synchronized (object) {
            if (this.myProcessHandler != null) {
                this.myProcessHandler.destroyProcess();
                this.myProcessHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.myCacheLock;
        synchronized (object) {
            this.myCache = null;
        }
    }

    @NotNull
    public Map<String, List<CssClassInfo>> getAllCssClassInfos(@NotNull PsiElement context) {
        CachedInfo cachedInfo;
        VirtualFile file;
        if (context == null) {
            TailwindService.$$$reportNull$$$0(5);
        }
        if ((file = context.getContainingFile().getOriginalFile().getVirtualFile()) instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        Map<String, List<CssClassInfo>> map = (cachedInfo = this.getCachedInfo(file)) != null ? cachedInfo.myCssClasses : Collections.emptyMap();
        if (map == null) {
            TailwindService.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public List<CssClassInfo> getCssClassInfos(@NotNull PsiElement context, @NotNull String cssClassName) {
        CachedInfo cachedInfo;
        VirtualFile file;
        if (context == null) {
            TailwindService.$$$reportNull$$$0(7);
        }
        if (cssClassName == null) {
            TailwindService.$$$reportNull$$$0(8);
        }
        if ((file = context.getContainingFile().getOriginalFile().getVirtualFile()) instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        List<CssClassInfo> cssClassInfos = (cachedInfo = this.getCachedInfo(file)) != null ? cachedInfo.myCssClasses.get(cssClassName) : null;
        List<CssClassInfo> list = cssClassInfos != null ? cssClassInfos : Collections.emptyList();
        if (list == null) {
            TailwindService.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private CachedInfo getCachedInfo(@Nullable VirtualFile contextFile) {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed());
        TailwindProjectInfo tailwindProjectInfo = TailwindService.getTailwindProjectInfo(this.myProject, contextFile);
        if (tailwindProjectInfo == null) {
            return null;
        }
        CachedInfo cachedInfo = this.getCacheIfUpToDate(tailwindProjectInfo);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        NodeJsInterpreter node = NodeJsInterpreterManager.getInstance((Project)this.myProject).getInterpreter();
        if (node == null) {
            return null;
        }
        try {
            this.runTailwind(node, tailwindProjectInfo);
        }
        catch (ExecutionException e) {
            LOG.warn(e.getMessage());
        }
        cachedInfo = this.getCacheIfUpToDate(tailwindProjectInfo);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CachedInfo getCacheIfUpToDate(@NotNull TailwindProjectInfo tailwindProjectInfo) {
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(10);
        }
        Object object = this.myCacheLock;
        synchronized (object) {
            if (this.myCache != null) {
                String pathForCache = TailwindService.getPathForCache(tailwindProjectInfo);
                if (this.myCache.myPathForCache.equals(pathForCache) && this.myCache.isUpToDate()) {
                    LOG.trace("Using cache for " + pathForCache + ", size = " + this.myCache.myCssClasses.size());
                    return this.myCache;
                }
                LOG.trace("Dropping cache for " + pathForCache);
                this.myCache = null;
            }
        }
        return null;
    }

    public static boolean isTailwindProject(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            TailwindService.$$$reportNull$$$0(11);
        }
        if (contextFile == null) {
            TailwindService.$$$reportNull$$$0(12);
        }
        return TailwindService.getTailwindProjectInfo(project, contextFile) != null;
    }

    @Contract(value="_,null -> null")
    @Nullable
    private static TailwindProjectInfo getTailwindProjectInfo(@NotNull Project project, @Nullable VirtualFile contextFile) {
        VirtualFile binFile;
        if (project == null) {
            TailwindService.$$$reportNull$$$0(13);
        }
        if (contextFile == null) {
            return null;
        }
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)contextFile);
        if (packageJson == null) {
            return null;
        }
        InstalledPackageVersion tailwindCssPackage = new NodeInstalledPackageFinder(project, packageJson).findInstalledPackage(TAILWIND_CSS_PACKAGE_NAME);
        if (tailwindCssPackage == null || tailwindCssPackage.getPackageJson() == null) {
            return null;
        }
        VirtualFile tailwindCssFile = tailwindCssPackage.getPackageDir().findChild(TAILWIND_CSS_FILE_NAME);
        if (tailwindCssFile == null) {
            return null;
        }
        String binPath = PackageJsonData.getOrCreate((VirtualFile)tailwindCssPackage.getPackageJson()).getBinPath(TAILWIND_CSS_PACKAGE_NAME);
        VirtualFile virtualFile = binFile = binPath != null ? tailwindCssPackage.getPackageDir().findFileByRelativePath(binPath) : null;
        if (binFile == null) {
            return null;
        }
        return new TailwindProjectInfo(TailwindService.getTailwindConfigFile(contextFile), packageJson, tailwindCssPackage.getPackageDir(), tailwindCssFile, binFile);
    }

    @Nullable
    private static VirtualFile getTailwindConfigFile(@NotNull VirtualFile contextFile) {
        if (contextFile == null) {
            TailwindService.$$$reportNull$$$0(14);
        }
        Ref tailwindConfigFileRef = Ref.create();
        TailwindService.processDirectoriesUp(contextFile, (Processor<VirtualFile>)((Processor)dir -> {
            ProgressManager.checkCanceled();
            VirtualFile tailwindConfigFile = dir.findFileByRelativePath(TAILWIND_CONFIG_FILE_NAME);
            if (tailwindConfigFile != null && !tailwindConfigFile.isDirectory()) {
                tailwindConfigFileRef.set((Object)tailwindConfigFile);
                return false;
            }
            return true;
        }));
        return (VirtualFile)tailwindConfigFileRef.get();
    }

    @Nullable
    public static VirtualFile getTailwindCssPackageDir(@NotNull Project project, @NotNull VirtualFile contextFileOrDir) {
        TailwindProjectInfo info;
        if (project == null) {
            TailwindService.$$$reportNull$$$0(15);
        }
        if (contextFileOrDir == null) {
            TailwindService.$$$reportNull$$$0(16);
        }
        return (info = TailwindService.getTailwindProjectInfo(project, contextFileOrDir)) != null ? info.myTailwindPackageDir : null;
    }

    private static void processDirectoriesUp(@NotNull VirtualFile contextFileOrDir, @NotNull Processor<VirtualFile> processor) {
        if (contextFileOrDir == null) {
            TailwindService.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            TailwindService.$$$reportNull$$$0(18);
        }
        ReadAction.run(() -> {
            VirtualFile currentDir;
            VirtualFile virtualFile = currentDir = contextFileOrDir.isDirectory() ? contextFileOrDir : contextFileOrDir.getParent();
            while (currentDir != null) {
                if (!processor.process((Object)currentDir)) {
                    return;
                }
                currentDir = currentDir.getParent();
            }
        });
    }

    private void runTailwind(@NotNull NodeJsInterpreter node, @NotNull TailwindProjectInfo tailwindProjectInfo) throws ExecutionException {
        if (node == null) {
            TailwindService.$$$reportNull$$$0(19);
        }
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(20);
        }
        OSProcessHandler processHandler = this.getRunningProcessOrStartNew(node, tailwindProjectInfo);
        TailwindService.waitForProcessFinishCheckingIfCancelled(processHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private OSProcessHandler getRunningProcessOrStartNew(@NotNull NodeJsInterpreter node, @NotNull TailwindProjectInfo tailwindProjectInfo) throws ExecutionException {
        if (node == null) {
            TailwindService.$$$reportNull$$$0(21);
        }
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(22);
        }
        Object object = this.myProcessHandlerLock;
        // MONITORENTER : object
        ProgressManager.checkCanceled();
        OSProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            GeneralCommandLine commandLine = TailwindService.createCommandLine(this.myProject, node, tailwindProjectInfo);
            processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
            processHandler.addProcessListener(this.createProcessListener(tailwindProjectInfo));
            processHandler.startNotify();
            this.myProcessHandler = processHandler;
        }
        OSProcessHandler oSProcessHandler = processHandler;
        // MONITOREXIT : object
        if (oSProcessHandler != null) return oSProcessHandler;
        TailwindService.$$$reportNull$$$0(23);
        return oSProcessHandler;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull Project project, @NotNull NodeJsInterpreter node, @NotNull TailwindProjectInfo tailwindProjectInfo) throws ExecutionException {
        if (project == null) {
            TailwindService.$$$reportNull$$$0(24);
        }
        if (node == null) {
            TailwindService.$$$reportNull$$$0(25);
        }
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(26);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withCharset(StandardCharsets.UTF_8);
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.create((Project)project, (VirtualFile)tailwindProjectInfo.myPackageJsonFile, (String)TAILWIND_CSS_PACKAGE_NAME, (boolean)true, (boolean)false);
        if (yarnPnpNodePackage != null) {
            yarnPnpNodePackage.addYarnRunToCommandLine(commandLine, project, node, TAILWIND_CSS_PACKAGE_NAME);
        } else {
            commandLine.addParameters(new String[]{FileUtil.toSystemDependentName((String)tailwindProjectInfo.myTailwindCssBinFile.getPath())});
        }
        commandLine.addParameters(new String[]{"build"});
        if (tailwindProjectInfo.myTailwindCssFile.isInLocalFileSystem()) {
            commandLine.addParameters(new String[]{FileUtil.toSystemDependentName((String)tailwindProjectInfo.myTailwindCssFile.getPath())});
        } else {
            File tempFile = TailwindService.createTemporaryTailwindCssFile();
            commandLine.addParameters(new String[]{tempFile.getPath()});
        }
        if (tailwindProjectInfo.myTailwindConfigFile != null) {
            commandLine.addParameters(new String[]{"--config", FileUtil.toSystemDependentName((String)tailwindProjectInfo.myTailwindConfigFile.getName())});
            commandLine.setWorkDirectory(tailwindProjectInfo.myTailwindConfigFile.getParent().getPath());
        } else {
            commandLine.setWorkDirectory(tailwindProjectInfo.myPackageJsonFile.getParent().getPath());
        }
        NodeCommandLineConfigurator.find((NodeJsInterpreter)node).configure(commandLine, NodeCommandLineConfigurator.defaultOptions((Project)project));
        LOG.debug("Starting [" + commandLine.getCommandLineString() + "] in " + commandLine.getWorkDirectory().getPath());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TailwindService.$$$reportNull$$$0(27);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File createTemporaryTailwindCssFile() throws ExecutionException {
        File tempFile = new File(FileUtil.getTempDirectory() + "/intellij-tailwindcss-temporary-file.css");
        if (!FileUtil.createIfDoesntExist((File)tempFile)) {
            throw new ExecutionException(IdeBundle.message((String)"new.file.failed.error", (Object[])new Object[]{tempFile.getPath()}));
        }
        try {
            FileUtil.writeToFile((File)tempFile, (String)"@tailwind base;\n@tailwind components;\n@tailwind utilities;\n");
        }
        catch (IOException e) {
            throw new ExecutionException(IdeBundle.message((String)"file.write.error", (Object[])new Object[]{tempFile.getPath(), ": " + e.getMessage()}));
        }
        File file = tempFile;
        if (file == null) {
            TailwindService.$$$reportNull$$$0(28);
        }
        return file;
    }

    private ProcessListener createProcessListener(final @NotNull TailwindProjectInfo tailwindProjectInfo) {
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(29);
        }
        final long configFileModStamp = TailwindService.getTailwindConfigModStamp(tailwindProjectInfo.myTailwindConfigFile);
        return new ProcessAdapter(){
            private final TailwindCssParser parser;
            private final StringBuilder stderr;
            {
                this.parser = new TailwindCssParser(TailwindService.this.myProject);
                this.stderr = new StringBuilder();
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputType.STDOUT) {
                    this.parser.appendText(event.getText());
                } else if (outputType == ProcessOutputType.STDERR) {
                    this.stderr.append(event.getText());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(@NotNull ProcessEvent event) {
                Object object;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                try {
                    if (event.getExitCode() == 0) {
                        LOG.debug("Exit code: 0. Output size = " + this.parser.getTotalTextLength());
                        this.parser.textFinished();
                        object = TailwindService.this.myCacheLock;
                        synchronized (object) {
                            Map<String, List<CssClassInfo>> cssClasses = this.parser.getParsedCssClassesInfo();
                            LOG.debug("Caching results for " + TailwindService.getPathForCache(tailwindProjectInfo) + ", size = " + cssClasses.size());
                            TailwindService.this.myCache = new CachedInfo(tailwindProjectInfo, configFileModStamp, cssClasses);
                        }
                    } else {
                        String err = this.stderr.length() > 500 ? this.stderr.substring(0, 500) : this.stderr.toString();
                        LOG.debug("Exit code: " + event.getExitCode() + ". Output: " + err);
                    }
                    File tempFile = new File(FileUtil.getTempDirectory() + "/intellij-tailwindcss-temporary-file.css");
                    if (tempFile.exists()) {
                        FileUtil.delete((File)tempFile);
                    }
                }
                finally {
                    object = TailwindService.this.myProcessHandlerLock;
                    synchronized (object) {
                        TailwindService.this.myProcessHandler = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/tailwind/service/TailwindService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void waitForProcessFinishCheckingIfCancelled(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            TailwindService.$$$reportNull$$$0(30);
        }
        ProgressManager.checkCanceled();
        long t0 = System.currentTimeMillis();
        while (!processHandler.waitFor(10L)) {
            ProgressManager.checkCanceled();
            if (System.currentTimeMillis() - t0 <= 30000L) continue;
            LOG.warn("Process hasn't finished in 30 seconds: " + processHandler.getCommandLine());
            processHandler.destroyProcess();
        }
    }

    @NotNull
    @NonNls
    private static String getPathForCache(@NotNull TailwindProjectInfo tailwindProjectInfo) {
        if (tailwindProjectInfo == null) {
            TailwindService.$$$reportNull$$$0(31);
        }
        String string = tailwindProjectInfo.myTailwindConfigFile != null ? tailwindProjectInfo.myTailwindConfigFile.getPath() : tailwindProjectInfo.myPackageJsonFile.getParent().getPath();
        if (string == null) {
            TailwindService.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static long getTailwindConfigModStamp(@Nullable VirtualFile tailwindConfigFile) {
        return tailwindConfigFile != null ? tailwindConfigFile.getModificationStamp() : -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 23: 
            case 27: 
            case 28: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 23: 
            case 27: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 23: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/service/TailwindService";
                break;
            }
            case 4: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssClassName";
                break;
            }
            case 10: 
            case 20: 
            case 22: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailwindProjectInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFileOrDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/service/TailwindService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCssClassInfos";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssClassInfos";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningProcessOrStartNew";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryTailwindCssFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 23: 
            case 27: 
            case 28: 
            case 32: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureTailwindConfigFileSaved";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllCssClassInfos";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCssClassInfos";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCacheIfUpToDate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTailwindProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTailwindProjectInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTailwindConfigFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTailwindCssPackageDir";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoriesUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runTailwind";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRunningProcessOrStartNew";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createProcessListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "waitForProcessFinishCheckingIfCancelled";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPathForCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 23: 
            case 27: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CssClassInfo {
        @NotNull
        public final String mySelector;
        @Nullable
        public final String myMediumList;
        @Nullable
        public final String myChildMediumList;
        @NotNull
        public final List<Couple<String>> myProperties;

        CssClassInfo(@NotNull String selector, @Nullable String mediumList, @Nullable String childMediumList, @NotNull List<Couple<String>> properties) {
            if (selector == null) {
                CssClassInfo.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                CssClassInfo.$$$reportNull$$$0(1);
            }
            this.mySelector = selector;
            this.myMediumList = mediumList;
            this.myChildMediumList = childMediumList;
            this.myProperties = properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/service/TailwindService$CssClassInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TailwindProjectInfo {
        @Nullable
        public final VirtualFile myTailwindConfigFile;
        @NotNull
        public final VirtualFile myPackageJsonFile;
        @NotNull
        public final VirtualFile myTailwindPackageDir;
        @NotNull
        public final VirtualFile myTailwindCssFile;
        @NotNull
        public final VirtualFile myTailwindCssBinFile;

        private TailwindProjectInfo(@Nullable VirtualFile tailwindConfigFile, @NotNull VirtualFile packageJsonFile, @NotNull VirtualFile tailwindPackageDir, @NotNull VirtualFile tailwindCssFile, @NotNull VirtualFile tailwindCssBinFile) {
            if (packageJsonFile == null) {
                TailwindProjectInfo.$$$reportNull$$$0(0);
            }
            if (tailwindPackageDir == null) {
                TailwindProjectInfo.$$$reportNull$$$0(1);
            }
            if (tailwindCssFile == null) {
                TailwindProjectInfo.$$$reportNull$$$0(2);
            }
            if (tailwindCssBinFile == null) {
                TailwindProjectInfo.$$$reportNull$$$0(3);
            }
            this.myTailwindConfigFile = tailwindConfigFile;
            this.myPackageJsonFile = packageJsonFile;
            this.myTailwindPackageDir = tailwindPackageDir;
            this.myTailwindCssFile = tailwindCssFile;
            this.myTailwindCssBinFile = tailwindCssBinFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageJsonFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tailwindPackageDir";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tailwindCssFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tailwindCssBinFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/service/TailwindService$TailwindProjectInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CachedInfo {
        @NotNull
        private final String myPathForCache;
        private final long myTailwindConfigModStamp;
        @NotNull
        private final Map<String, List<CssClassInfo>> myCssClasses;

        /*
         * WARNING - void declaration
         */
        private CachedInfo(@NotNull TailwindProjectInfo tailwindProjectInfo, long tailwindConfigModStamp, @NotNull Map<String, List<CssClassInfo>> map) {
            void cssClasses;
            if (tailwindProjectInfo == null) {
                CachedInfo.$$$reportNull$$$0(0);
            }
            if (map == null) {
                CachedInfo.$$$reportNull$$$0(1);
            }
            this.myPathForCache = TailwindService.getPathForCache(tailwindProjectInfo);
            this.myTailwindConfigModStamp = tailwindConfigModStamp;
            this.myCssClasses = cssClasses;
        }

        private boolean isUpToDate() {
            return this.myTailwindConfigModStamp == -1L || this.myTailwindConfigModStamp == TailwindService.getTailwindConfigModStamp(LocalFileSystem.getInstance().findFileByPath(this.myPathForCache));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tailwindProjectInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cssClasses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/service/TailwindService$CachedInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

