/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.service;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixList;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.tailwind.service.TailwindService;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TailwindCssParser {
    private static final Logger LOG = Logger.getInstance(TailwindCssParser.class);
    private final Project myProject;
    private final Map<String, List<TailwindService.CssClassInfo>> myParsedCssClasses;
    private int myTotalLength;
    private int myBraceCount;
    private final StringBuilder myBuffer;

    TailwindCssParser(@NotNull Project project) {
        if (project == null) {
            TailwindCssParser.$$$reportNull$$$0(0);
        }
        this.myParsedCssClasses = new HashMap<String, List<TailwindService.CssClassInfo>>();
        this.myBuffer = new StringBuilder();
        this.myProject = project;
    }

    void appendText(@NotNull String text) {
        if (text == null) {
            TailwindCssParser.$$$reportNull$$$0(1);
        }
        this.myTotalLength += text.length();
        this.myBuffer.ensureCapacity(this.myBuffer.length() + text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            this.myBuffer.append(ch);
            if (ch == '{') {
                ++this.myBraceCount;
            }
            if (ch != '}') continue;
            --this.myBraceCount;
            if (this.myBraceCount == 0) {
                String generatedCss = this.myBuffer.toString();
                this.myBuffer.delete(0, this.myBuffer.length());
                this.handleGeneratedCss(generatedCss, this.myParsedCssClasses);
                continue;
            }
            if (this.myBraceCount >= 0) continue;
            this.myBraceCount = 0;
            LOG.warn("Unbalanced braces");
        }
    }

    void textFinished() {
        String generatedCss = this.myBuffer.toString();
        this.myBuffer.delete(0, this.myBuffer.length());
        this.handleGeneratedCss(generatedCss, this.myParsedCssClasses);
    }

    int getTotalTextLength() {
        return this.myTotalLength;
    }

    @NotNull
    Map<String, List<TailwindService.CssClassInfo>> getParsedCssClassesInfo() {
        Map<String, List<TailwindService.CssClassInfo>> map = this.myParsedCssClasses;
        if (map == null) {
            TailwindCssParser.$$$reportNull$$$0(2);
        }
        return map;
    }

    private void handleGeneratedCss(final @NotNull String generatedCss, final @NotNull Map<String, List<TailwindService.CssClassInfo>> cssClasses) {
        if (generatedCss == null) {
            TailwindCssParser.$$$reportNull$$$0(3);
        }
        if (cssClasses == null) {
            TailwindCssParser.$$$reportNull$$$0(4);
        }
        PsiFile generatedPsiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((Language)CSSLanguage.INSTANCE, (CharSequence)generatedCss));
        generatedPsiFile.accept((PsiElementVisitor)new CssElementVisitor(){
            @Nullable
            private String myMediumListText;
            @Nullable
            private String myChildMediumListText;

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof CssSelectorSuffixList) {
                    this.visitCssSelectorSuffixList((CssSelectorSuffixList)element);
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitCssBlock(CssBlock block) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitAtRule(CssAtRule atRule) {
                CssMediumList mediumList;
                if (atRule instanceof CssMedia && (mediumList = ((CssMedia)atRule).getMediumList()) != null) {
                    if (this.myMediumListText == null) {
                        this.myMediumListText = mediumList.getTextRange().substring(generatedCss);
                        try {
                            super.visitAtRule(atRule);
                        }
                        finally {
                            this.myMediumListText = null;
                        }
                    }
                    this.myChildMediumListText = mediumList.getTextRange().substring(generatedCss);
                    try {
                        super.visitAtRule(atRule);
                    }
                    finally {
                        this.myChildMediumListText = null;
                    }
                }
            }

            private void visitCssSelectorSuffixList(CssSelectorSuffixList suffixList) {
                CssBlock block;
                CssSelector selector = (CssSelector)PsiTreeUtil.getParentOfType((PsiElement)suffixList, CssSelector.class);
                if (selector == null) {
                    return;
                }
                List suffixes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)suffixList, CssSelectorSuffix.class);
                if (ContainerUtil.exists((Iterable)suffixes, suffix -> suffix instanceof CssPseudoSelector && ((CssPseudoSelector)suffix).getName().startsWith("-"))) {
                    return;
                }
                List classes = ContainerUtil.mapNotNull((Collection)suffixes, suffix -> suffix instanceof CssClass ? suffix.getName() : null);
                if (classes.isEmpty()) {
                    return;
                }
                CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)selector, CssRuleset.class);
                CssBlock cssBlock = block = ruleset != null ? ruleset.getBlock() : null;
                if (block == null) {
                    return;
                }
                SmartList properties = new SmartList();
                for (CssDeclaration declaration : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)block, CssDeclaration.class)) {
                    CssTermList value = declaration.getValue();
                    if (value == null) continue;
                    properties.add(Couple.of((Object)declaration.getPropertyName(), (Object)value.getTextRange().substring(generatedCss)));
                }
                String selectorText = selector.getTextRange().substring(generatedCss);
                TailwindService.CssClassInfo classInfo = new TailwindService.CssClassInfo(selectorText, this.myMediumListText, this.myChildMediumListText, (List<Couple<String>>)properties);
                for (String cssClass : classes) {
                    List infos = (List)cssClasses.get(cssClass);
                    if (infos != null) {
                        infos.add(classInfo);
                        continue;
                    }
                    cssClasses.put(cssClass, new SmartList((Object)classInfo));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tailwind/service/TailwindCssParser$1", "visitElement"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/service/TailwindCssParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedCss";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/service/TailwindCssParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsedCssClassesInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleGeneratedCss";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

