/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.completion.CssClassOrIdReferenceCompletionContributor;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.tailwind.completion.TailwindLookupObject;
import com.intellij.tailwind.documentation.TailwindFakeCssClass;
import com.intellij.tailwind.service.TailwindService;
import com.intellij.tailwind.util.TailwindUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailwindDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (element != null && object instanceof TailwindLookupObject) {
            return new TailwindFakeCssClass(((TailwindLookupObject)object).getCssClassName(), element);
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        HtmlCssClassOrIdReference reference;
        PsiElement tag;
        if (editor == null) {
            TailwindDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TailwindDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            return null;
        }
        PsiElement parent = contextElement.getParent();
        if (parent instanceof CssAtRule && "@apply".equals(((CssAtRule)parent).getName())) {
            if (targetOffset > 0 && targetOffset == contextElement.getTextRange().getStartOffset() && (contextElement instanceof PsiWhiteSpace || contextElement.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON)) {
                contextElement = file.findElementAt(targetOffset - 1);
            }
            if (contextElement != null && TailwindUtil.canBeTailwindCssClassNamePart(contextElement)) {
                int endIndex;
                PsiElement nameStart = TailwindUtil.getFirstElementInTailwindClassName(contextElement);
                PsiElement nameEnd = TailwindUtil.getLastElementInTailwindClassName(contextElement);
                int startIndex = nameStart.getStartOffsetInParent();
                if (startIndex <= (endIndex = nameEnd.getStartOffsetInParent() + nameEnd.getTextLength()) && endIndex <= parent.getTextLength()) {
                    String cssClassName = parent.getText().substring(startIndex, endIndex);
                    return new TailwindFakeCssClass(cssClassName, contextElement);
                }
            }
            return null;
        }
        if (parent instanceof XmlAttributeValue && contextElement.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && (tag = contextElement.getParent().getParent()) instanceof XmlAttribute && (((XmlAttribute)tag).getName().equals("class") || ((XmlAttribute)tag).getName().equals("className")) && (reference = CssClassOrIdReferenceCompletionContributor.getCssClassOrIdReference((int)targetOffset, (PsiFile)file)) != null) {
            return new TailwindFakeCssClass(reference.getCanonicalText(), contextElement);
        }
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (element instanceof TailwindFakeCssClass) {
            return Collections.emptyList();
        }
        return null;
    }

    @Nullable
    @NlsSafe
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        if (element instanceof TailwindFakeCssClass) {
            String cssClassName = ((TailwindFakeCssClass)element).getCssClassName();
            List<TailwindService.CssClassInfo> cssClassInfos = TailwindService.getInstance(element.getProject()).getCssClassInfos(element, cssClassName);
            if (cssClassInfos.isEmpty()) {
                return null;
            }
            HtmlBuilder builder = new HtmlBuilder();
            for (TailwindService.CssClassInfo info : cssClassInfos) {
                if (!builder.isEmpty()) {
                    builder.append((HtmlChunk)HtmlChunk.br());
                }
                builder.append((HtmlChunk)HtmlChunk.text((String)TailwindDocumentationProvider.getCssClassPreviewText(info)).wrapWith("pre"));
            }
            return builder.wrapWithHtmlBody().toString();
        }
        return null;
    }

    @NotNull
    @NlsSafe
    private static String getCssClassPreviewText(@NotNull TailwindService.CssClassInfo info) {
        if (info == null) {
            TailwindDocumentationProvider.$$$reportNull$$$0(2);
        }
        Object indent = "";
        StringBuilder textStart = new StringBuilder();
        StringBuilder textEnd = new StringBuilder();
        if (info.myMediumList != null) {
            textStart.append("@media ").append(info.myMediumList).append(" {\n");
            textEnd.append("}\n");
            indent = "  ";
            if (info.myChildMediumList != null) {
                textStart.append("  @media ").append(info.myChildMediumList).append(" {\n");
                textEnd.insert(0, "  }\n");
                indent = "    ";
            }
        }
        textStart.append((String)indent).append(info.mySelector).append(" {\n");
        textEnd.insert(0, "}\n").insert(0, (String)indent);
        indent = (String)indent + "  ";
        for (Couple<String> propertyNameAndValue : info.myProperties) {
            textStart.append((String)indent).append((String)propertyNameAndValue.first).append(": ").append((String)propertyNameAndValue.second).append(";\n");
        }
        String string = textStart.toString() + textEnd.toString();
        if (string == null) {
            TailwindDocumentationProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/documentation/TailwindDocumentationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/documentation/TailwindDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssClassPreviewText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCssClassPreviewText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

