/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.completion.CssDumbAwareCompletionContributor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.tailwind.completion.TailwindClassInHtmlCompletionContributor;
import com.intellij.tailwind.completion.TailwindDirectivesCompletionProvider;
import com.intellij.tailwind.service.TailwindService;
import com.intellij.tailwind.util.TailwindUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TailwindInCssCompletionContributor
extends CompletionContributor
implements DumbAware {
    public TailwindInCssCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_GENERIC_AT_RULE).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("@apply"))), new TailwindClassesInApplyAtRuleCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.atKeyword(), new TailwindDirectivesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_ATKEYWORD).withText((ElementPattern)StandardPatterns.string().oneOf(new String[]{"@tailwind", "@layer", "@variants"}))), new TailwindDirectivesCompletionProvider.AfterDirectiveCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_COMMA))).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_GENERIC_AT_RULE).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("@variants"))), new TailwindDirectivesCompletionProvider.AfterDirectiveCompletionProvider());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement parent;
        PsiElement psiElement;
        if (context == null) {
            TailwindInCssCompletionContributor.$$$reportNull$$$0(0);
        }
        PsiElement prevSibling = (psiElement = context.getFile().findElementAt(context.getStartOffset())) != null ? psiElement.getPrevSibling() : null;
        PsiElement psiElement2 = parent = psiElement != null ? psiElement.getParent() : null;
        if (parent instanceof CssAtRule && "@apply".equals(((CssAtRule)parent).getName()) || prevSibling instanceof CssAtRule && "@apply".equals(((CssAtRule)prevSibling).getName())) {
            TailwindInCssCompletionContributor.fixReplacementOffsetForTailwindClassNameInApplyAtRule(context, psiElement);
            VirtualFile file = context.getFile().getVirtualFile();
            if (file != null) {
                TailwindService.ensureTailwindConfigFileSaved(context.getProject(), file);
            }
        }
    }

    private static void fixReplacementOffsetForTailwindClassNameInApplyAtRule(@NotNull CompletionInitializationContext context, @NotNull PsiElement psiElement) {
        if (context == null) {
            TailwindInCssCompletionContributor.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            TailwindInCssCompletionContributor.$$$reportNull$$$0(2);
        }
        PsiElement identEnd = TailwindUtil.getLastElementInTailwindClassName(psiElement);
        context.setReplacementOffset(identEnd.getTextRange().getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tailwind/completion/TailwindInCssCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixReplacementOffsetForTailwindClassNameInApplyAtRule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TailwindClassesInApplyAtRuleCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private TailwindClassesInApplyAtRuleCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement psiElement;
            if (parameters == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((psiElement = parameters.getPosition()) instanceof LeafPsiElement) || psiElement.getNode().getElementType() != CssElementTypes.CSS_IDENT) {
                return;
            }
            Map<String, List<TailwindService.CssClassInfo>> infos = TailwindService.getInstance(psiElement.getProject()).getAllCssClassInfos(psiElement);
            if (infos.isEmpty()) {
                return;
            }
            CompletionResultSet resultSetWithPrefix = TailwindClassesInApplyAtRuleCompletionProvider.fixPrefixForTailwindClassNameInApplyAtRule(parameters, result);
            TailwindClassInHtmlCompletionContributor.addTailwindCssClassLookupItems(resultSetWithPrefix, infos);
        }

        @NotNull
        private static CompletionResultSet fixPrefixForTailwindClassNameInApplyAtRule(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            int endIndex;
            if (parameters == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(4);
            }
            PsiElement identStart = TailwindUtil.getFirstElementInTailwindClassName(parameters.getPosition());
            PsiElement parent = identStart.getParent();
            int startIndex = identStart.getStartOffsetInParent();
            if (startIndex <= (endIndex = parameters.getOffset() - parent.getTextRange().getStartOffset()) && endIndex <= parent.getTextLength()) {
                String prefix = parent.getText().substring(startIndex, endIndex);
                CompletionResultSet completionResultSet = result.getPrefixMatcher().getPrefix().equals(prefix) ? result : result.withPrefixMatcher(prefix);
                if (completionResultSet == null) {
                    TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(5);
                }
                return completionResultSet;
            }
            CompletionResultSet completionResultSet = result;
            if (completionResultSet == null) {
                TailwindClassesInApplyAtRuleCompletionProvider.$$$reportNull$$$0(6);
            }
            return completionResultSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tailwind/completion/TailwindInCssCompletionContributor$TailwindClassesInApplyAtRuleCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tailwind/completion/TailwindInCssCompletionContributor$TailwindClassesInApplyAtRuleCompletionProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixPrefixForTailwindClassNameInApplyAtRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fixPrefixForTailwindClassNameInApplyAtRule";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

