/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.completion.CssAddSpaceWithBracesInsertHandler;
import com.intellij.psi.css.impl.util.completion.provider.CssAtKeywordsCompletionProvider;
import com.intellij.psi.css.util.CssEditorUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.tailwind.service.TailwindService;
import com.intellij.util.ProcessingContext;
import icons.TailwindcssIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailwindDirectivesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> DIRECTIVE_WITH_SPACE_AND_COMPLETION_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            context.setAddCompletionChar(false);
            Editor editor = context.getEditor();
            CssEditorUtil.typeOrMove((Editor)editor, (char)' ');
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(editor, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/completion/TailwindDirectivesCompletionProvider$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(2);
        }
        VirtualFile file = parameters.getOriginalFile().getVirtualFile();
        if (!TailwindService.isTailwindProject(parameters.getPosition().getProject(), file)) {
            return;
        }
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), CssAtRule.class);
        if (atRule == null) {
            return;
        }
        if (atRule.getParent() instanceof CssRulesetList && atRule.getParent().getParent() instanceof CssStylesheet) {
            TailwindDirectivesCompletionProvider.addTopLevelDirectives(parameters, TailwindDirectivesCompletionProvider.getResultWithAtRuleAwarePrefix(parameters, result));
            return;
        }
        if (atRule.getParent() instanceof CssBlock && atRule.getParent().getParent() instanceof CssRuleset) {
            TailwindDirectivesCompletionProvider.getResultWithAtRuleAwarePrefix(parameters, result).addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@apply", DIRECTIVE_WITH_SPACE_AND_COMPLETION_INSERT_HANDLER));
            return;
        }
        if (atRule.getParent() instanceof CssBlock && atRule.getParent().getParent() instanceof CssAtRule && ((CssAtRule)atRule.getParent().getParent()).getName().equals("@layer") || atRule.getParent() instanceof CssAtRule && ((CssAtRule)atRule.getParent()).getName().equals("@layer")) {
            boolean indentBased = CssPsiUtil.isIndentBasedCssLanguage((PsiElement)parameters.getPosition());
            TailwindDirectivesCompletionProvider.getResultWithAtRuleAwarePrefix(parameters, result).addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@variants", (InsertHandler<LookupElement>)new CssAddSpaceWithBracesInsertHandler(indentBased)));
        }
    }

    @NotNull
    private static CompletionResultSet getResultWithAtRuleAwarePrefix(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position;
        IElementType type;
        if (parameters == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((type = (position = parameters.getPosition()).getNode().getElementType()) == CssElementTypes.CSS_ATKEYWORD) {
            String positionText = position.getText();
            int prefixShift = parameters.getOffset() - position.getTextRange().getStartOffset();
            if (0 < prefixShift && prefixShift < positionText.length()) {
                CompletionResultSet completionResultSet = result.withPrefixMatcher(positionText.substring(0, prefixShift));
                if (completionResultSet == null) {
                    TailwindDirectivesCompletionProvider.$$$reportNull$$$0(5);
                }
                return completionResultSet;
            }
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(6);
        }
        return completionResultSet;
    }

    private static void addTopLevelDirectives(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String semicolon;
        if (parameters == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(7);
        }
        if (result == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(8);
        }
        TailwindDirectivesInfo info = TailwindDirectivesInfo.getTailwindDirectivesInfo(parameters.getOriginalFile());
        boolean indentBased = CssPsiUtil.isIndentBasedCssLanguage((PsiElement)parameters.getPosition());
        String string = semicolon = indentBased ? "" : ";";
        if (!info.hasTailwindBase) {
            result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@tailwind base" + semicolon, null));
        }
        if (!info.hasTailwindComponents) {
            result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@tailwind components" + semicolon, null));
        }
        if (!info.hasTailwindUtilities) {
            result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@tailwind utilities" + semicolon, null));
        }
        if (!info.hasTailwindScreens) {
            result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@tailwind screens" + semicolon, null));
        }
        CssAtKeywordsCompletionProvider.CssAddBracesInsertHandler bracesInsertHandler = new CssAtKeywordsCompletionProvider.CssAddBracesInsertHandler(indentBased);
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@layer base", (InsertHandler<LookupElement>)bracesInsertHandler));
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@layer components", (InsertHandler<LookupElement>)bracesInsertHandler));
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@layer utilities", (InsertHandler<LookupElement>)bracesInsertHandler));
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@variants", (InsertHandler<LookupElement>)new CssAddSpaceWithBracesInsertHandler(indentBased)));
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@responsive", (InsertHandler<LookupElement>)bracesInsertHandler));
        result.addElement(TailwindDirectivesCompletionProvider.createDirectiveLookup("@screen", (InsertHandler<LookupElement>)new CssAtKeywordsCompletionProvider.AddSpaceParensAndBracesInsertHandler(indentBased)));
    }

    private static LookupElement createDirectiveLookup(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (lookupString == null) {
            TailwindDirectivesCompletionProvider.$$$reportNull$$$0(9);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).bold().withIcon(TailwindcssIcons.Tailwind_16).withInsertHandler(insertHandler);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)20.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/completion/TailwindDirectivesCompletionProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/completion/TailwindDirectivesCompletionProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultWithAtRuleAwarePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResultWithAtRuleAwarePrefix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTopLevelDirectives";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDirectiveLookup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TailwindDirectivesInfo {
        private final boolean hasTailwindBase;
        private final boolean hasTailwindComponents;
        private final boolean hasTailwindUtilities;
        private final boolean hasTailwindScreens;

        private TailwindDirectivesInfo(boolean base, boolean components, boolean utilities, boolean screens) {
            this.hasTailwindBase = base;
            this.hasTailwindComponents = components;
            this.hasTailwindUtilities = utilities;
            this.hasTailwindScreens = screens;
        }

        @NotNull
        private static TailwindDirectivesInfo getTailwindDirectivesInfo(@Nullable PsiFile originalFile) {
            if (!(originalFile instanceof StylesheetFile)) {
                return new TailwindDirectivesInfo(false, false, false, false);
            }
            CssRulesetList rulesetList = ((StylesheetFile)originalFile).getStylesheet().getRulesetList();
            boolean hasTailwindBase = false;
            boolean hasTailwindComponents = false;
            boolean hasTailwindUtilities = false;
            boolean hasTailwindScreens = false;
            for (CssAtRule atRule : rulesetList.getAtRules()) {
                if (!atRule.getName().equals("@tailwind")) continue;
                PsiElement child = atRule.getFirstChild().getNextSibling();
                while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
                    child = child.getNextSibling();
                }
                if (child == null || child.getNode().getElementType() != CssElementTypes.CSS_IDENT) continue;
                String text = child.getText();
                if ("base".equals(text)) {
                    hasTailwindBase = true;
                }
                if ("components".equals(text)) {
                    hasTailwindComponents = true;
                }
                if ("utilities".equals(text)) {
                    hasTailwindUtilities = true;
                }
                if (!"screens".equals(text)) continue;
                hasTailwindScreens = true;
            }
            return new TailwindDirectivesInfo(hasTailwindBase, hasTailwindComponents, hasTailwindUtilities, hasTailwindScreens);
        }
    }

    public static class AfterDirectiveCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement atRule;
            if (parameters == null) {
                AfterDirectiveCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                AfterDirectiveCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                AfterDirectiveCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((atRule = parameters.getPosition().getParent()) instanceof CssAtRule)) {
                return;
            }
            String name = ((CssAtRule)atRule).getName();
            if ("@tailwind".equals(name)) {
                TailwindDirectivesInfo info = TailwindDirectivesInfo.getTailwindDirectivesInfo(parameters.getOriginalFile());
                if (!info.hasTailwindBase) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"base"));
                }
                if (!info.hasTailwindComponents) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"components"));
                }
                if (!info.hasTailwindUtilities) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"utilities"));
                }
                if (!info.hasTailwindScreens) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"screens"));
                }
                return;
            }
            if ("@layer".equals(name)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)"base"));
                result.addElement((LookupElement)LookupElementBuilder.create((String)"components"));
                result.addElement((LookupElement)LookupElementBuilder.create((String)"utilities"));
            }
            if ("@variants".equals(name)) {
                boolean hasResponsive = false;
                boolean hasHover = false;
                boolean hasFocus = false;
                boolean hasActive = false;
                for (PsiElement child : atRule.getChildren()) {
                    if (child.getNode().getElementType() != CssElementTypes.CSS_IDENT) continue;
                    String text = child.getText();
                    if ("responsive".equals(text)) {
                        hasResponsive = true;
                    }
                    if ("hover".equals(text)) {
                        hasHover = true;
                    }
                    if ("focus".equals(text)) {
                        hasFocus = true;
                    }
                    if (!"active".equals(text)) continue;
                    hasActive = true;
                }
                if (!hasResponsive) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"responsive"));
                }
                if (!hasHover) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"hover"));
                }
                if (!hasFocus) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"focus"));
                }
                if (!hasActive) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"active"));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/completion/TailwindDirectivesCompletionProvider$AfterDirectiveCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

