/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.completion.CssClassOrIdReferenceCompletionContributor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.tailwind.TailwindCssBundle;
import com.intellij.tailwind.completion.TailwindLookupObject;
import com.intellij.tailwind.service.TailwindService;
import com.intellij.ui.ColorHexUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.ColorIconCache;
import icons.TailwindcssIcons;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailwindClassInHtmlCompletionContributor
extends CompletionContributor
implements DumbAware {
    public TailwindClassInHtmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(XmlAttribute.class).withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"class", "className"})))).with(CssClassOrIdReferenceCompletionContributor.HTML_CLASS_OR_ID_REFERENCE_PATTERN), new TailwindClassesCompletionProvider());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        VirtualFile file;
        PsiElement parentParent;
        PsiElement element;
        if (context == null) {
            TailwindClassInHtmlCompletionContributor.$$$reportNull$$$0(0);
        }
        PsiElement parent = (element = context.getFile().findElementAt(context.getStartOffset())) != null ? element.getParent() : null;
        PsiElement psiElement = parentParent = parent != null ? parent.getParent() : null;
        if (parent instanceof XmlAttributeValue && parentParent instanceof XmlAttribute && (((XmlAttribute)parentParent).getName().equals("class") || ((XmlAttribute)parentParent).getName().equals("className")) && CssClassOrIdReferenceCompletionContributor.getCssClassOrIdReference((int)context.getStartOffset(), (PsiFile)context.getFile()) != null && (file = context.getFile().getVirtualFile()) != null) {
            TailwindService.ensureTailwindConfigFileSaved(context.getProject(), file);
        }
    }

    @Nullable
    @NlsSafe
    private static String getPropertiesPreviewText(@NotNull List<TailwindService.CssClassInfo> infos) {
        if (infos == null) {
            TailwindClassInHtmlCompletionContributor.$$$reportNull$$$0(1);
        }
        if (infos.size() == 0) {
            return null;
        }
        if (infos.size() > 1) {
            return TailwindCssBundle.message("0.rules", infos.size());
        }
        TailwindService.CssClassInfo info = infos.get(0);
        if (info.myProperties.size() == 0) {
            return null;
        }
        if (info.myProperties.size() > 1) {
            for (Couple<String> propertyNameAndValue : info.myProperties) {
                if (((String)propertyNameAndValue.first).startsWith("-")) continue;
                return (String)propertyNameAndValue.first + ": " + (String)propertyNameAndValue.second + ";\u2026";
            }
        }
        Couple<String> propertyNameAndValue = info.myProperties.get(0);
        if (info.myProperties.size() > 1) {
            return (String)propertyNameAndValue.first + ": " + (String)propertyNameAndValue.second + ";\u2026";
        }
        return (String)propertyNameAndValue.first + ": " + (String)propertyNameAndValue.second;
    }

    @Nullable
    private static Icon getColorIcon(@NotNull List<TailwindService.CssClassInfo> infos) {
        if (infos == null) {
            TailwindClassInHtmlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (infos.size() != 1) {
            return null;
        }
        TailwindService.CssClassInfo info = infos.get(0);
        Color color = null;
        for (Couple<String> propertyNameAndValue : info.myProperties) {
            int lastCommaIndex;
            String args;
            String propertyValue = (String)propertyNameAndValue.second;
            if (propertyValue.startsWith("#")) {
                try {
                    color = ColorHexUtil.fromHex((String)propertyValue);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            if (propertyValue.startsWith("rgb(") && propertyValue.endsWith(")")) {
                args = propertyValue.substring("rgb(".length(), propertyValue.length() - 1);
                color = CssPsiColorUtil.getColorInRGBsFunctions((String)args);
                break;
            }
            if (!propertyValue.startsWith("rgba(") || !propertyValue.endsWith(")") || (lastCommaIndex = (args = propertyValue.substring("rgba(".length(), propertyValue.length() - 1)).lastIndexOf(",")) <= 0) continue;
            String lastArg = args.substring(lastCommaIndex);
            if (lastArg.contains("var(--")) {
                args = args.substring(0, lastCommaIndex);
            }
            color = CssPsiColorUtil.getColorInRGBsFunctions((String)args);
            break;
        }
        if (color != null) {
            return ColorIconCache.getIconCache().getIcon(color, 16);
        }
        return null;
    }

    static void addTailwindCssClassLookupItems(@NotNull CompletionResultSet resultSet, @NotNull Map<String, List<TailwindService.CssClassInfo>> cssClassInfos) {
        if (resultSet == null) {
            TailwindClassInHtmlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (cssClassInfos == null) {
            TailwindClassInHtmlCompletionContributor.$$$reportNull$$$0(4);
        }
        for (Map.Entry<String, List<TailwindService.CssClassInfo>> entry : cssClassInfos.entrySet()) {
            String cssClass = entry.getKey();
            Icon colorIcon = TailwindClassInHtmlCompletionContributor.getColorIcon(entry.getValue());
            Icon icon = colorIcon != null ? colorIcon : TailwindcssIcons.Tailwind_16;
            resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)new TailwindLookupObject(cssClass)).withTypeText(TailwindClassInHtmlCompletionContributor.getPropertiesPreviewText(entry.getValue())).withIcon(icon));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssClassInfos";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tailwind/completion/TailwindClassInHtmlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertiesPreviewText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTailwindCssClassLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TailwindClassesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private TailwindClassesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            XmlAttribute attribute;
            String attributeName;
            if (parameters == null) {
                TailwindClassesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TailwindClassesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                TailwindClassesCompletionProvider.$$$reportNull$$$0(2);
            }
            String string = attributeName = (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttribute.class)) != null ? attribute.getName() : null;
            if (!"class".equals(attributeName) && !"className".equals(attributeName)) {
                return;
            }
            Map<String, List<TailwindService.CssClassInfo>> infos = TailwindService.getInstance(parameters.getPosition().getProject()).getAllCssClassInfos(parameters.getPosition());
            TailwindClassInHtmlCompletionContributor.addTailwindCssClassLookupItems(result, infos);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tailwind/completion/TailwindClassInHtmlCompletionContributor$TailwindClassesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

