/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.icons.AllIcons;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class BrowserVersion {
    public static final BrowserVersion[] EMPTY_ARRAY = new BrowserVersion[0];
    public static final Comparator<BrowserVersion> COMPARATOR = Comparator.comparing(o -> o.getBrowser().getPresentableName());
    @NotNull
    private final Browser myBrowser;
    @NotNull
    private final String myVersion;

    public BrowserVersion(@NotNull Browser browser, @NotNull String version) {
        if (browser == null) {
            BrowserVersion.$$$reportNull$$$0(0);
        }
        if (version == null) {
            BrowserVersion.$$$reportNull$$$0(1);
        }
        this.myBrowser = browser;
        this.myVersion = version;
    }

    @NotNull
    public String toString() {
        String string = this.myBrowser.getPresentableName() + " " + this.myVersion;
        if (string == null) {
            BrowserVersion.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            BrowserVersion.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Browser getBrowser() {
        Browser browser = this.myBrowser;
        if (browser == null) {
            BrowserVersion.$$$reportNull$$$0(4);
        }
        return browser;
    }

    @NotNull
    public static BrowserVersion fromString(@NotNull String string) {
        if (string == null) {
            BrowserVersion.$$$reportNull$$$0(5);
        }
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'C': {
                    return new BrowserVersion(Browser.CHROME, string.substring(1));
                }
                case 'F': {
                    return new BrowserVersion(Browser.FIREFOX, string.substring(2));
                }
                case 'I': {
                    return new BrowserVersion(Browser.IE, string.substring(2));
                }
                case 'O': {
                    return new BrowserVersion(Browser.OPERA, string.substring(1));
                }
                case 'S': {
                    return new BrowserVersion(Browser.SAFARI, string.substring(1));
                }
                case 'E': {
                    return new BrowserVersion(Browser.EDGE, string.substring(1));
                }
            }
        }
        throw new IllegalArgumentException("Can't create browser version for " + string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/descriptor/BrowserVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/descriptor/BrowserVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Browser {
        CHROME("Chrome", AllIcons.Xml.Browsers.Chrome),
        FIREFOX("Firefox", AllIcons.Xml.Browsers.Firefox),
        SAFARI("Safari", AllIcons.Xml.Browsers.Safari),
        OPERA("Opera", AllIcons.Xml.Browsers.Opera),
        IE("IE", AllIcons.Xml.Browsers.Explorer),
        EDGE("Edge", AllIcons.Xml.Browsers.Edge);

        @NotNull
        private final Icon myIcon;
        @NotNull
        private final String myPresentableName;

        private Browser(String presentableName, Icon icon) {
            if (presentableName == null) {
                Browser.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                Browser.$$$reportNull$$$0(1);
            }
            this.myIcon = icon;
            this.myPresentableName = presentableName;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                Browser.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                Browser.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/descriptor/BrowserVersion$Browser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/descriptor/BrowserVersion$Browser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

