/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapper;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.GitHashesProjectService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\u001f\u0010\f\u001a\u001b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\b0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/indexing/shared/git/SharedGitHashesService;", "", "()V", "providers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper;", "computeGitHash", "Y", "file", "force", "", "action", "Lkotlin/Function2;", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "registerService", "", "service", "Lcom/intellij/indexing/shared/ultimate/git/GitHashesProjectService;", "lifetime", "Lcom/intellij/openapi/Disposable;", "intellij.indexing.shared.ultimate.git"})
public final class SharedGitHashesService {
    private final ConcurrentHashMap<VirtualFile, GitHashesProjectServiceWrapper> providers = new ConcurrentHashMap();

    public final void registerService(@NotNull GitHashesProjectService service, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!service.isValid()) {
            return;
        }
        VirtualFile virtualFile = service.getGitRootFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile rootFile = virtualFile;
        GitHashesProjectServiceWrapper wrapper = new GitHashesProjectServiceWrapper(rootFile, service, lifetime);
        ((Map)this.providers).put(rootFile, wrapper);
        Disposer.register((Disposable)lifetime, (Disposable)new Disposable(this, rootFile, wrapper){
            final /* synthetic */ SharedGitHashesService this$0;
            final /* synthetic */ VirtualFile $rootFile;
            final /* synthetic */ GitHashesProjectServiceWrapper $wrapper;

            public final void dispose() {
                SharedGitHashesService.access$getProviders$p(this.this$0).remove(this.$rootFile, this.$wrapper);
            }
            {
                this.this$0 = sharedGitHashesService;
                this.$rootFile = virtualFile;
                this.$wrapper = gitHashesProjectServiceWrapper;
            }
        });
    }

    @Nullable
    public final <Y> Y computeGitHash(@NotNull VirtualFile file, boolean force, @NotNull Function2<? super GitBlobSet, ? super VirtualFile, ? extends Y> action) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        for (GitHashesProjectServiceWrapper provider : this.providers.values()) {
            Y hash2 = provider.computeGitHash(file, force, action);
            if (hash2 == null) continue;
            return hash2;
        }
        return null;
    }

    public static /* synthetic */ Object computeGitHash$default(SharedGitHashesService sharedGitHashesService, VirtualFile virtualFile, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sharedGitHashesService.computeGitHash(virtualFile, bl, function2);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProviders$p(SharedGitHashesService $this) {
        return $this.providers;
    }
}

