/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapper;
import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapperDriver;
import com.intellij.indexing.shared.git.GitHashesServiceKt;
import com.intellij.indexing.shared.ultimate.git.GitBlobKey;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0002\u0014 \u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJJ\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u001f\u0010\u001b\u001a\u001b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\"H\u0007R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\rj\b\u0012\u0004\u0012\u00020\u0003`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper;", "", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "driver", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;", "lifetime", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;Lcom/intellij/openapi/Disposable;)V", "blobSetHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "changedFilesList", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "isCollecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "requestsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "vfsListener", "com/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$vfsListener$1", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$vfsListener$1;", "computeGitHash", "Y", "file", "force", "", "action", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "returnObject", "com/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$returnObject$1", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$returnObject$1;", "startCollecting", "ChangeApplier", "intellij.indexing.shared.ultimate.git"})
public final class GitHashesProjectServiceWrapper {
    private final AtomicInteger requestsCount;
    private final AtomicReference<GitBlobSet> blobSetHolder;
    private final AtomicBoolean isCollecting;
    private final HashSet<VirtualFile> changedFilesList;
    private final vfsListener.1 vfsListener;
    private final VirtualFile rootFile;
    private final GitHashesProjectServiceWrapperDriver driver;
    private final Disposable lifetime;

    @Nullable
    public final <Y> Y computeGitHash(@NotNull VirtualFile file, boolean force, @NotNull Function2<? super GitBlobSet, ? super VirtualFile, ? extends Y> action) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!VfsUtil.isAncestor((VirtualFile)this.rootFile, (VirtualFile)file, (boolean)true)) {
            return null;
        }
        GitBlobSet blobSet = this.blobSetHolder.get();
        if (blobSet != null) {
            return (Y)action.invoke((Object)blobSet, (Object)file);
        }
        if (!force && this.requestsCount.incrementAndGet() <= Registry.intValue((String)"shared.index.git.hashes.requestBeforeCompute")) {
            return null;
        }
        if (!this.isCollecting.compareAndSet(false, true)) {
            return null;
        }
        GitHashesServiceKt.access$getLOG$p().info("Starting collecting Git Blob hashes");
        this.startCollecting();
        return null;
    }

    public static /* synthetic */ Object computeGitHash$default(GitHashesProjectServiceWrapper gitHashesProjectServiceWrapper, VirtualFile virtualFile, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return gitHashesProjectServiceWrapper.computeGitHash(virtualFile, bl, function2);
    }

    @VisibleForTesting
    public final void startCollecting() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this.vfsListener, this.lifetime);
        this.driver.resolveGitHashesInBackground((Function1<? super GitBlobSet, Unit>)((Function1)new Function1<GitBlobSet, Unit>(this){
            final /* synthetic */ GitHashesProjectServiceWrapper this$0;

            public final void invoke(@Nullable GitBlobSet it) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this, it){
                    final /* synthetic */ startCollecting.1 this$0;
                    final /* synthetic */ GitBlobSet $it$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$it$inlined = gitBlobSet;
                    }

                    public final void run() {
                        boolean bl = false;
                        GitBlobSet gitBlobSet = this.$it$inlined;
                        GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0.this$0).set(gitBlobSet != null ? gitBlobSet.withIgnoredItems-VirtualFiles(GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this.this$0.this$0)) : null);
                        GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this.this$0.this$0).clear();
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
            {
                this.this$0 = gitHashesProjectServiceWrapper;
                super(1);
            }
        }));
    }

    private final returnObject.1 returnObject(Function0<Unit> action) {
        return new ChangeApplier(action){
            final /* synthetic */ Function0 $action;

            public void beforeVfsChange() {
                this.applyNow();
            }

            public void applyNow() {
                this.$action.invoke();
            }
            {
                this.$action = $captured_local_variable$0;
            }
        };
    }

    public GitHashesProjectServiceWrapper(@NotNull VirtualFile rootFile, @NotNull GitHashesProjectServiceWrapperDriver driver, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.rootFile = rootFile;
        this.driver = driver;
        this.lifetime = lifetime;
        this.requestsCount = new AtomicInteger(0);
        this.blobSetHolder = new AtomicReference<Object>(null);
        this.isCollecting = new AtomicBoolean(false);
        this.changedFilesList = new HashSet();
        this.vfsListener = new AsyncFileListener(this){
            final /* synthetic */ GitHashesProjectServiceWrapper this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                void $this$filterTo$iv;
                Iterable $this$mapNotNullTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                GitBlobSet oldSet;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                GitBlobSet gitBlobSet = oldSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0).get();
                if (gitBlobSet != null) {
                    if (gitBlobSet.isEmpty()) {
                        return null;
                    }
                }
                Iterable iterable = events;
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VFileEvent it = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof VFilePropertyChangeEvent))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = new HashSet<E>(events.size());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    VFileEvent e = (VFileEvent)element$iv;
                    boolean bl2 = false;
                    if (e.getFile() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VirtualFile it$iv = virtualFile;
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                $this$mapNotNullTo$iv = destination$iv;
                destination$iv = new HashSet<E>(events.size());
                boolean $i$f$filterTo2 = false;
                for (T element$iv : $this$filterTo$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)file.getFileSystem(), (Object)LocalFileSystem.getInstance()) && !file.isDirectory() && VfsUtil.isAncestor((VirtualFile)GitHashesProjectServiceWrapper.access$getRootFile$p(this.this$0), (VirtualFile)file, (boolean)true))) continue;
                    destination$iv.add(element$iv);
                }
                Set allFiles = (Set)destination$iv;
                if (allFiles.isEmpty()) {
                    return null;
                }
                return this.processChanges(allFiles, oldSet, true);
            }

            private final ChangeApplier processChanges(Set<? extends VirtualFile> allFiles, GitBlobSet oldSet, boolean allowRecursion) {
                ChangeApplier changeApplier;
                if (oldSet != null) {
                    Set<GitBlobKey> mappedFiles = oldSet.mapFilesToExistingKeys((Collection<? extends VirtualFile>)allFiles);
                    if (mappedFiles.isEmpty()) {
                        return null;
                    }
                    changeApplier = this.processChangesWithMappedFiles(allFiles, oldSet, mappedFiles, allowRecursion);
                } else {
                    changeApplier = this.processChangesToIgnoreList(allFiles, allowRecursion);
                }
                return changeApplier;
            }

            private final ChangeApplier processChangesToIgnoreList(Set<? extends VirtualFile> allFiles, boolean allowRecursion) {
                return GitHashesProjectServiceWrapper.access$returnObject(this.this$0, (Function0)new Function0<Unit>(this, allowRecursion, allFiles){
                    final /* synthetic */ vfsListener.1 this$0;
                    final /* synthetic */ boolean $allowRecursion;
                    final /* synthetic */ Set $allFiles;

                    public final void invoke() {
                        GitBlobSet newOldSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0.this$0).get();
                        if (this.$allowRecursion && newOldSet != null) {
                            ChangeApplier changeApplier = vfsListener.1.access$processChanges(this.this$0, this.$allFiles, newOldSet, false);
                            if (changeApplier != null) {
                                changeApplier.applyNow();
                            }
                        } else {
                            Collection collection = GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this.this$0.this$0);
                            Iterable iterable = this.$allFiles;
                            boolean bl = false;
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$allowRecursion = bl;
                        this.$allFiles = set;
                        super(0);
                    }
                });
            }

            private final ChangeApplier processChangesWithMappedFiles(Set<? extends VirtualFile> allFiles, GitBlobSet oldSet, Set<GitBlobKey> mappedFiles, boolean allowRecursion) {
                GitBlobSet newSet = oldSet.withIgnoredItems-GitBlobKey(mappedFiles);
                if (Intrinsics.areEqual((Object)oldSet, (Object)newSet)) {
                    return null;
                }
                return GitHashesProjectServiceWrapper.access$returnObject(this.this$0, (Function0)new Function0<Unit>(this, allowRecursion, oldSet, allFiles, mappedFiles, newSet){
                    final /* synthetic */ vfsListener.1 this$0;
                    final /* synthetic */ boolean $allowRecursion;
                    final /* synthetic */ GitBlobSet $oldSet;
                    final /* synthetic */ Set $allFiles;
                    final /* synthetic */ Set $mappedFiles;
                    final /* synthetic */ GitBlobSet $newSet;

                    public final void invoke() {
                        GitBlobSet gitBlobSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0.this$0).get();
                        if (gitBlobSet == null) {
                            return;
                        }
                        GitBlobSet oldSet2 = gitBlobSet;
                        if (this.$allowRecursion && Intrinsics.areEqual((Object)this.$oldSet, (Object)oldSet2) ^ true) {
                            ChangeApplier changeApplier = vfsListener.1.access$processChangesWithMappedFiles(this.this$0, this.$allFiles, oldSet2, this.$mappedFiles, false);
                            if (changeApplier != null) {
                                changeApplier.applyNow();
                            }
                        } else {
                            GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0.this$0).set(this.$newSet);
                            GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this.this$0.this$0).clear();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$allowRecursion = bl;
                        this.$oldSet = gitBlobSet;
                        this.$allFiles = set;
                        this.$mappedFiles = set2;
                        this.$newSet = gitBlobSet2;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = this$0;
            }

            public static final /* synthetic */ ChangeApplier access$processChanges(vfsListener.1 $this, Set allFiles, GitBlobSet oldSet, boolean allowRecursion) {
                return $this.processChanges(allFiles, oldSet, allowRecursion);
            }

            public static final /* synthetic */ ChangeApplier access$processChangesWithMappedFiles(vfsListener.1 $this, Set allFiles, GitBlobSet oldSet, Set mappedFiles, boolean allowRecursion) {
                return $this.processChangesWithMappedFiles(allFiles, oldSet, mappedFiles, allowRecursion);
            }
        };
    }

    public static final /* synthetic */ AtomicReference access$getBlobSetHolder$p(GitHashesProjectServiceWrapper $this) {
        return $this.blobSetHolder;
    }

    public static final /* synthetic */ HashSet access$getChangedFilesList$p(GitHashesProjectServiceWrapper $this) {
        return $this.changedFilesList;
    }

    public static final /* synthetic */ VirtualFile access$getRootFile$p(GitHashesProjectServiceWrapper $this) {
        return $this.rootFile;
    }

    public static final /* synthetic */ returnObject.1 access$returnObject(GitHashesProjectServiceWrapper $this, Function0 action) {
        return $this.returnObject((Function0<Unit>)action);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$ChangeApplier;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "applyNow", "", "intellij.indexing.shared.ultimate.git"})
    private static interface ChangeApplier
    extends AsyncFileListener.ChangeApplier {
        public void applyNow();
    }
}

