/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VagrantUtil {
    @NotNull
    public static RemoteCredentials getVagrantCredentials(@NotNull String instanceFolder, @Nullable String machineName) throws IOException {
        RemoteCredentials remoteCredentials;
        if (instanceFolder == null) {
            VagrantUtil.$$$reportNull$$$0(0);
        }
        try {
            VagrantInstance vagrantInstance = VagrantService.getInstance().getVagrantInstance(instanceFolder);
            VagrantSshConfig config = vagrantInstance.getSshConfig(machineName);
            remoteCredentials = config.toRemoteCredentials();
        }
        catch (VagrantSupport.MultipleMachinesException e) {
            throw new IllegalStateException("Interpreter should be configured as a multiple machines Vagrant based", e);
        }
        if (remoteCredentials == null) {
            VagrantUtil.$$$reportNull$$$0(1);
        }
        return remoteCredentials;
    }

    public static Pair<String, String> getInstanceParameters(Project project) {
        VagrantManager vagrantManager = VagrantManager.getInstance(project);
        List<VagrantInstance> instanceList = vagrantManager.listInstances();
        if (instanceList.size() > 0) {
            VagrantInstance instance = instanceList.get(0);
            return Pair.create((Object)vagrantManager.getVagrantExecutable(false), (Object)instance.getFolder());
        }
        return null;
    }

    @Nullable
    public static String askVagrantExecutablePath(@Nullable Project project) {
        Ref path = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
            descriptor.setTitle(VagrantBundle.message("vagrant.select.executable", new Object[0]));
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, files -> {
                VirtualFile file = (VirtualFile)files.get(0);
                if (file != null) {
                    path.set((Object)file.getPath());
                }
            });
        });
        return (String)path.get();
    }

    @NotNull
    public static String getVagrantExecutable(@Nullable Project project, boolean askIfEmpty) {
        String executablePath = VagrantSettings.getInstance().getVagrantExecutable();
        if (StringUtil.isEmpty((String)executablePath)) {
            Messages.showErrorDialog((Project)project, (String)VagrantBundle.message("vagrant.executable.not.specified", new Object[0]), (String)VagrantBundle.message("vagrant.error.running.title", new Object[0]));
        }
        String string = executablePath;
        if (string == null) {
            VagrantUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean checkVagrantRunning(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            VagrantUtil.$$$reportNull$$$0(3);
        }
        if (!VagrantCli.isVagrantRunning(vagrantFolder, StringUtil.isNotEmpty((String)machineName) ? machineName : null)) {
            if (askToRunIfDown) {
                AtomicBoolean isRunning = new AtomicBoolean(false);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    Object machineNameParam;
                    Object object = machineNameParam = StringUtil.isNotEmpty((String)machineName) ? "'" + machineName + "'" : "";
                    if (Messages.showYesNoDialog((Project)null, (String)VagrantBundle.message("vagrant.launch.vm.prompt", machineNameParam, vagrantFolder), (String)VagrantBundle.message("vagrant.instance.not.running.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                        try {
                            VagrantUtil.runVagrant(vagrantFolder, machineName);
                            isRunning.set(true);
                        }
                        catch (ExecutionException e) {
                            Messages.showErrorDialog((Project)null, (String)e.getMessage(), (String)VagrantBundle.message("vagrant.launch.error.title", new Object[0]));
                        }
                    }
                }, ModalityState.any());
                return isRunning.get();
            }
            return false;
        }
        return true;
    }

    public static void runVagrant(final @NotNull @NlsSafe String vagrantFolder, final @Nullable String machineName) throws ExecutionException {
        if (vagrantFolder == null) {
            VagrantUtil.$$$reportNull$$$0(4);
        }
        final Ref error = Ref.create();
        Task.Modal task = new Task.Modal(null, VagrantBundle.message("vagrant.launching.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                pi.setText(vagrantFolder);
                Semaphore done = new Semaphore();
                done.down();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        VagrantUtil.doRunVagrant(vagrantFolder, machineName, pi);
                    }
                    catch (ExecutionException e) {
                        error.set((Object)e);
                    }
                    finally {
                        done.up();
                    }
                });
                done.waitFor();
            }

            public void onCancel() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/vagrant/VagrantUtil$1", "run"));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (error.get() != null) {
            throw (ExecutionException)((Object)error.get());
        }
    }

    private static void doRunVagrant(@NotNull String vagrantFolder, @Nullable String machineName, @NotNull ProgressIndicator pi) throws ExecutionException {
        CapturingProcessHandler ph;
        ProcessOutput output;
        if (vagrantFolder == null) {
            VagrantUtil.$$$reportNull$$$0(5);
        }
        if (pi == null) {
            VagrantUtil.$$$reportNull$$$0(6);
        }
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (!StringUtil.isEmpty((String)vagrantFolder)) {
            cmd.withWorkDirectory(vagrantFolder);
        }
        String homePath = FileUtil.toSystemDependentName((String)VagrantSettings.getInstance().getVagrantExecutable());
        cmd.setExePath(homePath);
        cmd.addParameter("up");
        if (StringUtil.isNotEmpty((String)machineName)) {
            cmd.addParameter(machineName);
        }
        if ((output = (ph = VagrantUtil.createCapturingHandler(cmd, pi)).runProcessWithProgressIndicator(pi)).getExitCode() != 0) {
            throw new ExecutionException(output.getStderr());
        }
    }

    @NotNull
    public static List<String> getVagrantMachines(@NotNull String instanceFolder) {
        List<String> machines;
        VagrantFileConfig config;
        if (instanceFolder == null) {
            VagrantUtil.$$$reportNull$$$0(7);
        }
        if ((config = VagrantFileConfig.findInFolder(instanceFolder)) != null && (machines = config.getMachineConfigurationNames()) != null) {
            List<String> list = machines;
            if (list == null) {
                VagrantUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    @NotNull
    public static CapturingProcessHandler createCapturingHandler(GeneralCommandLine cmd, final ProgressIndicator indicator) throws ExecutionException {
        return indicator == null ? new CapturingProcessHandler(cmd) : new CapturingAnsiEscapesAwareProcessHandler(cmd){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingAnsiEscapesAwareProcessHandler.AnsiEscapesAwareAdapter(processOutput){

                    public void coloredTextAvailable(@NotNull @NlsSafe String text, @NotNull Key attributes) {
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (attributes == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.coloredTextAvailable(text, attributes);
                        indicator.setText2(text);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "attributes";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/plugins/vagrant/VagrantUtil$2$1";
                        objectArray[2] = "coloredTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceFolder";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantMachines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantCredentials";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkVagrantRunning";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runVagrant";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRunVagrant";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantMachines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

