/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import com.jetbrains.plugins.vagrant.state.global.GlobalStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantService {
    private static final Logger LOG = Logger.getInstance(VagrantService.class);
    private final GlobalStatus myGlobalStatus = new GlobalStatus();
    private final Map<String, VagrantInstance> myVagrantInstances = new ConcurrentHashMap<String, VagrantInstance>();
    private String myCheckedVagrantExecutable = null;
    private final Object myLock = new Object();

    @NotNull
    public String getVagrantExecutable() {
        VagrantSettings settings = VagrantSettings.getInstance();
        String vagrantPath = settings.getVagrantExecutable();
        if (StringUtil.isEmpty((String)vagrantPath)) {
            vagrantPath = this.detectVagrantExecutable();
        }
        settings.setVagrantExecutable(vagrantPath);
        String string = vagrantPath;
        if (string == null) {
            VagrantService.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getVagrantExecutable(@NotNull Project project, boolean askIfNotSet) {
        String askedVagrantPath;
        VagrantSettings settings;
        String vagrantPath;
        if (project == null) {
            VagrantService.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(vagrantPath = (settings = VagrantSettings.getInstance()).getVagrantExecutable()))) {
            vagrantPath = this.detectVagrantExecutable();
        }
        if (askIfNotSet && !this.checkVersion(vagrantPath) && (askedVagrantPath = VagrantUtil.askVagrantExecutablePath(project)) == null) {
            return null;
        }
        settings.setVagrantExecutable(vagrantPath);
        return vagrantPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkVersion(@NotNull String vagrantPath) {
        if (vagrantPath == null) {
            VagrantService.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (vagrantPath.equals(this.myCheckedVagrantExecutable)) {
                return true;
            }
            LOG.debug("Checking Vagrant executable: " + vagrantPath);
            String vagrantVersion = VagrantCli.execVagrantVersion(vagrantPath);
            boolean success = StringUtil.isNotEmpty((String)vagrantVersion);
            this.myCheckedVagrantExecutable = success ? vagrantPath : null;
            return success;
        }
    }

    @NotNull
    public String detectVagrantExecutable() {
        for (String path : VagrantService.suggestPaths()) {
            File f = new File(path);
            if (!f.exists()) continue;
            String string = f.getPath();
            if (string == null) {
                VagrantService.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            return "vagrant.bat";
        }
        return "vagrant";
    }

    @NotNull
    public VagrantInstance getVagrantInstance(@NotNull String instanceFolder) {
        if (instanceFolder == null) {
            VagrantService.$$$reportNull$$$0(4);
        }
        VagrantInstance vagrantInstance = this.myVagrantInstances.computeIfAbsent(instanceFolder, folder -> new VagrantInstance((String)folder));
        if (vagrantInstance == null) {
            VagrantService.$$$reportNull$$$0(5);
        }
        return vagrantInstance;
    }

    @NotNull
    private static List<String> suggestPaths() {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"/usr/bin/vagrant", "/usr/local/bin/vagrant"});
        if (arrayList == null) {
            VagrantService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public GlobalStatus getGlobalStatus() {
        GlobalStatus globalStatus = this.myGlobalStatus;
        if (globalStatus == null) {
            VagrantService.$$$reportNull$$$0(7);
        }
        return globalStatus;
    }

    @NotNull
    public static VagrantService getInstance() {
        VagrantService vagrantService = (VagrantService)ApplicationManager.getApplication().getService(VagrantService.class);
        if (vagrantService == null) {
            VagrantService.$$$reportNull$$$0(8);
        }
        return vagrantService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantExecutable";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detectVagrantExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalStatus";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantExecutable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

