/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.AbstractVagrantItemManager;
import com.jetbrains.plugins.vagrant.AddVagrantBoxDialog;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantBoxManager
extends AbstractVagrantItemManager<VagrantBox> {
    private static final Pattern PATTERN_PROGRESS = Pattern.compile("Progress: (\\d+)%");

    public VagrantBoxManager(Project project) {
        super(project);
    }

    @Override
    protected VagrantBox createItem(String line) {
        return new VagrantBox(line);
    }

    @Override
    protected String emptyListText() {
        return VagrantBundle.message("vagrant.box.empty.list", new Object[0]);
    }

    @Override
    protected String[] listItemsArguments() {
        return new String[]{"box", "list"};
    }

    @Override
    protected String getItemName() {
        return VagrantBundle.message("vagrant.box.item.name", new Object[0]);
    }

    @NotNull
    public FutureResult<VagrantBox> add(@NotNull String name, @NotNull String url) {
        if (name == null) {
            VagrantBoxManager.$$$reportNull$$$0(0);
        }
        if (url == null) {
            VagrantBoxManager.$$$reportNull$$$0(1);
        }
        VagrantTask task = this.createTask("box", "add", name, url);
        FutureResult<VagrantBox> futureResult = this.runTask(name, task, VagrantBundle.message("vagrant.box.downloading.vagrant.box", new Object[0]));
        if (futureResult == null) {
            VagrantBoxManager.$$$reportNull$$$0(2);
        }
        return futureResult;
    }

    private FutureResult<VagrantBox> runTask(final String name, final VagrantTask task, @NlsContexts.ProgressTitle String title) {
        final FutureResult futureBox = new FutureResult();
        if (task != null) {
            Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, title, true, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return false;
                }
            }){

                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setFraction(0.0);
                    indicator.isIndeterminate();
                    try {
                        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                        handler.addProcessListener((ProcessListener)new ProcessAdapter((CapturingProcessHandler)handler){
                            final /* synthetic */ CapturingProcessHandler val$handler;
                            {
                                this.val$handler = capturingProcessHandler;
                            }

                            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                                Matcher m;
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (outputType == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if ((m = PATTERN_PROGRESS.matcher(event.getText())).find()) {
                                    try {
                                        indicator.setFraction((double)Integer.parseInt(m.group(1)) / 100.0);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (indicator.isCanceled()) {
                                    this.val$handler.destroyProcess();
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "event";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "outputType";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/jetbrains/plugins/vagrant/VagrantBoxManager$2$1";
                                objectArray[2] = "onTextAvailable";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        ProcessOutput output = handler.runProcess();
                        if (output.getExitCode() != 0) {
                            UIUtil.invokeLaterIfNeeded(() -> {
                                Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)VagrantBundle.message("vagrant.error.adding.box.title", new Object[0]));
                                futureBox.set(null);
                            });
                        } else {
                            VagrantBoxManager.this.dropCache();
                            futureBox.set((Object)new VagrantBox(name));
                            VagrantBoxManager.this.fireEvent();
                        }
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)VagrantBundle.message("vagrant.error.adding.box", message), (String)VagrantBundle.message("vagrant.error.adding.box.title", new Object[0])));
                        futureBox.set(null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/vagrant/VagrantBoxManager$2", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)backgroundableTask);
        } else {
            futureBox.set(null);
        }
        return futureBox;
    }

    @Override
    protected String[] removeItemArguments(VagrantItem box) {
        return new String[]{"box", "remove", box.getName()};
    }

    @Override
    @Nullable
    public FutureResult<VagrantBox> add() {
        AddVagrantBoxDialog dialog = new AddVagrantBoxDialog(this.myProject, this.listItems());
        if (dialog.showAndGet()) {
            return this.add(dialog.getName(), dialog.getUrl());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantBoxManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantBoxManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

