/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.twig.TwigBundle;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.elements.TwigTag;
import com.jetbrains.twig.parser.TwigBlockStatements;
import com.jetbrains.twig.parser.TwigTagParsingData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigPsiBuilder
implements TwigElementTypes {
    private final PsiBuilder myBuilder;
    private final Stack<TwigTagParsingData> myTagNamesStack = new Stack();
    private final Stack<PsiBuilder.Marker> myMarkers = new Stack();
    private final Collection<String> RESERVED_WORDS = Set.of("true", "false").stream().collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    private final Collection<IElementType> VARIABLE_SUPPORT_TAGS = Set.of(DO_TAG, FOR_TAG, PRINT_BLOCK, SET_TAG, IF_TAG, ELSEIF_TAG, IMPORT_TAG);
    private static final HashMap<String, IElementType> TAG_NAME_TO_TYPE_MAP = new HashMap(TAGS.getTypes().length);

    public TwigPsiBuilder(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    ASTNode buildPsiTree(IElementType root) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.setDebugMode(true);
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_START) {
                this.parseStatement();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_START) {
                this.parsePrintBlock();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.COMMENT_START) {
                this.parseCommentBlock();
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        this.myMarkers.forEach(e -> e.drop());
        marker.done(root);
        return this.myBuilder.getTreeBuilt();
    }

    private void parseStatement() {
        PsiBuilder.Marker statementMarker = this.myBuilder.mark();
        TwigTagParsingData tagData = this.parseTag();
        if (tagData != null) {
            TwigBlockStatements.StatementDefinition statementDefinition = TwigBlockStatements.getStatementDefinitionByStartTag(tagData.getTagType());
            if (statementDefinition != null) {
                if (statementDefinition.mayBeShort() && !tagData.isShort()) {
                    statementMarker.done(statementDefinition.getStatementType());
                } else {
                    this.myMarkers.push((Object)statementMarker);
                    this.myTagNamesStack.push((Object)tagData);
                }
            } else {
                String name = tagData.getName();
                if (!TwigPsiBuilder.isCustomCloseTag(name) && TAGS.contains(tagData.getTagType())) {
                    statementMarker.drop();
                } else if (!TwigPsiBuilder.isCustomCloseTag(name) && !TAGS.contains(tagData.getTagType())) {
                    this.myMarkers.push((Object)statementMarker);
                    this.myTagNamesStack.push((Object)tagData);
                } else if (TwigPsiBuilder.isCustomCloseTag(name) && !TAGS.contains(tagData.getTagType())) {
                    while (!this.myTagNamesStack.empty() && !TwigPsiBuilder.isEndTag(((TwigTagParsingData)this.myTagNamesStack.peek()).getName(), name)) {
                        this.myTagNamesStack.pop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).drop();
                    }
                    if (!this.myTagNamesStack.isEmpty() && TwigPsiBuilder.isEndTag(((TwigTagParsingData)this.myTagNamesStack.peek()).getName(), name)) {
                        this.myTagNamesStack.pop();
                        statementMarker.drop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(TWIG_STATEMENT);
                    } else {
                        statementMarker.drop();
                    }
                } else if (TwigPsiBuilder.isCustomCloseTag(name) && TAGS.contains(tagData.getTagType())) {
                    TwigBlockStatements.StatementDefinition definition = this.getDefinition();
                    while (!(this.myTagNamesStack.isEmpty() || definition != null && (definition.endsBeforeTypes.contains(tagData.getTagType()) || definition.endTagTypes.contains(tagData.getTagType())))) {
                        this.myTagNamesStack.pop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).drop();
                        definition = this.getDefinition();
                    }
                    if (!this.myTagNamesStack.isEmpty() && definition.endTagTypes.contains(tagData.getTagType())) {
                        this.myTagNamesStack.pop();
                        statementMarker.drop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(definition.getStatementType());
                    } else if (!this.myTagNamesStack.isEmpty() && definition.endsBeforeTypes.contains(tagData.getTagType())) {
                        this.myTagNamesStack.pop();
                        statementMarker.rollbackTo();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(definition.getStatementType());
                    } else {
                        statementMarker.drop();
                    }
                }
            }
        } else {
            statementMarker.drop();
        }
    }

    private static boolean isCustomCloseTag(String name) {
        return name.startsWith("end") && !name.equals("end") && !name.equals("end_");
    }

    @Nullable
    private TwigBlockStatements.StatementDefinition getDefinition() {
        return TwigBlockStatements.getStatementDefinitionByStartTag(this.myTagNamesStack.isEmpty() ? null : ((TwigTagParsingData)this.myTagNamesStack.peek()).getTagType());
    }

    @Nullable
    private TwigTagParsingData parseTag() {
        assert (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_START);
        PsiBuilder.Marker mark = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == TwigTokenTypes.TAG_NAME) {
            String name = this.myBuilder.getTokenText();
            IElementType tagType = TwigPsiBuilder.getTagType(name);
            this.myBuilder.advanceLexer();
            boolean isShortBlock = true;
            if (tagType == MACRO_TAG && this.myBuilder.lookAhead(1) == TwigTokenTypes.LBRACE) {
                this.parseArguments();
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseTwigReferenceOrSkip(tagType);
            }
            while (this.myBuilder.getTokenType() != TwigTokenTypes.STATEMENT_BLOCK_END && !this.myBuilder.eof()) {
                isShortBlock = false;
                if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER && !this.RESERVED_WORDS.contains(this.myBuilder.getTokenText()) && this.tryParseTwigReference(null, tagType)) continue;
                if (this.myBuilder.getTokenType() == TwigTokenTypes.IS) {
                    this.parseIsOperator();
                }
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                    this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                    continue;
                }
                if (this.myBuilder.getTokenType() != TwigTokenTypes.LBRACE_SQ) continue;
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_END) {
                this.myBuilder.advanceLexer();
            }
            mark.done(tagType);
            return new TwigTagParsingData(tagType, isShortBlock, name);
        }
        mark.error(TwigBundle.message("parsing.error.block.must.start.with.tag.name", new Object[0]));
        return null;
    }

    private void parseIsOperator() {
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == TwigTokenTypes.NOT) {
            this.myBuilder.advanceLexer();
        }
    }

    @NotNull
    private static IElementType getTagType(String tokenText) {
        IElementType mappedType = TAG_NAME_TO_TYPE_MAP.get(tokenText);
        IElementType iElementType = mappedType != null ? mappedType : TAG;
        if (iElementType == null) {
            TwigPsiBuilder.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    private void parsePrintBlock() {
        assert (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_START);
        PsiBuilder.Marker printBlockMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_END) {
                this.myBuilder.advanceLexer();
                break;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseTwigReferenceOrSkip(null);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.FILTER) {
                this.parseFilter();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IS) {
                this.parseIsOperator();
                this.myBuilder.advanceLexer();
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        printBlockMarker.done(PRINT_BLOCK);
    }

    private void parseCommentBlock() {
        assert (this.myBuilder.getTokenType() == TwigTokenTypes.COMMENT_START);
        PsiBuilder.Marker commentBlockMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.COMMENT_END) {
                this.myBuilder.advanceLexer();
                break;
            }
            this.myBuilder.advanceLexer();
        }
        commentBlockMarker.done(COMMENT_BLOCK);
    }

    private void parseFilter() {
        this.myBuilder.advanceLexer();
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType == TwigTokenTypes.IDENTIFIER) {
            this.parseTwigReferenceOrSkip(TwigTokenTypes.FILTER);
            return;
        }
        if (tokenType == TwigTokenTypes.FILTER) {
            this.myBuilder.advanceLexer();
            return;
        }
        this.myBuilder.error(TwigBundle.message("parser.invalid.filter.name", new Object[0]));
    }

    private void parseTwigReferenceOrSkip(@Nullable IElementType parent) {
        if (!this.tryParseTwigReference(null, parent)) {
            this.myBuilder.advanceLexer();
        }
    }

    private boolean tryParseTwigReference(@Nullable PsiBuilder.Marker parentMarker, @Nullable IElementType parentTag) {
        PsiBuilder.Marker marker;
        if (parentTag != null && parentTag != TwigTokenTypes.FILTER && !this.VARIABLE_SUPPORT_TAGS.contains(parentTag)) {
            return false;
        }
        if (this.RESERVED_WORDS.contains(this.myBuilder.getTokenText())) {
            return false;
        }
        if (this.myBuilder.lookAhead(1) == TwigTokenTypes.LBRACE) {
            return this.tryParseFunctionCall(parentMarker, parentTag);
        }
        if (parentTag == TwigTokenTypes.FILTER) {
            return false;
        }
        PsiBuilder.Marker marker2 = marker = parentMarker == null ? this.myBuilder.mark() : parentMarker.precede();
        if (this.tryParseVariableOrField(parentMarker)) {
            IElementType delimiterType = this.myBuilder.getTokenType();
            if (delimiterType == TwigTokenTypes.DOT || delimiterType == TwigTokenTypes.LBRACE_SQ) {
                return this.tryParseReferencesChain(marker, parentTag);
            }
            marker.drop();
            return true;
        }
        marker.drop();
        return false;
    }

    private boolean tryParseVariableOrField(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PsiBuilder.Marker parentMarker) {
        if (parentMarker != null && this.myBuilder.rawLookup(-1) == TwigTokenTypes.LBRACE_SQ) {
            if (this.parseExpr(TwigTokenTypes.RBRACE_SQ)) {
                this.myBuilder.advanceLexer();
                parentMarker.done(FIELD_REFERENCE);
                return true;
            }
            return false;
        }
        if (this.myBuilder.getTokenType() != TwigTokenTypes.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker current = parentMarker == null ? this.myBuilder.mark() : parentMarker;
        this.myBuilder.advanceLexer();
        current.done(parentMarker == null ? VARIABLE_REFERENCE : FIELD_REFERENCE);
        return true;
    }

    private boolean tryParseFunctionCall(@Nullable PsiBuilder.Marker parentMarker, @Nullable IElementType parentTag) {
        PsiBuilder.Marker current;
        PsiBuilder.Marker marker = current = parentMarker == null ? this.myBuilder.mark() : parentMarker;
        if (!this.parseArguments()) {
            if (parentMarker == null) {
                current.drop();
            }
            return false;
        }
        current.done(parentMarker == null ? FUNCTION_CALL : METHOD_CALL);
        while (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE) {
            current = current.precede();
            if (!this.parseArguments()) {
                current.drop();
                return false;
            }
            current.done(FUNCTION_CALL);
        }
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType == TwigTokenTypes.DOT || tokenType == TwigTokenTypes.LBRACE_SQ) {
            return this.tryParseReferencesChain(current.precede(), parentTag);
        }
        return true;
    }

    private boolean tryParseReferencesChain(@NotNull PsiBuilder.Marker marker, @Nullable IElementType parentTag) {
        if (marker == null) {
            TwigPsiBuilder.$$$reportNull$$$0(1);
        }
        if (this.myBuilder.getTokenType() == TwigTokenTypes.DOT && this.myBuilder.lookAhead(1) != TwigTokenTypes.IDENTIFIER) {
            marker.drop();
            return false;
        }
        this.myBuilder.advanceLexer();
        if (this.tryParseTwigReference(marker, parentTag)) {
            return true;
        }
        marker.drop();
        return false;
    }

    private boolean parseArguments() {
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.RBRACE) {
                this.myBuilder.advanceLexer();
                return true;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseTwigReferenceOrSkip(null);
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        this.myBuilder.error(TwigBundle.message("parsing.error.unclosed.function.call", new Object[0]));
        return false;
    }

    private void parseParens() {
        PsiBuilder.Marker parensMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.RBRACE) {
                this.myBuilder.advanceLexer();
                parensMarker.done(PARENTHESIZED_EXPRESSION);
                return;
            }
            if (this.parseExpr(TwigTokenTypes.RBRACE)) continue;
            this.myBuilder.advanceLexer();
        }
        parensMarker.drop();
        this.myBuilder.error(TwigBundle.message("parsing.error.unclosed.literal", new Object[0]));
    }

    private void parseLiteral(IElementType type) {
        PsiBuilder.Marker literalMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END && this.myBuilder.getTokenType() != TwigTokenTypes.RBRACE) {
            if (this.myBuilder.getTokenType() == type) {
                this.myBuilder.advanceLexer();
                literalMarker.done(LITERAL);
                return;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.COLON) {
                this.myBuilder.advanceLexer();
                if (this.parseExpr(type)) {
                    continue;
                }
            } else {
                if (type == TwigTokenTypes.RBRACE_SQ && this.parseExpr(type)) continue;
                if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE) {
                    this.parseParens();
                    continue;
                }
            }
            this.myBuilder.advanceLexer();
        }
        literalMarker.drop();
        this.myBuilder.error(TwigBundle.message("parsing.error.unclosed.literal", new Object[0]));
    }

    private boolean parseExpr(IElementType endToken) {
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == endToken) {
                return true;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseTwigReferenceOrSkip(null);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE) {
                this.parseParens();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.FILTER) {
                this.parseFilter();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                return true;
            }
            this.myBuilder.advanceLexer();
        }
        return false;
    }

    private static boolean isEndTag(String name, String endName) {
        return endName.equals("end" + name) || endName.equals("end_" + name);
    }

    static {
        for (IElementType type : TAGS.getTypes()) {
            if (!(type instanceof TwigTag)) continue;
            TAG_NAME_TO_TYPE_MAP.put(((TwigTag)type).getTagName(), type);
        }
        TAG_NAME_TO_TYPE_MAP.put("from", TwigElementTypes.IMPORT_TAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/parser/TwigPsiBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/parser/TwigPsiBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryParseReferencesChain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

