/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.TwigLexer;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigCompositeElementType;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.parser.TwigParser;
import org.jetbrains.annotations.NotNull;

public class TwigParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE = TokenSet.create((IElementType[])new IElementType[]{TwigTokenTypes.WHITE_SPACE});
    private static final TokenSet COMMENT = TokenSet.create((IElementType[])new IElementType[]{TwigElementTypes.COMMENT_BLOCK});

    @NotNull
    public Lexer createLexer(Project project) {
        return new TwigLexer(project);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new TwigParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = TwigElementTypes.TWIG_FILE;
        if (iFileElementType == null) {
            TwigParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACE;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TwigTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof TwigCompositeElementType) {
            PsiElement psiElement = ((TwigCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                TwigParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            TwigParserDefinition.$$$reportNull$$$0(5);
        }
        return new TwigFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            TwigParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    public String toString() {
        return "TwigParserDefinition";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/parser/TwigParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/parser/TwigParserDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

