/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.twig.elements.TwigElementFactory;
import com.jetbrains.twig.elements.TwigForStatement;
import com.jetbrains.twig.elements.TwigPsiReference;
import com.jetbrains.twig.elements.TwigStatement;
import com.jetbrains.twig.elements.TwigWithStatement;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigVariableReference
extends TwigPsiReference {
    private static final ResolveCache.PolyVariantResolver<TwigPsiReference> RESOLVER = (expression, incompleteCode) -> {
        LinkedList myDeclarations = new LinkedList();
        TwigVariableReference target = (TwigVariableReference)((Object)((Object)ObjectUtils.tryCast((Object)expression, TwigVariableReference.class)));
        if (target == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiTreeUtil.processElements((PsiElement)expression.getContainingFile(), e -> {
            if (expression.getTextRange().getStartOffset() < e.getTextRange().getStartOffset()) {
                return false;
            }
            TwigVariableReference variable = (TwigVariableReference)((Object)((Object)((Object)ObjectUtils.tryCast((Object)e, TwigVariableReference.class))));
            if (variable == null || !Objects.equals(variable.getName(), expression.getName())) {
                return true;
            }
            if (variable.isAvailableFromScopeOf(target)) {
                myDeclarations.add(variable);
                return false;
            }
            return true;
        });
        return PsiElementResolveResult.createResults(myDeclarations);
    };

    public TwigVariableReference(@NotNull ASTNode node) {
        if (node == null) {
            TwigVariableReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String getName() {
        return this.getText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            TwigVariableReference.$$$reportNull$$$0(1);
        }
        return this.replace((PsiElement)TwigElementFactory.createVariable(this.getProject(), name));
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this;
    }

    @Override
    ResolveCache.PolyVariantResolver<TwigPsiReference> getReferenceResolver() {
        return RESOLVER;
    }

    private boolean isAvailableFromScopeOf(@NotNull TwigVariableReference another) {
        boolean anotherHasOnlyKeyword;
        PsiElement anotherScope;
        if (another == null) {
            TwigVariableReference.$$$reportNull$$$0(2);
        }
        if (this == another) {
            return true;
        }
        PsiElement thisScope = TwigVariableReference.findScopeRootElement((PsiElement)this);
        if (thisScope == (anotherScope = TwigVariableReference.findScopeRootElement((PsiElement)another))) {
            return true;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)anotherScope, (PsiElement)thisScope, (boolean)false)) {
            return false;
        }
        boolean isAnotherDeclaredAsForTagItem = TwigVariableReference.isDeclaredAsForTagItem(anotherScope, another);
        boolean bl = anotherHasOnlyKeyword = anotherScope instanceof TwigWithStatement && ((TwigWithStatement)anotherScope).hasOnly();
        if (isAnotherDeclaredAsForTagItem || anotherHasOnlyKeyword) {
            return false;
        }
        if (anotherScope instanceof TwigWithStatement) {
            if (another.isWriteAccess()) {
                return false;
            }
            PsiElement lastWriteInstruction = TwigVariableReference.getLastWriteInstruction(another);
            return lastWriteInstruction == null || TwigVariableReference.findScopeRootElement(lastWriteInstruction) != anotherScope;
        }
        return PsiTreeUtil.isAncestor((PsiElement)thisScope, (PsiElement)anotherScope, (boolean)false);
    }

    private static boolean isDeclaredAsForTagItem(@NotNull PsiElement scope, @NotNull TwigPsiReference variable) {
        TwigForStatement forStatement;
        if (scope == null) {
            TwigVariableReference.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            TwigVariableReference.$$$reportNull$$$0(4);
        }
        return (forStatement = (TwigForStatement)((Object)ObjectUtils.tryCast((Object)scope, TwigForStatement.class))) != null && forStatement.getItemVariables().stream().anyMatch(v -> Objects.equals(v.getName(), variable.getName()));
    }

    @NotNull
    private static PsiElement findScopeRootElement(@NotNull PsiElement psiElement) {
        TwigStatement parent;
        if (psiElement == null) {
            TwigVariableReference.$$$reportNull$$$0(5);
        }
        TwigStatement twigStatement = (parent = (TwigStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{TwigForStatement.class, TwigWithStatement.class})) == null ? psiElement.getContainingFile() : parent;
        if (twigStatement == null) {
            TwigVariableReference.$$$reportNull$$$0(6);
        }
        return twigStatement;
    }

    @Nullable
    private static PsiElement getLastWriteInstruction(@NotNull TwigVariableReference another) {
        if (another == null) {
            TwigVariableReference.$$$reportNull$$$0(7);
        }
        Ref lastWriteInstruction = new Ref();
        PsiTreeUtil.processElements((PsiElement)another.getContainingFile(), e -> {
            if (e.getTextOffset() >= another.getTextOffset()) {
                return false;
            }
            TwigVariableReference variable = (TwigVariableReference)((Object)((Object)ObjectUtils.tryCast((Object)e, TwigVariableReference.class)));
            if (variable != null && Objects.equals(variable.getName(), another.getName())) {
                lastWriteInstruction.set((Object)variable);
            }
            return true;
        });
        return (PsiElement)lastWriteInstruction.get();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        TwigVariableReference variable;
        if (element == null) {
            TwigVariableReference.$$$reportNull$$$0(8);
        }
        if ((variable = (TwigVariableReference)((Object)ObjectUtils.tryCast((Object)element, TwigVariableReference.class))) == null || !Objects.equals(variable.getName(), this.getName())) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (this == another) {
            return true;
        }
        TwigVariableReference variable = (TwigVariableReference)((Object)ObjectUtils.tryCast((Object)another, TwigVariableReference.class));
        if (variable == null || !Objects.equals(variable.getName(), this.getName())) {
            return false;
        }
        return Objects.equals(this.resolve(), variable.resolve()) || super.isEquivalentTo(another);
    }

    @Override
    public boolean isWriteAccess() {
        TwigForStatement forStatement = (TwigForStatement)PsiTreeUtil.getParentOfType((PsiElement)this, TwigForStatement.class);
        if (this.getName() != null && forStatement != null && forStatement.getItemVariables().stream().anyMatch(e -> this.getName().equals(e.getName()))) {
            return true;
        }
        return super.isWriteAccess();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Gvariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/elements/TwigVariableReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/elements/TwigVariableReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableFromScopeOf";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredAsForTagItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findScopeRootElement";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLastWriteInstruction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

