/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigCompositeElement;
import com.jetbrains.twig.elements.TwigElementFactory;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigTagWithFileReference
extends TwigCompositeElement {
    public TwigTagWithFileReference(@NotNull ASTNode node) {
        if (node == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    private PsiElement[] getNonWhitespaceChildren() {
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        for (PsiElement firstChild = this.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
            if (firstChild instanceof PsiWhiteSpace) continue;
            result.add(firstChild);
        }
        return result.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Nullable
    protected PsiElement findFileNameElement() {
        PsiElement[] children = this.getNonWhitespaceChildren();
        if (!(children.length < 6 || children[2].getNode().getElementType() != children[4].getNode().getElementType() || children[2].getNode().getElementType() != TwigTokenTypes.DOUBLE_QUOTE && children[2].getNode().getElementType() != TwigTokenTypes.SINGLE_QUOTE || children[5].getNode().getElementType() != TwigTokenTypes.STATEMENT_BLOCK_END && children[5].getNode().getElementType() != TwigTokenTypes.IDENTIFIER && children[5].getNode().getElementType() != TwigTokenTypes.WITH_KEYWORD)) {
            return children[3];
        }
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiElement fileNameElement = this.findFileNameElement();
        if (fileNameElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TwigTagWithFileReference.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        FileReference[] fileReferenceArray = new FileReferenceSet(FileUtil.toSystemIndependentName((String)fileNameElement.getText()), (PsiElement)this, this.getTextOffset() - this.getTextRange().getStartOffset(), null, true).getAllReferences();
        if (fileReferenceArray == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(2);
        }
        return fileReferenceArray;
    }

    public int getTextOffset() {
        PsiElement element = this.getNavigationElement();
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement fileNameElement = this.findFileNameElement();
        if (fileNameElement != null) {
            PsiElement psiElement = fileNameElement;
            if (psiElement == null) {
                TwigTagWithFileReference.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        TwigTagWithFileReference twigTagWithFileReference = this;
        if (twigTagWithFileReference == null) {
            TwigTagWithFileReference.$$$reportNull$$$0(4);
        }
        return twigTagWithFileReference;
    }

    public void changeFileName(String newName) {
        PsiElement newNameElement;
        PsiElement fileNameElement = this.findFileNameElement();
        if (fileNameElement != null && (newNameElement = TwigElementFactory.createPsiElement(this.getProject(), "{% block '" + newName + "' %}", TwigTokenTypes.STRING_TEXT)) != null) {
            fileNameElement.replace(newNameElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/elements/TwigTagWithFileReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/elements/TwigTagWithFileReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

