/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.twig.elements.TwigCompositeElement;
import com.jetbrains.twig.elements.TwigElementTypes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwigPsiReference
extends TwigCompositeElement
implements PsiNameIdentifierOwner,
PsiPolyVariantReference,
NavigatablePsiElement {
    TwigPsiReference(@NotNull ASTNode node) {
        if (node == null) {
            TwigPsiReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    abstract ResolveCache.PolyVariantResolver<TwigPsiReference> getReferenceResolver();

    public PsiReference getReference() {
        return this;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache.PolyVariantResolver<TwigPsiReference> resolver = this.getReferenceResolver();
        if (incompleteCode) {
            ResolveResult[] resolveResultArray = resolver.resolve((PsiPolyVariantReference)this, true);
            if (resolveResultArray == null) {
                TwigPsiReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, resolver, true, false);
        if (resolveResultArray == null) {
            TwigPsiReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @NotNull
    public PsiElement getElement() {
        TwigPsiReference twigPsiReference = this;
        if (twigPsiReference == null) {
            TwigPsiReference.$$$reportNull$$$0(3);
        }
        return twigPsiReference;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int start = Optional.ofNullable(this.getName()).map(n -> this.getTextLength() - n.length()).orElse(0);
        return new TextRange(start, this.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return Arrays.stream(resolveResults).map(result -> result.getElement()).filter(Objects::nonNull).min(Comparator.comparingInt(a -> a.getTextRange().getStartOffset())).orElse(resolveResults.length == 1 ? resolveResults[0].getElement() : null);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            TwigPsiReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            TwigPsiReference.$$$reportNull$$$0(5);
        }
        return this.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TwigPsiReference.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("Method bindToElement is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            TwigPsiReference.$$$reportNull$$$0(7);
        }
        return this.getManager().areElementsEquivalent((PsiElement)this, element) || ContainerUtil.exists((Object[])this.multiResolve(false), result -> this.getElement().getManager().areElementsEquivalent(result.getElement(), element));
    }

    public boolean isSoft() {
        return false;
    }

    public ItemPresentation getPresentation() {
        String fileName = this.getContainingFile().getName();
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getContainingFile());
        String location = document == null ? fileName : fileName + ":" + (document.getLineNumber(this.getTextOffset()) + 1);
        return new PresentationData(this.getName(), location, this.getIcon(0), null);
    }

    public boolean isWriteAccess() {
        if (!TwigPsiReference.isOfType(this.getParent(), TwigElementTypes.SET_TAG)) {
            return false;
        }
        TwigPsiReference firstRef = (TwigPsiReference)PsiTreeUtil.getChildOfType((PsiElement)this.getParent(), TwigPsiReference.class);
        return firstRef == this;
    }

    static boolean isOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            TwigPsiReference.$$$reportNull$$$0(8);
        }
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && type.equals(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/elements/TwigPsiReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/elements/TwigPsiReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

