/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.debug;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.template.PhpTemplateDebugStateService;
import com.jetbrains.php.debug.template.PhpTemplateLanguagePathMapper;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.jetbrains.twig.TwigFileType;
import com.jetbrains.twig.debug.TwigDebugStateService;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigDebugPathMapper
extends PhpTemplateLanguagePathMapper {
    private static final Logger LOG = Logger.getInstance(TwigDebugPathMapper.class);
    public static final String TWIG_TEMPLATE = "TwigTemplate";
    public static final String GET_DEBUG_INFO = "getDebugInfo";
    public static final String GET_SOURCE_CONTEXT = "getSourceContext";
    public static final String TWIG = "Twig ";

    public boolean isTemplateFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(0);
        }
        return fileType.equals((Object)TwigFileType.INSTANCE);
    }

    public boolean isGeneratedFile(@NotNull VirtualFile file, @NotNull Project project) {
        TwigDebugStateService stateService;
        if (file == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(1);
        }
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(2);
        }
        if ((stateService = TwigDebugStateService.getInstance(project)) == null || !stateService.isWellConfigured()) {
            return false;
        }
        String cachePath = stateService.getCachePath();
        VirtualFile cacheDir = cachePath != null ? VfsUtil.findFile((Path)Paths.get(cachePath, new String[0]), (boolean)true) : null;
        return VfsUtilCore.isUnder((VirtualFile)file, Collections.singleton(cacheDir));
    }

    public XSourcePosition mapToTemplate(@Nullable XSourcePosition phpPosition, @NotNull Project project, @NotNull PhpPathMapper remotePathMapper) {
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(3);
        }
        if (remotePathMapper == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(4);
        }
        if (phpPosition == null) {
            return null;
        }
        TwigDebugStateService stateService = TwigDebugStateService.getInstance(project);
        if (stateService == null || !stateService.isWellConfigured()) {
            LOG.warn(TWIG + PhpBundle.message((String)"template.debug.cache.dir.is.not.specified", (Object[])new Object[0]));
            return phpPosition;
        }
        VirtualFile generatedFile = phpPosition.getFile();
        String path = TwigDebugPathMapper.getTemplatePath(generatedFile, project);
        if (path != null) {
            int templateLine;
            VirtualFile templateFile;
            VirtualFile virtualFile = templateFile = ApplicationManager.getApplication().isUnitTestMode() ? generatedFile.getParent().findChild(path) : remotePathMapper.getLocalFile(path);
            if (templateFile != null && (templateLine = TwigDebugPathMapper.getMappedLine(phpPosition.getLine(), generatedFile, project, false)) != -1) {
                return XDebuggerUtil.getInstance().createPosition(templateFile, templateLine);
            }
        }
        return phpPosition;
    }

    public XSourcePosition mapToPhp(@NotNull XSourcePosition templatePosition, @NotNull Project project, @NotNull PhpPathMapper remotePathMapper) {
        Optional<Pair> max;
        Path path;
        TwigDebugStateService stateService;
        if (templatePosition == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(6);
        }
        if (remotePathMapper == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(7);
        }
        if ((stateService = TwigDebugStateService.getInstance(project)) == null || !stateService.isWellConfigured()) {
            LOG.warn(TWIG + PhpBundle.message((String)"template.debug.cache.dir.is.not.specified", (Object[])new Object[0]));
            return templatePosition;
        }
        String cachePath = stateService.getCachePath();
        try {
            path = Paths.get(cachePath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            LOG.warn(TWIG + PhpBundle.message((String)"template.debug.cache.dir.is.incorrect", (Object[])new Object[0]));
            return templatePosition;
        }
        VirtualFile cacheDir = VfsUtil.findFile((Path)path, (boolean)true);
        if (cacheDir == null) {
            return templatePosition;
        }
        VirtualFile file = templatePosition.getFile();
        if (!TwigDebugPathMapper.isTemplateFile((VirtualFile)file)) {
            return templatePosition;
        }
        String remoteFilePath = ApplicationManager.getApplication().isUnitTestMode() ? PathUtil.getFileName((String)file.getPath()) : remotePathMapper.getRemoteFilePath(file);
        ArrayList generatedFiles = new ArrayList();
        ReadAction.run(() -> VfsUtilCore.processFilesRecursively((VirtualFile)cacheDir, generatedFile -> {
            int generatedLine;
            if (generatedFile.isDirectory()) {
                return true;
            }
            if (remoteFilePath != null && FileUtil.pathsEqual((String)PathUtil.toSystemIndependentName((String)TwigDebugPathMapper.getTemplatePath(generatedFile, project)), (String)PathUtil.toSystemIndependentName((String)remoteFilePath)) && (generatedLine = TwigDebugPathMapper.getMappedLine(templatePosition.getLine(), generatedFile, project, true)) != -1) {
                generatedFiles.add(Pair.create((Object)generatedFile, (Object)generatedLine));
                return true;
            }
            return true;
        }));
        if (generatedFiles.isEmpty()) {
            LOG.warn(TWIG + PhpBundle.message((String)"template.debug.php.file.not.found", (Object[])new Object[]{file.getPath()}));
        }
        return (max = generatedFiles.stream().max(Comparator.comparingLong(i -> new File(((VirtualFile)i.first).getPath()).lastModified()))).isPresent() ? XDebuggerUtil.getInstance().createPosition((VirtualFile)max.get().first, ((Integer)max.get().second).intValue()) : templatePosition;
    }

    @Nullable
    private static String getTemplatePath(@NotNull VirtualFile generatedFile, @NotNull Project project) {
        PhpClass phpClass;
        PsiFile psiFile;
        if (generatedFile == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(9);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(generatedFile)) instanceof PhpFile && (phpClass = PhpPsiUtil.findClass((PhpFile)((PhpFile)psiFile), i -> i.getName().contains(TWIG_TEMPLATE))) != null) {
            Method getSourceContext = phpClass.findMethodByName((CharSequence)GET_SOURCE_CONTEXT);
            NewExpression newExpression = (NewExpression)SyntaxTraverser.psiTraverser((PsiElement)getSourceContext).filter(NewExpression.class).first();
            PsiElement[] parameters = newExpression != null ? newExpression.getParameters() : null;
            PsiElement path = parameters != null && parameters.length != 0 ? parameters[parameters.length - 1] : null;
            return path instanceof StringLiteralExpression ? ((StringLiteralExpression)path).getContents() : null;
        }
        return null;
    }

    private static int getMappedLine(int position, VirtualFile generatedFile, @NotNull Project project, boolean forward) {
        PhpClass phpClass;
        PsiFile psiFile;
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(10);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(generatedFile)) instanceof PhpFile && (phpClass = PhpPsiUtil.findClass((PhpFile)((PhpFile)psiFile), i -> i.getName().contains(TWIG_TEMPLATE))) != null) {
            Method getDebugInfo = phpClass.findMethodByName((CharSequence)GET_DEBUG_INFO);
            JBIterable hashElements = SyntaxTraverser.psiTraverser((PsiElement)getDebugInfo).filter(ArrayHashElement.class);
            return forward ? TwigDebugPathMapper.getGeneratedLine(position, (Iterable<ArrayHashElement>)hashElements) : TwigDebugPathMapper.getTemplateLine(position, (Iterable<ArrayHashElement>)hashElements);
        }
        return -1;
    }

    private static int getGeneratedLine(int templateLine, @NotNull Iterable<ArrayHashElement> hashElements) {
        ArrayHashElement element;
        if (hashElements == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(11);
        }
        return (element = (ArrayHashElement)ContainerUtil.find(hashElements, i -> i.getValue() != null && StringUtil.parseInt((String)i.getValue().getText(), (int)-1) == templateLine + 1)) != null && element.getKey() != null ? StringUtil.parseInt((String)element.getKey().getText(), (int)-1) - 1 : -1;
    }

    private static int getTemplateLine(int genLine, @NotNull Iterable<ArrayHashElement> hashElements) {
        ArrayHashElement element;
        if (hashElements == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(12);
        }
        return (element = (ArrayHashElement)ContainerUtil.find(hashElements, i -> i.getKey() != null && StringUtil.parseInt((String)i.getKey().getText(), (int)-1) - 1 == genLine)) != null && element.getValue() != null ? StringUtil.parseInt((String)element.getValue().getText(), (int)-1) - 1 : -1;
    }

    protected PhpTemplateDebugStateService getTemplateDebugInstance(@NotNull Project project) {
        if (project == null) {
            TwigDebugPathMapper.$$$reportNull$$$0(13);
        }
        return TwigDebugStateService.getInstance(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePathMapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashElements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/debug/TwigDebugPathMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTemplateFileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isGeneratedFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mapToTemplate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mapToPhp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplatePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getMappedLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getGeneratedLine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateDebugInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

