/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.twig.TwigConfiguration;
import com.jetbrains.twig.TwigTokenTypes;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;

class _TwigLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int TWIG = 2;
    public static final int TWIG_DOUBLEQUOTED_STRING = 4;
    public static final int TWIG_SINGLEQUOTED_STRING = 6;
    public static final int TWIG_RAW = 8;
    public static final int RAW_TEMPLATE_DATA = 10;
    public static final int RAW_END = 12;
    public static final int TWIG_START = 14;
    public static final int TWIG_END = 16;
    public static final int TWIG_COMMENT = 18;
    public static final int VERBATIM_START = 20;
    public static final int VERBATIM = 22;
    public static final int VERBATIM_END = 24;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12};
    static final char[] ZZ_CMAP_Z = _TwigLexer.zzUnpackCMap("\u0001\u0000C\u0080");
    static final char[] ZZ_CMAP_Y = _TwigLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002*\u0003\u0001\u0004\u0012\u0003\u0001\u0005\u001f\u0003\u0001\u0004\u009f\u0003");
    static final char[] ZZ_CMAP_A = _TwigLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u000b\u0002\u0001\u0001\u000b\u0012\u0000\u0001\u0001\u0001'\u0001\u000f\u0001\u0000\u0001\t\u0001\u0005\u0001\u0000\u0001\u0010\u00012\u00013\u0001+\u0001\u000e\u00011\u0001\u0004\u0001\f\u0001,\n\b\u00010\u0001\u0000\u0001(\u0001&\u0001)\u00015\u0001\u0000\u0001$\u0001#\u0001\u001a\u0001\u001d\u0001\r\u0001\u0018\u0001\u0006\u0001!\u0001\u0012\u0002\u0006\u0001\u001b\u0001\u0013\u0001\u0019\u0001\u0015\u0001\u0014\u0001\u0006\u0001\u0016\u0001\u001f\u0001\u0017\u0001\u001c\u0001\"\u0001 \u0001-\u0001%\u0001\u0006\u0001.\u0001\n\u0001/\u0001\u0000\u0001\u0007\u0001\u0000\u0001$\u0001#\u0001\u001a\u0001\u001d\u0001\r\u0001\u0018\u0001\u0006\u0001!\u0001\u0012\u0002\u0006\u0001\u001b\u0001\u0013\u0001\u0019\u0001\u0015\u0001\u0014\u0001\u0006\u0001\u0016\u0001\u001f\u0001\u0017\u0001\u001c\u0001\"\u0001 \u0001-\u0001%\u0001\u0006\u0001\u0002\u00014\u0001\u0003\u0001*\u0006\u0000\u0001\u0001\u001a\u0000\u0001\u0001\u008f\u0000\u0002\u0011M\u0000\u0001\u001e\u0080\u0000\u0001\u0001\u007f\u0000\u000b\u0001\u001d\u0000\u0002\u0001\u0005\u0000\u0001\u0001/\u0000\u0001\u0001 \u0000");
    private static final int[] ZZ_ACTION = _TwigLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\r\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0003\u0001\u0004\u0001\u0006\u0001\u0007\u0001\b\u0001\u0007\u0001\t\u0002\n\u0003\u0004\u0001\u000b\u0001\u0004\u0006\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0004\u0006\u0011\u0001\u0018\u0001\u0004\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0002(\u0001)\u0002*\u0007\u0000\u0001+\u0002\u0000\u0004\u000b\u0001\u0000\u0001\u000b\u0001\u0000\u0002\u000b\u0001\u0011\u0001\u0000\u0001\u0011\u0001\u0000\u0001\u0012\u0001,\u0001\u0000\u0001-\u0001.\u0001/\u0001\u0011\u0001-\u0001.\u0001/\u00010\u0003\u0011\u0001\u0000\u0002\u0011\u00021\u00012\u00013\u00014\u00015\u00016\u00017\u0002\u0000\u00018\u0003\u0000\u0002\u000b\u00019\u0001\u000b\u0002:\u0001\u0000\u0002\u000b\u0002\u0011\u0001\u0000\u0001\u0011\u0002\u0012\u0001\u0000\u0003\u0011\u0001;\u0001\u0000\u0001\u0011\u0001<\u0005\u0000\u0002\u000b\u0001=\u0002>\u0001\u000b\u0002\u0011\u0001\u0000\u0001\u0011\u0001\u0000\u0001\u0011\u0001?\u0001\u0000\u0002@\u0004\u0000\u0003\u000b\u0002\u0011\u0002A\u0001\u0000\u0001\u0011\u0001B\u0001\u0000\u0001=\u0001\u0000\u0002\u000b\u0001\u0011\u0001\u0000\u0001\u0011\u0002C\u0001\u0000\u0002D\u0001\u0000\u0001\u000b\u0001\u0011\u0002\u0000\u0002E";
    private static final int[] ZZ_ROWMAP = _TwigLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00006\u0000l\u0000\u00a2\u0000\u00d8\u0000\u010e\u0000\u0144\u0000\u017a\u0000\u01b0\u0000\u01e6\u0000\u021c\u0000\u0252\u0000\u0288\u0000\u02be\u0000\u02be\u0000\u02f4\u0000\u032a\u0000\u0360\u0000\u0396\u0000\u03cc\u0000\u0402\u0000\u02be\u0000\u0438\u0000\u046e\u0000\u02be\u0000\u02be\u0000\u04a4\u0000\u02be\u0000\u04da\u0000\u0510\u0000\u0546\u0000\u057c\u0000\u05b2\u0000\u05e8\u0000\u061e\u0000\u0654\u0000\u068a\u0000\u06c0\u0000\u06f6\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u072c\u0000\u0762\u0000\u0798\u0000\u07ce\u0000\u0804\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u083a\u0000\u0870\u0000\u08a6\u0000\u08dc\u0000\u0912\u0000\u0948\u0000\u097e\u0000\u09b4\u0000\u09ea\u0000\u0a20\u0000\u0a56\u0000\u02be\u0000\u0a8c\u0000\u0ac2\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u0af8\u0000\u02be\u0000\u0b2e\u0000\u02be\u0000\u02be\u0000\u0b64\u0000\u032a\u0000\u0360\u0000\u03cc\u0000\u0402\u0000\u0b9a\u0000\u0bd0\u0000\u0510\u0000\u02be\u0000\u0c06\u0000\u0c3c\u0000\u0c72\u0000\u0ca8\u0000\u0cde\u0000\u0d14\u0000\u0d4a\u0000\u0d80\u0000\u0db6\u0000\u0dec\u0000\u0e22\u0000\u0e58\u0000\u0e8e\u0000\u0ec4\u0000\u0efa\u0000\u0f30\u0000\u02be\u0000\u0f66\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u0f9c\u0000\u072c\u0000\u072c\u0000\u072c\u0000\u072c\u0000\u0fd2\u0000\u1008\u0000\u103e\u0000\u1074\u0000\u10aa\u0000\u10e0\u0000\u02be\u0000\u072c\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u02be\u0000\u1116\u0000\u114c\u0000\u02be\u0000\u1182\u0000\u11b8\u0000\u11ee\u0000\u1224\u0000\u125a\u0000\u0546\u0000\u1290\u0000\u02be\u0000\u0546\u0000\u12c6\u0000\u12fc\u0000\u1332\u0000\u1368\u0000\u139e\u0000\u13d4\u0000\u140a\u0000\u1440\u0000\u1476\u0000\u14ac\u0000\u14e2\u0000\u1518\u0000\u154e\u0000\u072c\u0000\u1584\u0000\u15ba\u0000\u072c\u0000\u15f0\u0000\u1626\u0000\u046e\u0000\u165c\u0000\u1692\u0000\u16c8\u0000\u16fe\u0000\u0546\u0000\u02be\u0000\u0546\u0000\u1734\u0000\u176a\u0000\u17a0\u0000\u17d6\u0000\u180c\u0000\u1842\u0000\u1878\u0000\u072c\u0000\u18ae\u0000\u02be\u0000\u072c\u0000\u18e4\u0000\u0b2e\u0000\u191a\u0000\u1950\u0000\u1986\u0000\u19bc\u0000\u19f2\u0000\u1a28\u0000\u1a5e\u0000\u02be\u0000\u072c\u0000\u1a94\u0000\u1aca\u0000\u02be\u0000\u1b00\u0000\u02be\u0000\u1b36\u0000\u1b6c\u0000\u1ba2\u0000\u1bd8\u0000\u1c0e\u0000\u1c44\u0000\u02be\u0000\u072c\u0000\u1c7a\u0000\u02be\u0000\u0546\u0000\u1cb0\u0000\u1ce6\u0000\u1d1c\u0000\u1d52\u0000\u1d88\u0000\u02be\u0000\u0546";
    private static final int[] ZZ_TRANS = _TwigLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "6\u000e6\u000f\n\u0010\u0001\u0011\u0004\u0010\u0001\u0012&\u0010\n\u0013\u0001\u0014\u0005\u0013\u0001\u0015%\u0013\u0001\u0016\u0001\u0017\t\u0016\u0001\u0017\n\u0016\u0001\u0018\u001f\u00166\u0019\u0001\u001a\u0001\u0017\t\u001a\u0001\u0017\u0001\u001a\u0001\u001b(\u001a\u0001\u001c\u0001\u0017\u0002\u001c\u0001\u001d\u0001\u001e\u0002\u001f\u0003\u001c\u0001\u0017\u0001\u001c\u0001\u001f\u0003\u001c\u0001 \u0001!\u0003\u001f\u0001\"\u0001\u001f\u0001#\u0003\u001f\u0001$\u0001\u001f\u0001\u001c\u0001\u001f\u0001%\u0001\u001f\u0001&\u0003\u001f\u0007\u001c\u0001\u001f\t\u001c\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u0001\u001c\u0001'\u00010\u0001,\u00011\u00012\u00013\u00014\u00015\u0002,\u00016\u0002,\u00017\u00018\u0004,\u0001\u001c\u0001,\u00019\u0003,\u0001:\u0001,\u0001;\u0001<\u0001=\u0001>\u0001?\u0001@\u0001A\u0001,\u0001B\u0001C\u0001D\u0001E\u0001F\u0001G\u0001H\u0001I\u0001J\u0001K\tJ\u0001K*J\u0001L\u0001\u0017\tL\u0001\u0017\u0016L\u0001M\u0013L6N\u0001O\u0001\u0017\tO\u0001\u0017\u0001O\u0001P(O6\u0000\n\u0010\u0001Q\u0004\u0010\u0001R1\u0010\u0001\u0000*\u0010\u000f\u0000\u0001\u0010&\u0000\n\u0013\u0001S\u0005\u0013\u0001T0\u0013\u0001\u0000*\u0013\u0010\u0000\u0001\u0013&\u0000\u0001\u0017\t\u0000\u0001\u0017N\u0000\u0001U*\u0000\u0001V!\u0000\u0001W3\u0000\u0001X8\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u001b\u0000\u0001Y\u0005\u0000\u0001Z\"\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0001\u001f\u0001[\u0005\u001f\u0001\\\u0004\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0005\u001f\u0001]\u0001\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0004\u001f\u0001^\u0007\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001_\u0001`\u0006\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0003\u0000\u0001a\u0001b\u000b\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001c\u0004\u0000\f\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\t\u0000\u0001'\t\u0000\u0001'0\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\b,\u0001d\u0003,\u0001e\u0001f\u0006,\u0007\u0000\u0001,\u0010\u0000\u0001.\u0003\u0000\u0001g\u0001h.\u0000\u0003/\u0004\u0000\u0001/\u0004\u0000\f/\u0001\u0000\u0007/\u0007\u0000\u0001/\u0014\u0000\u0001i<\u0000\u0001j\u0004\u0000\u0001k\u0001l\u0004\u0000\u0002m\u001c\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0001,\u0001n\u0004,\u0001o\u0001p\u0004,\u0001m\u0001q\u0006,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0004,\u0001r\u0002,\u0001s\u0004,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0005,\u0001t\u0001,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0003,\u0001u\b,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0003\u0000\u0001v\u0001w\u000b,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0007,\u0001x\u0004,\u0001y\u0001z\u0006,\u0007\u0000\u0001,.\u0000\u0001{5\u0000\u0001|5\u0000\u0001}5\u0000\u0001~:\u0000\u0001\u007f6\u0000\u0001\u0080\n\u0000\u0001K\t\u0000\u0001K7\u0000\u0001\u0081A\u0000\u0001\u0082<\u0000\u0001\u00832\u0000\u0001\u0084,\u0000\u0001\u0085;\u0000\u0001\u0086!\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0002\u001f\u0001\u0087\t\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\b\u001f\u0001\u0088\u0003\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0001\u001f\u0001\u0089\u0005\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0003\u001f\u0001\u008a\b\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u0015\u0000\u0001\u008b.\u0000\u0003\u001f\u0004\u0000\u0001\u008c\u0004\u0000\f\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u001f\u0000\u0001\u008d$\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0005\u001f\u0001\u008e\u0006\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0004\u001f\u0001\u008f\u0007\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0003,\u0001\u0090\b,\u0001\u0000\u0002,\u0001\u0091\u0004,\u0007\u0000\u0001,\u0015\u0000\u0001\u0092.\u0000\u0003,\u0004\u0000\u0001\u0093\u0004\u0000\f,\u0001\u0000\u0007,\u0007\u0000\u0001,\u0010\u0000\u0001\u00941\u0000\u0001\u0095\u0003\u0000\u0001\u0095\u0005\u0000\u0001\u0095;\u0000\u0001\u0096'\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0002,\u0001\u0097\t,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\t,\u0001\u0098\u0002,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\t,\u0001\u0099\u0002,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0005,\u0001\u009a\u0006,\u0001\u0000\u0007,\u0007\u0000\u0001,\u001f\u0000\u0001\u009b$\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0005,\u0001\u009c\u0006,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u000b,\u0001\u009d\u0001\u0000\u0007,\u0007\u0000\u0001,\u001e\u0000\u0001\u009e<\u0000\u0001\u009f.\u0000\u0001\u00a04\u0000\u0001\u00a1;\u0000\u0001\u00a2 \u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0003\u001f\u0001\u00a3\b\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\t\u001f\u0001\u00a4\u0002\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0001\u001f\u0001\u00a5\n\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f)\u0000\u0001\u00a6\u001a\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0002\u001f\u0001\u00a7\u0004\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0004\u001f\u0001\u00a8\u0002\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0007,\u0001\u00a9\u0004,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0005,\u0001\u00aa\u0001,\u0007\u0000\u0001,#\u0000\u0001\u00ab \u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\t,\u0001\u00ac\u0002,\u0001\u0000\u0007,\u0007\u0000\u0001,\u0010\u0000\u0001\u0094\u0004\u0000\u0001h0\u0000\u0001\u0095B\u0000\u0001\u00ad&\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0003,\u0001\u00ae\b,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0006,\u0001\u00af\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u00b0\u0007,\u0007\u0000\u0001,)\u0000\u0001\u00b1\u001a\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0002,\u0001\u00b2\u0004,\u0007\u0000\u0001,+\u0000\u0001\u00b34\u0000\u0001\u00b4)\u0000\u0001\u00b5;\u0000\u0001\u00b6\u001f\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0004\u001f\u0001\u00b7\u0007\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\n\u001f\u0001\u00b8\u0001\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\f\u001f\u0001\u0000\u0005\u001f\u0001\u00b9\u0001\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0005,\u0001\u00ba\u0006,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0004,\u0001\u00bb\u0007,\u0001\u0000\u0007,\u0007\u0000\u0001, \u0000\u0001\u00bc#\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0006,\u0001\u00bd\u0005,\u0001\u0000\u0007,\u0007\u0000\u0001,\u001e\u0000\u0001\u00be%\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0004,\u0001\u00bf\u0007,\u0001\u0000\u0007,\u0007\u0000\u0001,\u0015\u0000\u0001\u00c0L\u0000\u0001\u00c1(\u0000\u0001\u00c2;\u0000\u0001\u00c3\u001e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0005\u001f\u0001\u00a5\u0006\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u000b\u001f\u0001\u00c4\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0005\u001f\u0001\u00c5\u0006\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001\u00c6\u0004\u0000\f,\u0001\u0000\u0007,\u0007\u0000\u0001,\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u00c7\u0001\u00c8\u0006,\u0007\u0000\u0001,\u001f\u0000\u0001\u00c9$\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0005,\u0001\u00ca\u0006,\u0001\u0000\u0007,\u0007\u0000\u0001,\u001f\u0000\u0001\u00cb+\u0000\u0001\u00cc.\u0000\u0003\u001f\u0004\u0000\u0001\u00cd\u0004\u0000\f\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0003\u0000\u0001\u00ce\u0001\u00cf\u000b\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\f,\u0001\u0000\u0007,\u0007\u0000\u0001\u00d0\u0015\u0000\u0001\u00d1.\u0000\u0003,\u0004\u0000\u0001\u00d0\u0004\u0000\f,\u0001\u0000\u0007,\u0007\u0000\u0001,\u0019\u0000\u0002\u00d26\u0000\u0001\u00d3(\u0000\u0003\u001f\u0004\u0000\u0001\u001f\u0004\u0000\u0001\u001f\u0001\u00d4\n\u001f\u0001\u0000\u0007\u001f\u0007\u0000\u0001\u001f\u000e\u0000\u0003,\u0004\u0000\u0001,\u0004\u0000\u0005,\u0001\u00bd\u0006,\u0001\u0000\u0007,\u0007\u0000\u0001,\u001f\u0000\u0001\u00bc1\u0000\u0001\u0083\"\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _TwigLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\r\u0000\u0002\t\u0006\u0001\u0001\t\u0002\u0001\u0002\t\u0001\u0001\u0001\t\u000b\u0001\u0004\t\u0005\u0001\u0003\t\u000b\u0001\u0001\t\u0002\u0001\t\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0001\u0001\u0007\u0000\u0001\t\u0002\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0003\t\b\u0001\u0001\u0000\u0002\u0001\u0001\t\u0001\u0001\u0006\t\u0002\u0000\u0001\t\u0003\u0000\u0004\u0001\u0001\t\u0001\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u0002\u0001\u0005\u0000\u0003\u0001\u0001\t\u0004\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0001\t\u0001\u0001\u0004\u0000\u0005\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0003\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\t\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int braceLevel = 0;
    private boolean afterTagStart = false;
    private TwigConfiguration.TwigLexerProperties myLexerConfiguration = TwigConfiguration.TwigLexerProperties.DEFAULT;
    private SecondaryState mySecondaryState = SecondaryState.INITIAL;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 14] | ch >> 7 & 0x7F] << 7 | ch & 0x7F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[212];
        int offset = 0;
        offset = _TwigLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[212];
        int offset = 0;
        offset = _TwigLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[7614];
        int offset = 0;
        offset = _TwigLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[212];
        int offset = 0;
        offset = _TwigLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _TwigLexer(TwigConfiguration.TwigLexerProperties state) {
        this((Reader)null);
        this.myLexerConfiguration = state;
    }

    protected boolean canReadAt(int pos) {
        return 0 <= pos && pos < this.zzBuffer.length();
    }

    @Nullable
    public IElementType tryStartDelimiter(String delimiter, IElementType type) {
        int pos;
        int whitespaceEraserOffset = 0;
        for (pos = 0; this.canReadAt(this.zzCurrentPos + pos) && pos < delimiter.length() && this.zzBuffer.charAt(this.zzCurrentPos + pos) == delimiter.charAt(pos); ++pos) {
        }
        if (this.canReadAt(this.zzCurrentPos + pos) && this.zzBuffer.charAt(this.zzCurrentPos + pos) == '-') {
            ++pos;
            ++whitespaceEraserOffset;
        }
        if (pos == delimiter.length() + whitespaceEraserOffset) {
            this.zzMarkedPos = this.zzStartRead + pos;
            return type;
        }
        return null;
    }

    @Nullable
    public IElementType tryBlockEndDelimiter(IElementType type, String delimiter) {
        int pos = 0;
        int whitespaceEraserOffset = 0;
        if (this.canReadAt(this.zzCurrentPos + pos) && this.zzBuffer.charAt(this.zzCurrentPos + pos) == '-') {
            ++pos;
            ++whitespaceEraserOffset;
        }
        while (this.canReadAt(this.zzCurrentPos + pos) && pos - whitespaceEraserOffset < delimiter.length() && this.zzBuffer.charAt(this.zzCurrentPos + pos) == delimiter.charAt(pos - whitespaceEraserOffset)) {
            ++pos;
        }
        if (pos == delimiter.length() + whitespaceEraserOffset) {
            this.zzMarkedPos = this.zzStartRead + pos;
            return type;
        }
        return null;
    }

    public boolean lookAheadForEndVerbatimDelimiter(String verbatimOrRaw, int state) {
        int index = this.zzCurrentPos;
        String startDelimiter = this.myLexerConfiguration.getBlockStartDelimiter();
        if (this.canReadAt(index + startDelimiter.length()) && StringUtil.equals((CharSequence)this.zzBuffer.subSequence(index, index + startDelimiter.length()), (CharSequence)startDelimiter)) {
            index += startDelimiter.length();
        }
        while (this.canReadAt(index) && this.zzBuffer.charAt(index) == ' ') {
            ++index;
        }
        int verbatimLength = index + verbatimOrRaw.length();
        if (this.canReadAt(verbatimLength) && StringUtil.equalsIgnoreCase((CharSequence)this.zzBuffer.subSequence(index, verbatimLength), (CharSequence)verbatimOrRaw)) {
            this.yybegin(state);
            return true;
        }
        return false;
    }

    public boolean checkAheadFor(String token) {
        if (!this.canReadAt(this.zzMarkedPos + token.length())) {
            return false;
        }
        CharSequence actualToken = this.zzBuffer.subSequence(this.zzMarkedPos, this.zzMarkedPos + token.length());
        return StringUtil.equals((CharSequence)actualToken, (CharSequence)token);
    }

    _TwigLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block140: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _TwigLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    IElementType delimiter = this.tryStartDelimiter(this.myLexerConfiguration.getDocStartDelimiter(), TwigTokenTypes.COMMENT_START);
                    if (delimiter != null) {
                        this.yybegin(18);
                        return delimiter;
                    }
                    delimiter = this.tryStartDelimiter(this.myLexerConfiguration.getVariableStartDelimiter(), TwigTokenTypes.PRINT_BLOCK_START);
                    if (delimiter != null) {
                        this.yybegin(2);
                        this.mySecondaryState = SecondaryState.PRINT;
                        return delimiter;
                    }
                    delimiter = this.tryStartDelimiter(this.myLexerConfiguration.getBlockStartDelimiter(), TwigTokenTypes.STATEMENT_BLOCK_START);
                    if (delimiter != null) {
                        this.yybegin(14);
                        return delimiter;
                    }
                    return TwigTokenTypes.TEMPLATE_HTML_TEXT;
                }
                case 70: {
                    continue block140;
                }
                case 2: {
                    IElementType delimiter;
                    if (this.mySecondaryState != SecondaryState.PRINT && (delimiter = this.tryBlockEndDelimiter(TwigTokenTypes.STATEMENT_BLOCK_END, this.myLexerConfiguration.getBlockEndDelimiter())) != null) {
                        this.yybegin(0);
                        return delimiter;
                    }
                    delimiter = this.tryBlockEndDelimiter(TwigTokenTypes.PRINT_BLOCK_END, this.myLexerConfiguration.getVariableEndDelimiter());
                    if (delimiter != null) {
                        if (this.braceLevel <= 0) {
                            this.yybegin(0);
                            return TwigTokenTypes.PRINT_BLOCK_END;
                        }
                        --this.braceLevel;
                        this.yypushback(1);
                        return TwigTokenTypes.RBRACE_CURL;
                    }
                    this.yypushback(1);
                    this.yybegin(16);
                }
                case 71: {
                    continue block140;
                }
                case 3: {
                    return TwigTokenTypes.STRING_TEXT;
                }
                case 72: {
                    continue block140;
                }
                case 4: {
                    this.yybegin(0);
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 73: {
                    continue block140;
                }
                case 5: {
                    this.yybegin(2);
                    return TwigTokenTypes.DOUBLE_QUOTE;
                }
                case 74: {
                    continue block140;
                }
                case 6: {
                    this.yybegin(2);
                    return TwigTokenTypes.SINGLE_QUOTE;
                }
                case 75: {
                    continue block140;
                }
                case 7: {
                    IElementType delimiter = this.tryBlockEndDelimiter(TwigTokenTypes.STATEMENT_BLOCK_END, this.myLexerConfiguration.getBlockEndDelimiter());
                    if (delimiter != null) {
                        this.yybegin(10);
                        return delimiter;
                    }
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 76: {
                    continue block140;
                }
                case 8: {
                    return TwigTokenTypes.WHITE_SPACE;
                }
                case 77: {
                    continue block140;
                }
                case 9: {
                    if (this.lookAheadForEndVerbatimDelimiter("endraw", 12)) {
                        this.yypushback(1);
                    }
                    return TwigTokenTypes.TEMPLATE_HTML_TEXT;
                }
                case 78: {
                    continue block140;
                }
                case 10: {
                    IElementType tokenType = this.tryStartDelimiter(this.myLexerConfiguration.getBlockStartDelimiter(), TwigTokenTypes.STATEMENT_BLOCK_START);
                    if (tokenType == null) {
                        tokenType = this.tryBlockEndDelimiter(TwigTokenTypes.STATEMENT_BLOCK_END, this.myLexerConfiguration.getBlockEndDelimiter());
                        this.yybegin(0);
                    }
                    if (tokenType != null) {
                        return tokenType;
                    }
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 79: {
                    continue block140;
                }
                case 11: {
                    this.yybegin(2);
                    this.mySecondaryState = SecondaryState.INITIAL;
                    return TwigTokenTypes.TAG_NAME;
                }
                case 80: {
                    continue block140;
                }
                case 12: {
                    this.yybegin(2);
                    return TwigTokenTypes.WHITE_SPACE;
                }
                case 81: {
                    continue block140;
                }
                case 13: {
                    this.yybegin(2);
                    ++this.braceLevel;
                    return TwigTokenTypes.LBRACE_CURL;
                }
                case 82: {
                    continue block140;
                }
                case 14: {
                    this.yybegin(2);
                    --this.braceLevel;
                    return TwigTokenTypes.RBRACE_CURL;
                }
                case 83: {
                    continue block140;
                }
                case 15: {
                    this.yybegin(2);
                    return TwigTokenTypes.MINUS;
                }
                case 84: {
                    continue block140;
                }
                case 16: {
                    this.yybegin(2);
                    return TwigTokenTypes.MOD;
                }
                case 85: {
                    continue block140;
                }
                case 17: {
                    this.yybegin(2);
                    return TwigTokenTypes.IDENTIFIER;
                }
                case 86: {
                    continue block140;
                }
                case 18: {
                    this.yybegin(2);
                    return TwigTokenTypes.NUMBER;
                }
                case 87: {
                    continue block140;
                }
                case 19: {
                    this.yybegin(2);
                    if (this.mySecondaryState == SecondaryState.PRINT) {
                        return TwigTokenTypes.VAR_IDENTIFIER;
                    }
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 88: {
                    continue block140;
                }
                case 20: {
                    this.yybegin(2);
                    return TwigTokenTypes.DOT;
                }
                case 89: {
                    continue block140;
                }
                case 21: {
                    this.yybegin(2);
                    return TwigTokenTypes.PLUS;
                }
                case 90: {
                    continue block140;
                }
                case 22: {
                    this.yybegin(4);
                    return TwigTokenTypes.DOUBLE_QUOTE;
                }
                case 91: {
                    continue block140;
                }
                case 23: {
                    this.yybegin(6);
                    return TwigTokenTypes.SINGLE_QUOTE;
                }
                case 92: {
                    continue block140;
                }
                case 24: {
                    this.yybegin(2);
                    return TwigTokenTypes.EQ;
                }
                case 93: {
                    continue block140;
                }
                case 25: {
                    this.yybegin(2);
                    return TwigTokenTypes.LT;
                }
                case 94: {
                    continue block140;
                }
                case 26: {
                    this.yybegin(2);
                    return TwigTokenTypes.GT;
                }
                case 95: {
                    continue block140;
                }
                case 27: {
                    this.yybegin(2);
                    return TwigTokenTypes.CONCAT;
                }
                case 96: {
                    continue block140;
                }
                case 28: {
                    this.yybegin(2);
                    return TwigTokenTypes.MUL;
                }
                case 97: {
                    continue block140;
                }
                case 29: {
                    this.yybegin(2);
                    return TwigTokenTypes.DIV;
                }
                case 98: {
                    continue block140;
                }
                case 30: {
                    this.yybegin(2);
                    return TwigTokenTypes.LBRACE_SQ;
                }
                case 99: {
                    continue block140;
                }
                case 31: {
                    this.yybegin(2);
                    return TwigTokenTypes.RBRACE_SQ;
                }
                case 100: {
                    continue block140;
                }
                case 32: {
                    this.yybegin(2);
                    return TwigTokenTypes.COLON;
                }
                case 101: {
                    continue block140;
                }
                case 33: {
                    this.yybegin(2);
                    return TwigTokenTypes.COMMA;
                }
                case 102: {
                    continue block140;
                }
                case 34: {
                    return TwigTokenTypes.LBRACE;
                }
                case 103: {
                    continue block140;
                }
                case 35: {
                    this.yybegin(2);
                    return TwigTokenTypes.RBRACE;
                }
                case 104: {
                    continue block140;
                }
                case 36: {
                    this.yybegin(2);
                    return TwigTokenTypes.FILTER;
                }
                case 105: {
                    continue block140;
                }
                case 37: {
                    this.yybegin(2);
                    return TwigTokenTypes.QUESTION;
                }
                case 106: {
                    continue block140;
                }
                case 38: {
                    IElementType type = this.tryBlockEndDelimiter(TwigTokenTypes.COMMENT_END, this.myLexerConfiguration.getDocEndDelimiter());
                    if (type != null) {
                        this.mySecondaryState = SecondaryState.INITIAL;
                        this.yybegin(0);
                        return TwigTokenTypes.COMMENT_END;
                    }
                    this.mySecondaryState = SecondaryState.COMMENT_TEXT;
                    this.yybegin(18);
                    return TwigTokenTypes.COMMENT_TEXT;
                }
                case 107: {
                    continue block140;
                }
                case 39: {
                    if (this.mySecondaryState != SecondaryState.COMMENT_TEXT) {
                        return TwigTokenTypes.WHITE_SPACE;
                    }
                    if (this.checkAheadFor(this.myLexerConfiguration.getDocEndDelimiter())) {
                        return TwigTokenTypes.WHITE_SPACE;
                    }
                    return TwigTokenTypes.COMMENT_TEXT;
                }
                case 108: {
                    continue block140;
                }
                case 40: {
                    IElementType delimiter = this.tryBlockEndDelimiter(TwigTokenTypes.STATEMENT_BLOCK_END, this.myLexerConfiguration.getBlockEndDelimiter());
                    if (delimiter != null) {
                        this.yybegin(22);
                        return delimiter;
                    }
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 109: {
                    continue block140;
                }
                case 41: {
                    if (this.lookAheadForEndVerbatimDelimiter("endverbatim", 24)) {
                        this.yypushback(1);
                    }
                    return TwigTokenTypes.VERBATIM_CONTENT;
                }
                case 110: {
                    continue block140;
                }
                case 42: {
                    IElementType tokenType = this.tryStartDelimiter(this.myLexerConfiguration.getBlockStartDelimiter(), TwigTokenTypes.STATEMENT_BLOCK_START);
                    if (tokenType == null) {
                        tokenType = this.tryBlockEndDelimiter(TwigTokenTypes.STATEMENT_BLOCK_END, this.myLexerConfiguration.getBlockEndDelimiter());
                        this.yybegin(0);
                    }
                    if (tokenType != null) {
                        return tokenType;
                    }
                    return TwigTokenTypes.BAD_CHARACTER;
                }
                case 111: {
                    continue block140;
                }
                case 43: {
                    this.yybegin(0);
                    return TwigTokenTypes.STATEMENT_BLOCK_END;
                }
                case 112: {
                    continue block140;
                }
                case 44: {
                    this.yybegin(2);
                    return TwigTokenTypes.RANGE;
                }
                case 113: {
                    continue block140;
                }
                case 45: {
                    this.yybegin(2);
                    return TwigTokenTypes.IF_KEYWORD;
                }
                case 114: {
                    continue block140;
                }
                case 46: {
                    this.yybegin(2);
                    return TwigTokenTypes.IN;
                }
                case 115: {
                    continue block140;
                }
                case 47: {
                    this.yybegin(2);
                    return TwigTokenTypes.IS;
                }
                case 116: {
                    continue block140;
                }
                case 48: {
                    this.yybegin(2);
                    return TwigTokenTypes.OR;
                }
                case 117: {
                    continue block140;
                }
                case 49: {
                    this.yybegin(2);
                    return this.mySecondaryState == SecondaryState.IMPORT_STATEMENT || this.mySecondaryState == SecondaryState.WITH_KEYWORD_STATEMENT ? TwigTokenTypes.AS_KEYWORD : TwigTokenTypes.IDENTIFIER;
                }
                case 118: {
                    continue block140;
                }
                case 50: {
                    this.yybegin(2);
                    return TwigTokenTypes.EQ_EQ;
                }
                case 119: {
                    continue block140;
                }
                case 51: {
                    this.yybegin(2);
                    return TwigTokenTypes.NOT_EQ;
                }
                case 120: {
                    continue block140;
                }
                case 52: {
                    this.yybegin(2);
                    return TwigTokenTypes.LE;
                }
                case 121: {
                    continue block140;
                }
                case 53: {
                    this.yybegin(2);
                    return TwigTokenTypes.GE;
                }
                case 122: {
                    continue block140;
                }
                case 54: {
                    this.yybegin(2);
                    return TwigTokenTypes.POW;
                }
                case 123: {
                    continue block140;
                }
                case 55: {
                    this.yybegin(2);
                    return TwigTokenTypes.DIV_DIV;
                }
                case 124: {
                    continue block140;
                }
                case 56: {
                    return TwigTokenTypes.TAG_NAME;
                }
                case 125: {
                    continue block140;
                }
                case 57: {
                    this.yybegin(8);
                    this.yypushback(this.yylength());
                }
                case 126: {
                    continue block140;
                }
                case 58: {
                    this.yybegin(2);
                    this.mySecondaryState = SecondaryState.USE_STATEMENT;
                    return TwigTokenTypes.TAG_NAME;
                }
                case 127: {
                    continue block140;
                }
                case 59: {
                    this.yybegin(2);
                    return TwigTokenTypes.NOT;
                }
                case 128: {
                    continue block140;
                }
                case 60: {
                    this.yybegin(2);
                    return TwigTokenTypes.AND;
                }
                case 129: {
                    continue block140;
                }
                case 61: {
                    this.yybegin(2);
                    this.mySecondaryState = SecondaryState.IMPORT_STATEMENT;
                    return TwigTokenTypes.TAG_NAME;
                }
                case 130: {
                    continue block140;
                }
                case 62: {
                    this.yybegin(2);
                    this.mySecondaryState = SecondaryState.WITH_STATEMENT;
                    return TwigTokenTypes.TAG_NAME;
                }
                case 131: {
                    continue block140;
                }
                case 63: {
                    this.yybegin(2);
                    return this.mySecondaryState == SecondaryState.WITH_KEYWORD_STATEMENT || this.mySecondaryState == SecondaryState.WITH_STATEMENT ? TwigTokenTypes.ONLY_KEYWORD : TwigTokenTypes.IDENTIFIER;
                }
                case 132: {
                    continue block140;
                }
                case 64: {
                    if (this.mySecondaryState == SecondaryState.INCLUDE_STATEMENT || this.mySecondaryState == SecondaryState.USE_STATEMENT) {
                        this.mySecondaryState = SecondaryState.WITH_KEYWORD_STATEMENT;
                        this.yybegin(2);
                        return TwigTokenTypes.WITH_KEYWORD;
                    }
                    this.yybegin(2);
                    return TwigTokenTypes.IDENTIFIER;
                }
                case 133: {
                    continue block140;
                }
                case 65: {
                    this.yybegin(2);
                    return TwigTokenTypes.RESERVED_ID;
                }
                case 134: {
                    continue block140;
                }
                case 66: {
                    this.yybegin(2);
                    return TwigTokenTypes.BOOLEAN;
                }
                case 135: {
                    continue block140;
                }
                case 67: {
                    this.yybegin(2);
                    return this.mySecondaryState == SecondaryState.IMPORT_STATEMENT ? TwigTokenTypes.IMPORT_KEYWORD : TwigTokenTypes.IDENTIFIER;
                }
                case 136: {
                    continue block140;
                }
                case 68: {
                    this.yybegin(2);
                    this.mySecondaryState = SecondaryState.INCLUDE_STATEMENT;
                    return TwigTokenTypes.TAG_NAME;
                }
                case 137: {
                    continue block140;
                }
                case 69: {
                    this.yybegin(20);
                    this.yypushback(this.yylength());
                }
                case 138: {
                    continue block140;
                }
            }
            this.zzScanError(1);
        }
    }

    private static enum SecondaryState {
        INITIAL,
        IMPORT_STATEMENT,
        USE_STATEMENT,
        INCLUDE_STATEMENT,
        WITH_STATEMENT,
        WITH_KEYWORD_STATEMENT,
        PRINT,
        COMMENT_TEXT;

    }
}

