/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.twig.TwigConfiguration;
import com.jetbrains.twig.TwigFileViewProvider;
import com.jetbrains.twig.formatter.TwigFormatterOptions;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigTypedHandler
extends TypedHandlerDelegate {
    public String getEndDelimiter(Project project, Document document, int offset, char typedChar) {
        String delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getBlockStartDelimiter(), TwigConfiguration.getInstance(project).getState().getBlockEndDelimiter(), typedChar);
        if (delimiter == null) {
            delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getVariableStartDelimiter(), TwigConfiguration.getInstance(project).getState().getVariableEndDelimiter(), typedChar);
        }
        if (delimiter == null) {
            delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getDocStartDelimiter(), TwigConfiguration.getInstance(project).getState().getDocEndDelimiter(), typedChar);
        }
        return delimiter;
    }

    @Nullable
    public String getEndDelimiter(Document document, int offset, String startDelimiter, String endDelimiter, char typedChar) {
        int length = startDelimiter.length();
        if (typedChar != startDelimiter.charAt(length - 1)) {
            return null;
        }
        for (int i = 1; i < length; ++i) {
            if (startDelimiter.charAt(length - i - 1) == TwigTypedHandler.getCharAt(document, offset - i)) continue;
            return null;
        }
        return endDelimiter;
    }

    public String getStringToInsert(Document document, int offset, String endDelimiter) {
        StringBuilder scanAheadForEndDelimiterStringBuilder = new StringBuilder();
        while (TwigTypedHandler.getCharAt(document, offset) == ' ') {
            ++offset;
        }
        for (int i = offset; i < endDelimiter.length() + offset; ++i) {
            scanAheadForEndDelimiterStringBuilder.append(TwigTypedHandler.getCharAt(document, i));
        }
        if (endDelimiter.equals(scanAheadForEndDelimiterStringBuilder.toString())) {
            return "";
        }
        if (endDelimiter.length() >= 2 && endDelimiter.substring(1).equals(scanAheadForEndDelimiterStringBuilder.substring(0, scanAheadForEndDelimiterStringBuilder.length() - 1))) {
            return endDelimiter.substring(0, 1);
        }
        return endDelimiter;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            TwigTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TwigTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TwigTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            TwigTypedHandler.$$$reportNull$$$0(3);
        }
        if (!(file.getViewProvider() instanceof TwigFileViewProvider)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        Function<TwigFormatterOptions, String> spacingStrategy = TwigTypedHandler.getSpacingStrategy(c, project);
        if (spacingStrategy == null) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        String endDelimiter = this.getEndDelimiter(project, editor.getDocument(), offset, c);
        if (endDelimiter != null) {
            TwigFormatterOptions settings = (TwigFormatterOptions)CodeStyle.getCustomSettings((PsiFile)file, TwigFormatterOptions.class);
            StringBuilder stringToInsert = new StringBuilder();
            stringToInsert.append(c);
            String spaceChar = spacingStrategy.apply(settings);
            stringToInsert.append(spaceChar);
            if (TwigTypedHandler.getCharAt(editor.getDocument(), offset) != ' ') {
                stringToInsert.append(spaceChar);
            }
            stringToInsert.append(this.getStringToInsert(editor.getDocument(), offset, endDelimiter));
            TwigTypedHandler.typeInStringAndMoveCaret(editor, stringToInsert.toString(), 1 + spaceChar.length());
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(editor.getDocument());
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TwigTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static char getCharAt(Document document, int offset) {
        if (offset >= document.getTextLength() || offset < 0) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    private static void typeInStringAndMoveCaret(Editor editor, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)str, (boolean)true, (int)caretShift);
    }

    @Nullable
    private static Function<TwigFormatterOptions, String> getSpacingStrategy(char c, @NotNull Project project) {
        if (project == null) {
            TwigTypedHandler.$$$reportNull$$$0(8);
        }
        String typedChar = String.valueOf(c);
        TwigConfiguration.TwigLexerProperties twigConfig = TwigConfiguration.getInstance(project).getState();
        if (twigConfig.getBlockStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_DELIMITERS ? " " : "";
        }
        if (twigConfig.getVariableStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_VARIABLE_DELIMITERS ? " " : "";
        }
        if (twigConfig.getDocStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_COMMENTS_DELIMITERS ? " " : "";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

