/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl;", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "users", "", "", "data", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsUser;", "allUsers", "", "(Ljava/util/Collection;Ljava/util/Map;Ljava/util/Set;)V", "allUsersByEmails", "Lcom/intellij/util/containers/MultiMap;", "allUsersByNames", "equals", "", "other", "", "getDisplayText", "getUsers", "", "root", "getValuesAsText", "hashCode", "", "matches", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "resolveUserName", "name", "toString", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private final MultiMap<String, VcsUser> allUsersByNames;
    private final MultiMap<String, VcsUser> allUsersByEmails;
    private final Collection<String> users;
    private final Map<VirtualFile, VcsUser> data;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<VcsUser> getUsers(@NotNull VirtualFile root) {
        void var3_4;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable iterable = this.users;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            Iterable list$iv = this.resolveUserName(root, it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_4;
    }

    @NotNull
    public Collection<String> getValuesAsText() {
        return this.users;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getDisplayText() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.users;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = Intrinsics.areEqual((Object)user, (Object)"*") ? VcsLogBundle.message((String)"vcs.log.user.filter.me", (Object[])new Object[0]) : user;
            collection.add(var12_11);
        }
        List users = (List)destination$iv$iv;
        String string = StringUtil.join((Collection)users, (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(users, \", \")");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public boolean matches(@NotNull VcsCommitMetadata commit) {
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                $this$any$iv = this.users;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block5;
                v0 = false;
                break block4;
            }
            for (T element$iv : $this$any$iv) {
                block7: {
                    block8: {
                        block6: {
                            name = (String)element$iv;
                            $i$a$-any-VcsLogUserFilterImpl$matches$1 = false;
                            v1 = commit.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"commit.root");
                            users = this.resolveUserName(v1, name);
                            var9_9 = users;
                            var10_10 = false;
                            if (!(var9_9.isEmpty() == false)) break block6;
                            v2 = users.contains(commit.getAuthor());
                            break block7;
                        }
                        if (!(Intrinsics.areEqual((Object)name, (Object)"*") ^ true)) break block8;
                        Intrinsics.checkNotNullExpressionValue((Object)VcsUserUtil.nameToLowerCase(name), (String)"VcsUserUtil.nameToLowerCase(name)");
                        v3 = commit.getAuthor();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"commit.author");
                        if (Intrinsics.areEqual((Object)VcsUserUtil.nameToLowerCase(v3.getName()), (Object)lowerUser)) ** GOTO lbl-1000
                        v4 = commit.getAuthor();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"commit.author");
                        v5 = VcsUserUtil.emailToLowerCase(v4.getEmail());
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"VcsUserUtil.emailToLowerCase(commit.author.email)");
                        if (StringsKt.startsWith$default((String)v5, (String)(lowerUser + '@'), (boolean)false, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v6 = true;
                        } else {
                            v6 = result = false;
                        }
                        if (result) {
                            VcsLogUserFilterImpl.LOG.warn("Unregistered author " + commit.getAuthor() + " for commit " + ((Hash)commit.getId()).asString() + "; search pattern " + name);
                        }
                        v2 = result;
                        break block7;
                    }
                    v2 = false;
                }
                if (!v2) continue;
                v0 = true;
                break block4;
            }
            v0 = false;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VcsUser> resolveUserName(VirtualFile root, String name) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)"*", (Object)name) ^ true) {
            return this.resolveUserName(name);
        }
        VcsUser vcsUser = this.data.get(root);
        if (vcsUser == null) {
            LOG.warn("Can not resolve user name for root " + root);
            return SetsKt.emptySet();
        }
        String string = vcsUser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vcsUser.name");
        Set<VcsUser> usersByName = this.resolveUserName(string);
        String string2 = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
        if (string2 == null) {
            return usersByName;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VcsUserUtil.getNameFromE\u2026il) ?: return usersByName");
        String emailNamePart = string2;
        Iterable $this$map$iv = usersByName;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            VcsUser vcsUser2 = (VcsUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = VcsUserUtil.emailToLowerCase(user.getEmail());
            collection.add(string3);
        }
        Set emails = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = this.resolveUserName(emailNamePart);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsUser candidateUser = (VcsUser)element$iv$iv;
            boolean bl = false;
            if (!emails.contains(VcsUserUtil.emailToLowerCase(candidateUser.getEmail()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List usersByEmail = (List)destination$iv$iv2;
        return SetsKt.plus(usersByName, (Iterable)usersByEmail);
    }

    private final Set<VcsUser> resolveUserName(String name) {
        String string = VcsUserUtil.getNameInStandardForm(name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsUserUtil.getNameInStandardForm(name)");
        String standardName = string;
        Collection collection = this.allUsersByNames.get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"allUsersByNames[standardName]");
        Iterable iterable = collection;
        Collection collection2 = this.allUsersByEmails.get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"allUsersByEmails[standardName]");
        return CollectionsKt.union((Iterable)iterable, (Iterable)collection2);
    }

    @NotNull
    public String toString() {
        return "author: " + StringUtil.join(this.users, (String)", ");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        VcsLogUserFilterImpl filter = (VcsLogUserFilterImpl)other;
        return Comparing.haveEqualElements(this.users, filter.users);
    }

    public int hashCode() {
        return Comparing.unorderedHashcode(this.users);
    }

    public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, ? extends VcsUser> data, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(allUsers, (String)"allUsers");
        this.users = users;
        this.data = data;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.create()");
        this.allUsersByNames = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"MultiMap.create()");
        this.allUsersByEmails = multiMap2;
        for (VcsUser vcsUser : allUsers) {
            String email;
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)vcsUser.getName(), (String)"user.name");
            CharSequence charSequence = name;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.allUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name), (Object)vcsUser);
            }
            Intrinsics.checkNotNullExpressionValue((Object)vcsUser.getEmail(), (String)"user.email");
            String nameFromEmail = VcsUserUtil.getNameFromEmail(email);
            if (nameFromEmail == null) continue;
            this.allUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)vcsUser);
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsLogUserFilterImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

