/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.log.ui.table.column.Author;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.Date;
import com.intellij.vcs.log.ui.table.column.Hash;
import com.intellij.vcs.log.ui.table.column.Root;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnProperties;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\t\b\u0001\u0018\u0000 '2\u00020\u0001:\u0003&'(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0014\u0010\u001b\u001a\u00020\u00162\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0012\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001e\u001a\u00020\nJ\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0 J\u0010\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0 J\u0006\u0010\"\u001a\u00020\nJ\u0012\u0010#\u001a\u00020\n2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0012\u0010$\u001a\u00020\u00122\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0014\u0010%\u001a\u00020\u00162\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tj\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u00100\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00120\tj\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u0012`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager;", "Lcom/intellij/openapi/Disposable;", "()V", "columnModelListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$ColumnModelListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentColumnIndices", "Ljava/util/HashMap;", "", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "Lkotlin/collections/HashMap;", "currentColumns", "Ljava/util/ArrayList;", "currentColumnsListeners", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$CurrentColumnsListener;", "currentColumnsProperties", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnProperties;", "modelIndices", "", "addColumnModelListener", "", "disposable", "listener", "addCurrentColumnsListener", "dispose", "forgetColumn", "column", "getColumn", "modelIndex", "getCurrentColumns", "", "getCurrentDynamicColumns", "getModelColumnsCount", "getModelIndex", "getProperties", "newColumn", "ColumnModelListener", "Companion", "CurrentColumnsListener", "intellij.platform.vcs.log.impl"})
public final class VcsLogColumnManager
implements Disposable {
    private final HashMap<String, Integer> modelIndices = new HashMap();
    private final ArrayList<VcsLogColumn<?>> currentColumns = new ArrayList();
    private final HashMap<Integer, VcsLogColumn<?>> currentColumnIndices = new HashMap();
    private final EventDispatcher<ColumnModelListener> columnModelListeners;
    private final EventDispatcher<CurrentColumnsListener> currentColumnsListeners;
    private final HashMap<VcsLogColumn<?>, VcsLogColumnProperties> currentColumnsProperties;
    private static final List<VcsLogDefaultColumn<? extends Object>> defaultColumns;
    @NotNull
    public static final Companion Companion;

    public final int getModelIndex(@NotNull VcsLogColumn<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Integer n = this.modelIndices.get(column.getId());
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @NotNull
    public final VcsLogColumn<?> getColumn(int modelIndex) {
        VcsLogColumn<?> vcsLogColumn = this.currentColumnIndices.get(modelIndex);
        Intrinsics.checkNotNull(vcsLogColumn);
        return vcsLogColumn;
    }

    public final int getModelColumnsCount() {
        return this.modelIndices.size();
    }

    @NotNull
    public final List<VcsLogColumn<?>> getCurrentColumns() {
        return this.currentColumns;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLogColumn<?>> getCurrentDynamicColumns() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.currentColumns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsLogColumn it = (VcsLogColumn)element$iv$iv;
            boolean bl = false;
            if (!it.isDynamic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final VcsLogColumnProperties getProperties(@NotNull VcsLogColumn<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        VcsLogColumnProperties vcsLogColumnProperties = this.currentColumnsProperties.get(column);
        Intrinsics.checkNotNull((Object)vcsLogColumnProperties);
        return vcsLogColumnProperties;
    }

    /*
     * WARNING - void declaration
     */
    private final void newColumn(VcsLogColumn<?> column) {
        Object object;
        void $this$getOrPut$iv;
        int newIndex = this.modelIndices.size();
        Map map2 = this.modelIndices;
        String key$iv = column.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = newIndex;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        int modelIndex = ((Number)object).intValue();
        map2 = this.currentColumnIndices;
        Integer n = modelIndex;
        boolean bl = false;
        Map map3 = map2;
        boolean bl2 = false;
        if (!map3.containsKey(n)) {
            this.currentColumns.add(column);
            ((Map)this.currentColumnIndices).put(modelIndex, column);
            ((Map)this.currentColumnsProperties).put(column, VcsLogColumnProperties.Companion.create(column));
            ((CurrentColumnsListener)this.currentColumnsListeners.getMulticaster()).columnAdded(column);
        }
        if (modelIndex == newIndex) {
            ((ColumnModelListener)this.columnModelListeners.getMulticaster()).newColumn(column, modelIndex);
        }
    }

    private final void forgetColumn(VcsLogColumn<?> column) {
        int modelIndex = this.getModelIndex(column);
        this.currentColumns.remove(column);
        this.currentColumnIndices.remove(modelIndex);
        this.currentColumnsProperties.remove(column);
        ((CurrentColumnsListener)this.currentColumnsListeners.getMulticaster()).columnRemoved(column);
    }

    public final void addColumnModelListener(@NotNull Disposable disposable, @NotNull ColumnModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.columnModelListeners.addListener((EventListener)listener2, disposable);
    }

    public final void addCurrentColumnsListener(@NotNull Disposable disposable, @NotNull CurrentColumnsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.currentColumnsListeners.addListener((EventListener)listener2, disposable);
    }

    public void dispose() {
    }

    public VcsLogColumnManager() {
        EventDispatcher eventDispatcher = EventDispatcher.create(ColumnModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(C\u2026odelListener::class.java)");
        this.columnModelListeners = eventDispatcher;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(CurrentColumnsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"EventDispatcher.create(C\u2026umnsListener::class.java)");
        this.currentColumnsListeners = eventDispatcher2;
        this.currentColumnsProperties = new HashMap();
        Iterable $this$forEach$iv = defaultColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsLogDefaultColumn column = (VcsLogDefaultColumn)element$iv;
            boolean bl = false;
            this.newColumn(column);
        }
        ExtensionPointListener customColumnListener2 = new ExtensionPointListener<VcsLogCustomColumn<?>>(this){
            final /* synthetic */ VcsLogColumnManager this$0;

            public void extensionAdded(@NotNull VcsLogCustomColumn<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                VcsLogColumnManager.access$newColumn(this.this$0, extension);
            }

            public void extensionRemoved(@NotNull VcsLogCustomColumn<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                VcsLogColumnManager.access$forgetColumn(this.this$0, extension);
            }
            {
                this.this$0 = this$0;
            }
        };
        VcsLogCustomColumn.KEY.getPoint().addExtensionPointListener(customColumnListener2, true, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        defaultColumns = CollectionsKt.listOf((Object[])new VcsLogDefaultColumn[]{Root.INSTANCE, Commit.INSTANCE, Author.INSTANCE, Date.INSTANCE, Hash.INSTANCE});
    }

    public static final /* synthetic */ void access$newColumn(VcsLogColumnManager $this, VcsLogColumn column) {
        $this.newColumn(column);
    }

    public static final /* synthetic */ void access$forgetColumn(VcsLogColumnManager $this, VcsLogColumn column) {
        $this.forgetColumn(column);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogColumnManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$ColumnModelListener;", "Ljava/util/EventListener;", "newColumn", "", "column", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "modelIndex", "", "intellij.platform.vcs.log.impl"})
    public static interface ColumnModelListener
    extends EventListener {
        public void newColumn(@NotNull VcsLogColumn<?> var1, int var2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0017J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0017\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$CurrentColumnsListener;", "Ljava/util/EventListener;", "columnAdded", "", "column", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "columnRemoved", "intellij.platform.vcs.log.impl"})
    public static interface CurrentColumnsListener
    extends EventListener {
        @JvmDefault
        default public void columnAdded(@NotNull VcsLogColumn<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
        }

        @JvmDefault
        default public void columnRemoved(@NotNull VcsLogColumn<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$Companion;", "", "()V", "defaultColumns", "", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "getInstance", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VcsLogColumnManager getInstance() {
            boolean $i$f$service = false;
            Class<VcsLogColumnManager> serviceClass$iv = VcsLogColumnManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (VcsLogColumnManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

