/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Root;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/openapi/vcs/FilePath;", "()V", "isResizable", "", "()Z", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "getValue", "row", "", "intellij.platform.vcs.log.impl"})
public final class Root
extends VcsLogDefaultColumn<FilePath> {
    private static final boolean isResizable;
    @NotNull
    public static final Root INSTANCE;

    @Override
    public boolean isResizable() {
        return isResizable;
    }

    @Override
    @NotNull
    public FilePath getValue(@NotNull GraphTableModel model, int row2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        FilePath filePath = model.getVisiblePack().getFilePath(row2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"model.visiblePack.getFilePath(row)");
        return filePath;
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        return new RootCellRenderer(table.getProperties(), table.getColorManager());
    }

    @Override
    @NotNull
    public FilePath getStubValue(@NotNull GraphTableModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VcsLogData vcsLogData = model.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"model.logData");
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)ContainerUtil.getFirstItem(vcsLogData.getRoots())));
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(Cont\u2026tem(model.logData.roots))");
        return filePath;
    }

    private Root() {
        super("Default.Root", "", false, null);
    }

    static {
        Root root;
        INSTANCE = root = new Root();
    }
}

