/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.ScrollingTarget;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002J$\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J!\u0010\u001b\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/ui/table/Selection;", "", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "isOnTop", "", "scrollingTarget", "Lcom/intellij/vcs/log/ui/table/ScrollingTarget;", "selectedCommits", "Lgnu/trove/TIntHashSet;", "getTopGap", "", "row", "getVisibleRows", "Lkotlin/ranges/IntRange;", "Ljavax/swing/JTable;", "mapCommitsToRows", "", "graph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "scroll", "commits", "", "restore", "", "permanentGraphChanged", "scrollToRow", "delta", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "intellij.platform.vcs.log.impl"})
public final class Selection {
    private final TIntHashSet selectedCommits;
    private final boolean isOnTop;
    private final ScrollingTarget scrollingTarget;
    private final VcsLogGraphTable table;

    private final int getTopGap(int row2) {
        return this.table.getCellRect((int)row2, (int)0, (boolean)false).y - this.table.getVisibleRect().y;
    }

    private final IntRange getVisibleRows(JTable table) {
        Couple couple = ScrollingUtil.getVisibleRows((JTable)table);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"ScrollingUtil.getVisibleRows(table)");
        Couple visibleRows = couple;
        Object object = visibleRows.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visibleRows.first");
        int n = ((Number)object).intValue();
        Object object2 = visibleRows.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"visibleRows.second");
        IntRange range = new IntRange(n, ((Number)object2).intValue());
        if (range.isEmpty() || range.getFirst() < 0) {
            return null;
        }
        return range;
    }

    public final void restore(@NotNull VisibleGraph<Integer> graph, boolean scroll, boolean permanentGraphChanged) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        boolean scrollToTop = this.isOnTop && permanentGraphChanged;
        Map<Integer, Integer> commitsToRows = this.mapCommitsToRows(graph, scroll && !scrollToTop);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"table.selectionModel");
        listSelectionModel.setValueIsAdjusting(true);
        for (int commit : this.selectedCommits) {
            Integer row2 = commitsToRows.get(commit);
            if (row2 == null) continue;
            this.table.addRowSelectionInterval(row2, row2);
        }
        ListSelectionModel listSelectionModel2 = this.table.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel2, (String)"table.selectionModel");
        listSelectionModel2.setValueIsAdjusting(false);
        if (scroll) {
            Integer scrollingTargetRow;
            if (scrollToTop) {
                this.scrollToRow(0, 0);
            } else if (this.scrollingTarget != null && (scrollingTargetRow = commitsToRows.get(this.scrollingTarget.getCommit())) != null) {
                this.scrollToRow(scrollingTargetRow, this.scrollingTarget.getTopGap());
            }
        }
    }

    private final Map<Integer, Integer> mapCommitsToRows(VisibleGraph<Integer> graph, boolean scroll) {
        boolean bl = false;
        Set commits = new LinkedHashSet();
        TroveUtil.addAll(commits, this.selectedCommits);
        if (scroll && this.scrollingTarget != null) {
            commits.add(this.scrollingTarget.getCommit());
        }
        return this.mapCommitsToRows(commits, graph);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Integer> mapCommitsToRows(Collection<Integer> commits, VisibleGraph<Integer> graph) {
        int n = 0;
        Map commitsToRows = new LinkedHashMap();
        n = 0;
        int n2 = graph.getVisibleCommitCount();
        while (n < n2) {
            void row2;
            RowInfo rowInfo = graph.getRowInfo((int)row2);
            Intrinsics.checkNotNullExpressionValue((Object)rowInfo, (String)"graph.getRowInfo(row)");
            Object object = rowInfo.getCommit();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"graph.getRowInfo(row).commit");
            int commit = ((Number)object).intValue();
            if (commits.remove(commit)) {
                commitsToRows.put(commit, (int)row2);
            }
            if (commits.isEmpty()) break;
            ++row2;
        }
        return commitsToRows;
    }

    private final void scrollToRow(Integer row2, Integer delta) {
        Integer n = row2;
        Intrinsics.checkNotNull((Object)n);
        Rectangle startRect = this.table.getCellRect(n, 0, true);
        int n2 = startRect.x;
        int n3 = startRect.y;
        Integer n4 = delta;
        Intrinsics.checkNotNull((Object)n4);
        int n5 = n3 - n4;
        int n6 = 0;
        boolean bl = false;
        this.table.scrollRectToVisible(new Rectangle(n2, Math.max(n5, n6), startRect.width, this.table.getVisibleRect().height));
    }

    /*
     * WARNING - void declaration
     */
    public Selection(@NotNull VcsLogGraphTable table) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.table = table;
        this.selectedCommits = new TIntHashSet();
        int[] nArray = this.table.getSelectedRows();
        List list = ContainerUtil.sorted((Collection)Ints.asList((int[])Arrays.copyOf(nArray, nArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.sorted(Int\u2026ist(*table.selectedRows))");
        List selectedRows = list;
        Iterable $this$associateWith$iv = selectedRows;
        boolean $i$f$associateWith = false;
        Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            n = (Integer)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = (Map)result$iv;
            boolean bl = false;
            VisibleGraph<Integer> visibleGraph = this.table.getVisibleGraph();
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            RowInfo rowInfo = visibleGraph.getRowInfo(v3.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)rowInfo, (String)"table.visibleGraph.getRowInfo(it)");
            Integer n2 = (Integer)rowInfo.getCommit();
            map2.put(t, n2);
        }
        Map selectedRowsToCommits = (Map)result$iv;
        TroveUtil.addAll(this.selectedCommits, selectedRowsToCommits.values());
        IntRange visibleRows = this.getVisibleRows((JTable)((Object)this.table));
        if (visibleRows == null) {
            this.isOnTop = false;
            this.scrollingTarget = null;
        } else {
            Integer n3;
            block5: {
                this.isOnTop = visibleRows.getFirst() == 0;
                result$iv = selectedRowsToCommits.keySet();
                boolean bl = false;
                Object object = result$iv;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Integer it = n = iterator.next();
                    boolean bl3 = false;
                    Integer n4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"it");
                    if (!visibleRows.contains(n4.intValue())) continue;
                    n3 = n;
                    break block5;
                }
                n3 = null;
            }
            Integer n5 = n3;
            int visibleRow = n5 != null ? n5.intValue() : visibleRows.getFirst();
            Integer n6 = (Integer)selectedRowsToCommits.get(visibleRow);
            if (n6 == null) {
                RowInfo rowInfo = this.table.getVisibleGraph().getRowInfo(visibleRow);
                Intrinsics.checkNotNullExpressionValue((Object)rowInfo, (String)"table.visibleGraph.getRowInfo(visibleRow)");
                n6 = (Integer)rowInfo.getCommit();
            }
            Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"selectedRowsToCommits[vi\u2026owInfo(visibleRow).commit");
            int visibleCommit = n6;
            this.scrollingTarget = new ScrollingTarget(visibleCommit, this.getTopGap(visibleRow));
        }
    }
}

