/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.vcs.log.ui.frame.ProgressStripeIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgressStripe
extends JBPanel {
    private final JComponent myTargetComponent;
    private final Disposable myDisposable;
    private final int myStartDelayMs;
    @NotNull
    private final JBPanel myPanel;
    protected MyLoadingDecorator myDecorator;

    public ProgressStripe(@NotNull JComponent targetComponent, @NotNull Disposable parent, int startDelayMs) {
        if (targetComponent == null) {
            ProgressStripe.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ProgressStripe.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.add((Component)targetComponent);
        this.myTargetComponent = targetComponent;
        this.myDisposable = parent;
        this.myStartDelayMs = startDelayMs;
        this.createLoadingDecorator();
    }

    public void updateUI() {
        super.updateUI();
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            this.createLoadingDecorator();
        }
    }

    private void createLoadingDecorator() {
        if (this.myDecorator != null) {
            this.remove(this.myDecorator.getComponent());
            Disposer.dispose((Disposable)this.myDecorator.getDisposable());
        }
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myDisposable, (Disposable)disposable);
        this.myDecorator = new MyLoadingDecorator(this.myTargetComponent, (JPanel)this.myPanel, disposable, this.myStartDelayMs);
        this.add(this.myDecorator.getComponent(), "Center");
        this.myDecorator.setLoadingText("");
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
    }

    public void startLoadingImmediately() {
        this.myDecorator.startLoadingImmediately();
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/frame/ProgressStripe";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLoadingDecorator
    extends LoadingDecorator {
        @NotNull
        private final Disposable myDisposable;

        MyLoadingDecorator(@NotNull JComponent component, @NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
            if (component == null) {
                MyLoadingDecorator.$$$reportNull$$$0(0);
            }
            if (contentPanel == null) {
                MyLoadingDecorator.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                MyLoadingDecorator.$$$reportNull$$$0(2);
            }
            super((JComponent)contentPanel, disposable, startDelayMs, false, ProgressStripeIcon.generateIcon(component));
            this.myDisposable = disposable;
        }

        public void startLoadingImmediately() {
            this._startLoading(false);
        }

        protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text2, AsyncProcessIcon icon2) {
            parent.setLayout(new BorderLayout());
            NonOpaquePanel result2 = new NonOpaquePanel();
            result2.setLayout((LayoutManager)new BoxLayout((Container)result2, 1));
            result2.add((Component)icon2);
            parent.add((Component)result2, "North");
            return result2;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                MyLoadingDecorator.$$$reportNull$$$0(3);
            }
            return disposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/ProgressStripe$MyLoadingDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/ProgressStripe$MyLoadingDecorator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

