/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilterPopupComponent
extends FilterPopupComponent<FilterPair<VcsLogStructureFilter, VcsLogRootFilter>, VcsLogClassicFilterUi.FileFilterModel> {
    private static final String PATHS = "Paths";
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    private static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    private static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;

    public StructureFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.FileFilterModel filterModel, @NotNull VcsLogColorManager colorManager) {
        if (uiProperties == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (filterModel == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super(VcsLogBundle.messagePointer((String)"vcs.log.filter.popup.paths", (Object[])new Object[0]), filterModel);
        this.myUiProperties = uiProperties;
        this.myColorManager = colorManager;
    }

    private static VcsLogRootFilter getRootFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter2();
    }

    private static VcsLogStructureFilter getStructureFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter1();
    }

    @NotNull
    private Collection<VirtualFile> getFilterRoots(@Nullable VcsLogRootFilter filter) {
        Set<VirtualFile> set = filter != null ? filter.getRoots() : this.getAllRoots();
        if (set == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Collection<FilePath> getFilterFiles(@Nullable VcsLogStructureFilter filter) {
        Collection<Object> collection = filter != null ? filter.getFiles() : Collections.emptySet();
        if (collection == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    @Nls
    protected String getText(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(5);
        }
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter(filter);
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter(filter);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), rootFilter, structureFilter);
        Collection<VirtualFile> roots = this.getFilterRoots(rootFilter);
        Collection<FilePath> files = StructureFilterPopupComponent.getFilterFiles(structureFilter);
        if (files.isEmpty()) {
            return StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
        }
        return this.getTextFromFilePaths(files, VcsLogBundle.message((String)"vcs.log.filter.popup.no.folders", (Object[])new Object[0]), false);
    }

    @NotNull
    @Nls
    private static String getTextFromRoots(@NotNull Collection<? extends VirtualFile> files, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return StructureFilterPopupComponent.getText(files, VcsLogBundle.message((String)"vcs.log.filter.popup.no.roots", (Object[])new Object[0]), FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
    }

    @NotNull
    @Nls
    private String getTextFromFilePaths(@NotNull Collection<? extends FilePath> files, @Nls @NotNull String categoryText, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(7);
        }
        if (categoryText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return StructureFilterPopupComponent.getText(files, categoryText, FILE_PATH_BY_PATH_COMPARATOR, file -> StringUtil.shortenPathWithEllipsis((String)this.path2Text((FilePath)file, true), (int)30), full);
    }

    @NotNull
    @Nls
    private static <F> String getText(@NotNull Collection<? extends F> files, @Nls @NotNull String categoryText, @NotNull Comparator<? super F> comparator, @NotNull NotNullFunction<? super F, @Nls String> getText2, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(9);
        }
        if (categoryText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(10);
        }
        if (comparator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(11);
        }
        if (getText2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(12);
        }
        if (full) {
            String string = (String)ALL.get();
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (files.isEmpty()) {
            String string = categoryText;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(14);
            }
            return string;
        }
        F firstFile = Collections.min(files, comparator);
        String firstFileName = (String)getText2.fun(firstFile);
        if (files.size() == 1) {
            String string = firstFileName;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = firstFileName + " + " + (files.size() - 1);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @Nls
    protected String getToolTip(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(17);
        }
        return this.getToolTip(this.getFilterRoots(StructureFilterPopupComponent.getRootFilter(filter)), StructureFilterPopupComponent.getFilterFiles(StructureFilterPopupComponent.getStructureFilter(filter)));
    }

    @Nls
    @NotNull
    private String getToolTip(@NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends FilePath> files) {
        if (roots == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(18);
        }
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(19);
        }
        HtmlBuilder tooltip = new HtmlBuilder();
        if (roots.isEmpty()) {
            tooltip.append(VcsLogBundle.message((String)"vcs.log.filter.tooltip.no.roots.selected", (Object[])new Object[0]));
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip.append(VcsLogBundle.message((String)"vcs.log.filter.tooltip.roots", (Object[])new Object[0])).br().append(StructureFilterPopupComponent.getTooltipTextForRoots(roots));
        }
        if (!files.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip.br();
            }
            tooltip.append(VcsLogBundle.message((String)"vcs.log.filter.tooltip.folders", (Object[])new Object[0])).br().append(this.getTooltipTextForFilePaths(files, (HtmlChunk)HtmlChunk.br()));
        }
        String string = tooltip.toString();
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    @NlsContexts.Tooltip
    private static HtmlChunk getTooltipTextForRoots(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(21);
        }
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_BY_NAME_COMPARATOR, VirtualFile::getName, (HtmlChunk)HtmlChunk.br());
    }

    @NotNull
    @NlsContexts.Tooltip
    private HtmlChunk getTooltipTextForFilePaths(@NotNull Collection<? extends FilePath> files, @NotNull HtmlChunk separator) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(22);
        }
        if (separator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(23);
        }
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_PATH_BY_PATH_COMPARATOR, filePath -> this.path2Text((FilePath)filePath, true), separator);
    }

    @NotNull
    @NlsContexts.Tooltip
    private static <F> HtmlChunk getTooltipTextForFiles(@NotNull Collection<? extends F> files, @NotNull Comparator<? super F> comparator, @NotNull NotNullFunction<? super F, @Nls String> getText2, @NotNull HtmlChunk separator) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(24);
        }
        if (comparator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(25);
        }
        if (getText2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(26);
        }
        if (separator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(27);
        }
        List filesToDisplay = ContainerUtil.sorted(files, comparator);
        filesToDisplay = ContainerUtil.getFirstItems((List)filesToDisplay, (int)10);
        HtmlBuilder tooltip = new HtmlBuilder().appendWithSeparators(separator, (Iterable)ContainerUtil.map((Collection)filesToDisplay, f -> HtmlChunk.text((String)((String)getText2.fun(f)))));
        if (files.size() > 10) {
            tooltip.append(separator).append("...");
        }
        HtmlChunk htmlChunk = tooltip.toFragment();
        if (htmlChunk == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(28);
        }
        return htmlChunk;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.hasMultiplePaths()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.getRecentFilters()) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new EditPathsAction(), new SelectPathsInTreeAction(), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.recent", (Object[])new Object[0])), new DefaultActionGroup(structureActions), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.roots", (Object[])new Object[0])), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new EditPathsAction(), new SelectPathsInTreeAction(), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.roots", (Object[])new Object[0])), new DefaultActionGroup(rootActions), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.recent", (Object[])new Object[0])), new DefaultActionGroup(structureActions)});
    }

    @NotNull
    private List<VcsLogStructureFilter> getRecentFilters() {
        List<List<String>> filterValues = this.myUiProperties.getRecentlyFilteredGroups(PATHS);
        List list = ContainerUtil.map2List(filterValues, values -> VcsLogClassicFilterUi.FileFilterModel.createStructureFilter(values));
        if (list == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(29);
        }
        return list;
    }

    private Set<VirtualFile> getAllRoots() {
        return ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getRoots();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(30);
        }
        if ((rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getFilter())) != null) {
            return rootFilter.getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(31);
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getFilter());
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoots(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(32);
        }
        ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoot(root)));
    }

    @NotNull
    @NlsActions.ActionText
    private String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(33);
        }
        return this.getTextFromFilePaths(filter.getFiles(), VcsLogBundle.message((String)"vcs.log.filter.popup.no.items", (Object[])new Object[0]), filter.getFiles().isEmpty());
    }

    @NotNull
    @NlsSafe
    private String path2Text(@NotNull FilePath filePath, boolean systemDependent) {
        if (filePath == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(34);
        }
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(this.getAllRoots());
        String path2 = null;
        if (commonAncestor != null && (path2 = FileUtil.getRelativePath((String)commonAncestor.getPath(), (String)filePath.getPath(), (char)'/')) != null && systemDependent) {
            path2 = FileUtil.toSystemDependentName((String)path2);
        }
        if (path2 == null) {
            path2 = systemDependent ? filePath.getPresentableUrl() : filePath.getPath();
        }
        char separator = StructureFilterPopupComponent.separator(systemDependent);
        String string = path2 + (Serializable)(filePath.isDirectory() && !StringUtil.endsWithChar((CharSequence)path2, (char)separator) ? Character.valueOf(separator) : "");
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private FilePath text2Path(@NotNull String path2) {
        if (path2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(36);
        }
        path2 = FileUtil.toSystemIndependentName((String)path2);
        boolean isDirectory = StringUtil.endsWithChar((CharSequence)path2, (char)'/');
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(this.getAllRoots());
        if (commonAncestor != null && !FileUtil.isAbsolute((String)FileUtil.toSystemDependentName((String)path2))) {
            path2 = commonAncestor.getPath() + "/" + (String)path2;
        }
        if (isDirectory) {
            FilePath filePath = VcsUtil.getFilePath((String)path2, (boolean)true);
            if (filePath == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(37);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((String)path2);
        if (filePath == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(38);
        }
        return filePath;
    }

    private static char separator(boolean systemDependent) {
        return systemDependent ? File.separatorChar : (char)'/';
    }

    @NotNull
    private Collection<FilePath> getStructureFilterPaths() {
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getFilter());
        Collection<Object> collection = structureFilter != null ? structureFilter.getFiles() : Collections.emptyList();
        if (collection == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(39);
        }
        return collection;
    }

    private void setStructureFilter(@NotNull VcsLogStructureFilter newFilter) {
        if (newFilter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(40);
        }
        ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(newFilter, null));
        this.myUiProperties.addRecentlyFilteredGroup(PATHS, VcsLogClassicFilterUi.FileFilterModel.getFilterValues(newFilter));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 5: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryText";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTip";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFilters";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "path2Text";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "text2Path";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureFilterPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromFilePaths";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFilePaths";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setVisible";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleOnly";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStructureActionText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "path2Text";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "text2Path";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setStructureFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SelectFromHistoryAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            if (filter == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(0);
            }
            super(StructureFilterPopupComponent.this.getStructureActionText(filter), StructureFilterPopupComponent.this.getTooltipTextForFilePaths(filter.getFiles(), HtmlChunk.text((String)" ")).toString(), null);
            this.myFilter = filter;
            this.myIcon = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(1);
            }
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == this.myFilter;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(2);
            }
            ((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditPathsAction
    extends DumbAwareAction {
        EditPathsAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.edit.folders", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditPathsAction.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            List filesPaths = ContainerUtil.sorted(StructureFilterPopupComponent.this.getStructureFilterPaths(), (Comparator)HierarchicalFilePathComparator.NATURAL);
            String oldValue = StringUtil.join((Collection)ContainerUtil.map((Collection)filesPaths, filePath -> StructureFilterPopupComponent.this.path2Text((FilePath)filePath, false)), (String)"\n");
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, oldValue, new char[]{'\n'});
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.isOk()) {
                        List selectedPaths = ContainerUtil.map(popupBuilder.getSelectedValues(), path2 -> StructureFilterPopupComponent.this.text2Path((String)path2));
                        StructureFilterPopupComponent.this.setStructureFilter(VcsLogFilterObject.fromPaths(selectedPaths));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$EditPathsAction$1", "onClosed"));
                }
            });
            popup.showUnderneathOf((Component)StructureFilterPopupComponent.this);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditPathsAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$EditPathsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectPathsInTreeAction
    extends DumbAwareAction {
        SelectPathsInTreeAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.select.folders", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectPathsInTreeAction.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            Set<VirtualFile> roots = ((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getRoots();
            List files = ContainerUtil.mapNotNull(StructureFilterPopupComponent.this.getStructureFilterPaths(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project, VcsLogBundle.message((String)"vcs.log.select.folder.dialog.title", (Object[])new Object[0]), files, new ArrayList<VirtualFile>(roots));
            if (chooser.showAndGet()) {
                VcsLogStructureFilter newFilter = VcsLogFilterObject.fromVirtualFiles(chooser.getSelectedFiles());
                StructureFilterPopupComponent.this.setStructureFilter(newFilter);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectPathsInTreeAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectPathsInTreeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        CheckboxColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                CheckboxColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, size, size);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        @NotNull
        public CheckboxColorIcon withIconPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withIconPreScaled(preScaled);
            CheckboxColorIcon checkboxColorIcon = (CheckboxColorIcon)super.withIconPreScaled(preScaled);
            if (checkboxColorIcon == null) {
                CheckboxColorIcon.$$$reportNull$$$0(1);
            }
            return checkboxColorIcon;
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIconPreScaled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(0);
            }
            super(null, root.getPresentableUrl(), null);
            this.getTemplatePresentation().setText(root.getName(), false);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUIScale.scaleIcon((JBScalableIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(1);
            }
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(2);
            }
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            String tooltip = VcsLogBundle.message((String)"vcs.log.filter.tooltip.click.to.see.only", (Object[])new Object[]{KeyEvent.getKeyModifiersText(this.getMask()), e.getPresentation().getText()});
            e.getPresentation().putClientProperty("ToolTipText", (Object)tooltip);
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

