/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.editor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import com.intellij.vcs.editor.GsonComplexPathSerializer;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.ui.editor.DefaultVcsLogFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;", "()V", "createVcsLogFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "tabId", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "Lcom/intellij/vcs/log/ui/editor/DefaultVcsLogFile;", "pathId", "findOrCreateFile", "path", "getProtocol", "Companion", "VcsLogComplexPath", "intellij.platform.vcs.log.impl"})
public final class VcsLogVirtualFileSystem
extends ComplexPathVirtualFileSystem<VcsLogComplexPath> {
    private static final String PROTOCOL = "vcs-log";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected VirtualFile findOrCreateFile(@NotNull Project project, @NotNull VcsLogComplexPath path2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return (VirtualFile)this.createVcsLogFile(path2, null);
    }

    @NotNull
    public final VirtualFile createVcsLogFile(@NotNull Project project, @NotNull String tabId, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        String string = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.locationHash");
        String string2 = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
        return (VirtualFile)this.createVcsLogFile(new VcsLogComplexPath(string, string2, tabId), filters);
    }

    private final DefaultVcsLogFile createVcsLogFile(VcsLogComplexPath pathId, VcsLogFilterCollection filters) {
        return new DefaultVcsLogFile(pathId, filters);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VcsLogVirtualFileSystem() {
        super(new GsonComplexPathSerializer(VcsLogComplexPath.class, null, 2, null));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogVirtualFileSystem getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "sessionId", "", "projectHash", "logId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLogId", "()Ljava/lang/String;", "getProjectHash", "getSessionId", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogComplexPath
    implements ComplexPathVirtualFileSystem.ComplexPath {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String projectHash;
        @NotNull
        private final String logId;

        @Override
        @NotNull
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        @NotNull
        public String getProjectHash() {
            return this.projectHash;
        }

        @NotNull
        public final String getLogId() {
            return this.logId;
        }

        public VcsLogComplexPath(@NotNull String sessionId, @NotNull String projectHash, @NotNull String logId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            this.sessionId = sessionId;
            this.projectHash = projectHash;
            this.logId = logId;
        }

        @NotNull
        public final String component1() {
            return this.getSessionId();
        }

        @NotNull
        public final String component2() {
            return this.getProjectHash();
        }

        @NotNull
        public final String component3() {
            return this.logId;
        }

        @NotNull
        public final VcsLogComplexPath copy(@NotNull String sessionId, @NotNull String projectHash, @NotNull String logId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            return new VcsLogComplexPath(sessionId, projectHash, logId);
        }

        public static /* synthetic */ VcsLogComplexPath copy$default(VcsLogComplexPath vcsLogComplexPath, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = vcsLogComplexPath.getSessionId();
            }
            if ((n & 2) != 0) {
                string2 = vcsLogComplexPath.getProjectHash();
            }
            if ((n & 4) != 0) {
                string3 = vcsLogComplexPath.logId;
            }
            return vcsLogComplexPath.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "VcsLogComplexPath(sessionId=" + this.getSessionId() + ", projectHash=" + this.getProjectHash() + ", logId=" + this.logId + ")";
        }

        public int hashCode() {
            String string = this.getSessionId();
            String string2 = this.getProjectHash();
            String string3 = this.logId;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VcsLogComplexPath)) break block3;
                    VcsLogComplexPath vcsLogComplexPath = (VcsLogComplexPath)object;
                    if (!Intrinsics.areEqual((Object)this.getSessionId(), (Object)vcsLogComplexPath.getSessionId()) || !Intrinsics.areEqual((Object)this.getProjectHash(), (Object)vcsLogComplexPath.getProjectHash()) || !Intrinsics.areEqual((Object)this.logId, (Object)vcsLogComplexPath.logId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$Companion;", "", "()V", "PROTOCOL", "", "getInstance", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VcsLogVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<VirtualFileManager> serviceClass$iv = VirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)object).getFileSystem(VcsLogVirtualFileSystem.PROTOCOL);
            if (virtualFileSystem == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem");
            }
            return (VcsLogVirtualFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

