/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsLogUi
implements VcsLogUiEx,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLogImpl myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners;
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(3);
        }
        this.myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @Override
    @NotNull
    public VisiblePackRefresher getRefresher() {
        VisiblePackRefresher visiblePackRefresher = this.myRefresher;
        if (visiblePackRefresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(6);
        }
        return visiblePackRefresher;
    }

    @Override
    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(7);
        }
        return vcsLogColorManager;
    }

    @Override
    @NotNull
    public VcsLog getVcsLog() {
        VcsLogImpl vcsLogImpl = this.myLog;
        if (vcsLogImpl == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(8);
        }
        return vcsLogImpl;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(9);
        }
        return vcsLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(10);
        }
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(11);
        }
        return visiblePack;
    }

    @Override
    public <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<? super Boolean> future2, boolean silently) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(12);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(13);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(14);
        }
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)this.myVisiblePack, commitId);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> this.jumpTo(commitId, rowGetter, future2, silently));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, future2, silently));
        } else {
            if (!silently) {
                this.handleCommitNotFound(commitId, result2 == -2, rowGetter);
            }
            future2.set((Object)false);
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(15);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(16);
        }
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
    }

    @NotNull
    @Nls
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(17);
        }
        String string = exists ? VcsLogBundle.message((String)"vcs.log.commit.does.not.match", (Object[])new Object[]{AbstractVcsLogUi.getCommitPresentation(commitId)}) : VcsLogBundle.message((String)"vcs.log.commit.not.found", (Object[])new Object[]{AbstractVcsLogUi.getCommitPresentation(commitId)});
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(19);
        }
        if (commitId instanceof Hash) {
            String string = ((Hash)commitId).toShortString();
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (commitId instanceof String) {
            String string = VcsLogUtil.getShortHash((String)commitId);
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = commitId.toString();
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(22);
        }
        return string;
    }

    protected void showWarningWithLink(@Nls @NotNull String mainText, @Nls @NotNull String linkText, final @NotNull Runnable onClick) {
        if (mainText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(23);
        }
        if (linkText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(24);
        }
        if (onClick == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(25);
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, mainText, MessageType.WARNING, new NamedRunnable(linkText){

            public void run() {
                onClick.run();
            }
        });
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(27);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (VcsLogListener listener2 : this.myLogListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh2);
        }
    }

    protected void invokeOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(29);
        }
        this.invokeOnChange(runnable, (Condition<? super VcsLogDataPack>)Conditions.alwaysTrue());
    }

    protected void invokeOnChange(@NotNull Runnable runnable, @NotNull Condition<? super VcsLogDataPack> condition) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(30);
        }
        if (condition == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(31);
        }
        VcsLogUtil.invokeOnChange(this, runnable, condition);
    }

    public void dispose() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainText";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefresher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsLog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitNotFoundMessage";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestMore";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommitNotFoundMessage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommitPresentation";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showWarningWithLink";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addLogListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeLogListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fireFilterChangeEvent";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

