/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class VcsLogRepoSizeCollector
extends ProjectUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        DataPack dataPack;
        VcsProjectLog projectLog;
        VcsLogData logData;
        if (project == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(0);
        }
        if ((logData = (projectLog = VcsProjectLog.getInstance(project)).getDataManager()) != null && (dataPack = logData.getDataPack()).isFull()) {
            int commitCount = dataPack.getPermanentGraph().getAllCommits().size();
            int branchesCount = dataPack.getRefsModel().getBranches().size();
            int usersCount = logData.getAllUsers().size();
            HashSet usages = ContainerUtil.newHashSet((Object[])new MetricEvent[]{new MetricEvent("dataInitialized")});
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"commit.count", (int)StatisticsUtil.getNextPowerOfTwo((int)commitCount)));
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"branches.count", (int)StatisticsUtil.getNextPowerOfTwo((int)branchesCount)));
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"users.count", (int)StatisticsUtil.getNextPowerOfTwo((int)usersCount)));
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            for (VcsKey vcs : groupedRoots.keySet()) {
                FeatureUsageData vcsData = new FeatureUsageData().addData("vcs", VcsLogRepoSizeCollector.getVcsKeySafe(vcs));
                int rootCount = groupedRoots.get((Object)vcs).size();
                usages.add(MetricEventFactoryKt.newCounterMetric((String)"root.count", (int)StatisticsUtil.getNextPowerOfTwo((int)rootCount), (FeatureUsageData)vcsData));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static String getVcsKeySafe(@NotNull VcsKey vcs) {
        if (vcs == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(3);
        }
        if (PluginInfoDetectorKt.getPluginInfo(vcs.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey((String)StringUtil.toLowerCase((String)vcs.getName()));
            if (string == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "third.party";
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(5);
        }
        MultiMap result2 = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result2.putValue((Object)vcs, (Object)root);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @NotNull
    public String getGroupId() {
        return "vcs.log.data";
    }

    public int getVersion() {
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsKeySafe";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRootsByVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsKeySafe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "groupRootsByVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

