/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    @NotNull
    private final Disposable myListenersDisposable;
    @NotNull
    private final ExecutorService myExecutor;
    private volatile boolean myDisposeStarted;
    private int myRecreatedLogCount;

    public VcsProjectLog(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(0);
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myListenersDisposable = Disposer.newDisposable();
        this.myDisposeStarted = false;
        this.myRecreatedLogCount = 0;
        this.myProject = project;
        this.myMessageBus = this.myProject.getMessageBus();
        VcsLogProjectTabsProperties uiProperties = (VcsLogProjectTabsProperties)ServiceManager.getService((Project)this.myProject, VcsLogProjectTabsProperties.class);
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, this.myMessageBus, uiProperties, this);
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Vcs Log Initialization/Dispose", (int)1);
        this.myMessageBus.connect(this.myListenersDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VcsProjectLog.this.myProject != project) {
                    return;
                }
                VcsProjectLog.this.myDisposeStarted = true;
                Disposer.dispose((Disposable)VcsProjectLog.this.myListenersDisposable);
                VcsProjectLog.this.disposeLog(false);
                VcsProjectLog.this.myExecutor.shutdown();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    try {
                        VcsProjectLog.this.myExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, VcsLogBundle.message((String)"vcs.log.closing.process", (Object[])new Object[0]), false, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$1", "projectClosing"));
            }
        });
    }

    private void subscribeToMappingsAndPluginsChanges() {
        MessageBusConnection connection = this.myMessageBus.connect(this.myListenersDisposable);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.disposeLog(true));
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new MyDynamicPluginUnloader());
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return (VcsLogUiImpl)logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        VcsLogTabsManager vcsLogTabsManager = this.myTabsManager;
        if (vcsLogTabsManager == null) {
            VcsProjectLog.$$$reportNull$$$0(1);
        }
        return vcsLogTabsManager;
    }

    @RequiresEdt
    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters) {
        return this.openLogTab(filters, VcsLogManager.LogWindowKind.TOOL_WINDOW);
    }

    @RequiresEdt
    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        VcsLogManager logManager;
        if (kind == null) {
            VcsProjectLog.$$$reportNull$$$0(2);
        }
        if ((logManager = this.getLogManager()) == null) {
            return null;
        }
        return this.myTabsManager.openAnotherLogTab(logManager, filters, kind);
    }

    private void disposeLog(boolean recreate) {
        this.myExecutor.execute(() -> {
            VcsLogManager logManager = (VcsLogManager)VcsProjectLog.invokeAndWait(() -> {
                VcsLogManager manager = this.myLogManager.dropValue();
                if (manager != null) {
                    manager.disposeUi();
                }
                return manager;
            });
            if (logManager != null) {
                Disposer.dispose((Disposable)logManager);
            }
            if (recreate) {
                this.createLog(false);
            }
        });
    }

    @RequiresEdt
    private void recreateOnError(@NotNull Throwable t) {
        if (t == null) {
            VcsProjectLog.$$$reportNull$$$0(3);
        }
        if (this.myDisposeStarted) {
            return;
        }
        ++this.myRecreatedLogCount;
        String logMessage = "Recreating Vcs Log after storage corruption. Recreated count " + this.myRecreatedLogCount;
        if (this.myRecreatedLogCount % 5 == 0) {
            LOG.error(logMessage, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                String balloonMessage = VcsLogBundle.message((String)"vcs.log.recreated.due.to.corruption", (Object[])new Object[]{VcsLogUtil.getVcsDisplayName(this.myProject, manager), this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()});
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, balloonMessage, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug(logMessage, t);
        }
        this.disposeLog(true);
    }

    @NotNull
    Future<VcsLogManager> createLogInBackground(boolean forceInit) {
        Future<VcsLogManager> future2 = this.myExecutor.submit(() -> this.createLog(forceInit));
        if (future2 == null) {
            VcsProjectLog.$$$reportNull$$$0(4);
        }
        return future2;
    }

    @Nullable
    @RequiresBackgroundThread
    private VcsLogManager createLog(boolean forceInit) {
        if (this.myDisposeStarted) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> logProviders = VcsProjectLog.getLogProviders(this.myProject);
        if (!logProviders.isEmpty()) {
            VcsLogManager logManager = this.myLogManager.getValue(logProviders);
            VcsProjectLog.initialize(logManager, forceInit);
            return logManager;
        }
        return null;
    }

    @RequiresBackgroundThread
    private static void initialize(@NotNull VcsLogManager logManager, boolean force) {
        VcsLogCachesInvalidator invalidator;
        if (logManager == null) {
            VcsProjectLog.$$$reportNull$$$0(5);
        }
        if (force) {
            logManager.scheduleInitialization();
            return;
        }
        if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (logManager.isLogVisible()) {
                logManager.scheduleInitialization();
            }
        }, VcsProjectLog.getModality());
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> getLogProviders(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(6);
        }
        Map<VirtualFile, VcsLogProvider> map2 = VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()), project);
        if (map2 == null) {
            VcsProjectLog.$$$reportNull$$$0(7);
        }
        return map2;
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(8);
        }
        return (VcsProjectLog)ServiceManager.getService((Project)project, VcsProjectLog.class);
    }

    public void dispose() {
    }

    private static <T> T invokeAndWait(@NotNull Computable<T> computable) {
        if (computable == null) {
            VcsProjectLog.$$$reportNull$$$0(9);
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(computable.compute()), VcsProjectLog.getModality());
        return (T)result2.get();
    }

    @NotNull
    private static ModalityState getModality() {
        ModalityState modalityState = ModalityState.any();
        if (modalityState == null) {
            VcsProjectLog.$$$reportNull$$$0(10);
        }
        return modalityState;
    }

    @RequiresEdt
    public static void runWhenLogIsReady(@NotNull Project project, final @NotNull Consumer<? super VcsLogManager> action) {
        VcsProjectLog log;
        VcsLogManager manager;
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(11);
        }
        if (action == null) {
            VcsProjectLog.$$$reportNull$$$0(12);
        }
        if ((manager = (log = VcsProjectLog.getInstance(project)).getLogManager()) != null) {
            action.consume((Object)manager);
        } else {
            final Future<VcsLogManager> futureLogManager = log.createLogInBackground(true);
            new Task.Backgroundable(project, VcsLogBundle.message((String)"vcs.log.creating.process", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        futureLogManager.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (TimeoutException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onSuccess() {
                    VcsLogManager manager = log.getLogManager();
                    if (manager != null) {
                        action.consume((Object)manager);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/VcsProjectLog$2", "run"));
                }
            }.queue();
        }
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    public static boolean ensureLogCreated(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (VcsProjectLog.getInstance(project).getLogManager() != null) {
            return true;
        }
        try {
            return VcsProjectLog.getInstance(project).createLogInBackground(true).get() != null;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogInBackground";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recreateOnError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLogProviders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runWhenLogIsReady";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureLogCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectLogListener {
        @RequiresEdt
        public void logCreated(@NotNull VcsLogManager var1);

        @RequiresEdt
        public void logDisposed(@NotNull VcsLogManager var1);
    }

    private class MyDynamicPluginUnloader
    implements DynamicPluginListener {
        private final Set<PluginId> affectedPlugins = new HashSet<PluginId>();

        private MyDynamicPluginUnloader() {
        }

        public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(0);
            }
            if (this.hasLogExtensions(pluginDescriptor)) {
                VcsProjectLog.this.disposeLog(true);
            }
        }

        public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(1);
            }
            if (this.hasLogExtensions(pluginDescriptor)) {
                this.affectedPlugins.add(pluginDescriptor.getPluginId());
                LOG.debug("Disposing Vcs Log before unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(false);
            }
        }

        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(2);
            }
            if (this.affectedPlugins.remove(pluginDescriptor.getPluginId())) {
                LOG.debug("Recreating Vcs Log after unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(true);
            }
        }

        private boolean hasLogExtensions(@NotNull IdeaPluginDescriptor descriptor) {
            if (descriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(3);
            }
            for (VcsLogProvider logProvider : (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (logProvider.getClass().getClassLoader() != descriptor.getPluginClassLoader()) continue;
                return true;
            }
            for (CustomVcsLogUiFactoryProvider factory : CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (factory.getClass().getClassLoader() != descriptor.getPluginClassLoader()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$MyDynamicPluginUnloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePluginUnload";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginUnloaded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasLogExtensions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class InitLogStartupActivity
    implements StartupActivity,
    DumbAware {
        public InitLogStartupActivity() {
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                InitLogStartupActivity.$$$reportNull$$$0(0);
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            projectLog.subscribeToMappingsAndPluginsChanges();
            projectLog.createLogInBackground(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity", "runActivity"));
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private volatile VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        @RequiresBackgroundThread
        public VcsLogManager getValue(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
            if (logProviders == null) {
                LazyVcsLogManager.$$$reportNull$$$0(0);
            }
            if (this.myValue == null) {
                VcsLogManager value;
                LOG.debug("Creating Vcs Log for " + VcsLogUtil.getProvidersMapText(logProviders));
                this.myValue = value = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, logProviders, false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError((Throwable)x$0)));
                ApplicationManager.getApplication().invokeAndWait(() -> ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value), VcsProjectLog.getModality());
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(1);
            }
            return vcsLogManager;
        }

        @Nullable
        @RequiresEdt
        public VcsLogManager dropValue() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            if (this.myValue != null) {
                VcsLogManager oldValue = this.myValue;
                this.myValue = null;
                LOG.debug("Disposing Vcs Log for " + VcsLogUtil.getProvidersMapText(oldValue.getDataManager().getLogProviders()));
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(oldValue);
                return oldValue;
            }
            return null;
        }

        @Nullable
        public VcsLogManager getCached() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

