/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabDescriptor;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogContentUtil {
    @Nullable
    public static VcsLogUiEx getLogUi(@NotNull JComponent c) {
        if (c == null) {
            VcsLogContentUtil.$$$reportNull$$$0(0);
        }
        return (VcsLogUiEx)ContainerUtil.getFirstItem(VcsLogContentUtil.getLogUis(c));
    }

    public static List<VcsLogUiEx> getLogUis(@NotNull JComponent c) {
        if (c == null) {
            VcsLogContentUtil.$$$reportNull$$$0(1);
        }
        HashSet<VcsLogPanel> panels = new HashSet<VcsLogPanel>();
        VcsLogContentUtil.collectLogPanelInstances(c, panels);
        return ContainerUtil.map(panels, VcsLogPanel::getUi);
    }

    private static void collectLogPanelInstances(@NotNull JComponent component, @NotNull Set<VcsLogPanel> result2) {
        if (component == null) {
            VcsLogContentUtil.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(3);
        }
        if (component instanceof VcsLogPanel) {
            result2.add((VcsLogPanel)((Object)component));
            return;
        }
        for (Component childComponent : component.getComponents()) {
            if (!(childComponent instanceof JComponent)) continue;
            VcsLogContentUtil.collectLogPanelInstances((JComponent)childComponent, result2);
        }
    }

    @Nullable
    public static <U extends VcsLogUiEx> U findAndSelect(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            VcsLogContentUtil.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            VcsLogContentUtil.$$$reportNull$$$0(6);
        }
        return VcsLogContentUtil.find(project, clazz, true, condition);
    }

    @Nullable
    public static <U extends VcsLogUiEx> U find(@NotNull Project project, @NotNull Class<U> clazz, boolean select, @NotNull Condition<? super U> condition) {
        ToolWindow toolWindow;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            VcsLogContentUtil.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            VcsLogContentUtil.$$$reportNull$$$0(9);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) == null) {
            return null;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return clazz.isInstance(ui2) && condition.value((Object)ui2);
            }
            return false;
        });
        if (component == null) {
            return null;
        }
        if (select) {
            if (!toolWindow.isVisible()) {
                toolWindow.activate(null);
            }
            if (!ContentUtilEx.selectContent((ContentManager)manager, (JComponent)component, (boolean)true)) {
                return null;
            }
        }
        return (U)VcsLogContentUtil.getLogUi(component);
    }

    @Nullable
    public static String getId(@NotNull Content content2) {
        VcsLogUiEx ui2;
        if (content2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(10);
        }
        if ((ui2 = VcsLogContentUtil.getLogUi(content2.getComponent())) == null) {
            return null;
        }
        return ui2.getId();
    }

    @NotNull
    public static Set<String> getExistingLogIds(@NotNull Project project) {
        ContentManager contentManager;
        TabbedContent tabbedContent;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(11);
        }
        Set existingIds = (tabbedContent = ContentUtilEx.findTabbedContent((ContentManager)(contentManager = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control").getContentManager()), (String)"Log")) != null ? ContainerUtil.map2SetNotNull((Collection)tabbedContent.getTabs(), pair -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi((JComponent)pair.second);
            if (ui2 == null) {
                return null;
            }
            return ui2.getId();
        }) : ContainerUtil.map2SetNotNull(Arrays.asList(contentManager.getContents()), content2 -> {
            TabGroupId groupId = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY);
            if (groupId == null || !"Log".equals(groupId.getId())) {
                return null;
            }
            return VcsLogContentUtil.getId(content2);
        });
        Set set = existingIds;
        if (set == null) {
            VcsLogContentUtil.$$$reportNull$$$0(12);
        }
        return set;
    }

    public static <U extends VcsLogUiEx> U openLogTab(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull TabGroupId tabGroupId, @NotNull Function<U, @NlsContexts.TabTitle String> tabDisplayName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory, boolean focus) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(13);
        }
        if (logManager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(14);
        }
        if (tabGroupId == null) {
            VcsLogContentUtil.$$$reportNull$$$0(15);
        }
        if (tabDisplayName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(16);
        }
        if (factory == null) {
            VcsLogContentUtil.$$$reportNull$$$0(17);
        }
        Object logUi = logManager.createLogUi(factory, VcsLogManager.LogWindowKind.TOOL_WINDOW);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        ContentUtilEx.addTabbedContent((ContentManager)toolWindow.getContentManager(), (TabGroupId)tabGroupId, (TabDescriptor)new TabDescriptor((JComponent)((Object)new VcsLogPanel(logManager, (VcsLogUiEx)logUi)), () -> (String)tabDisplayName.apply(logUi), logUi), (boolean)focus);
        if (focus) {
            toolWindow.activate(null);
        }
        return logUi;
    }

    public static boolean closeLogTab(@NotNull ContentManager manager, @NotNull String tabId) {
        if (manager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(18);
        }
        if (tabId == null) {
            VcsLogContentUtil.$$$reportNull$$$0(19);
        }
        return ContentUtilEx.closeContentTab((ContentManager)manager, c -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return ui2.getId().equals(tabId);
            }
            return false;
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openMainLogAndExecute(@NotNull Project project, @NotNull Consumer<? super VcsLogUiImpl> consumer) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            VcsLogContentUtil.$$$reportNull$$$0(21);
        }
        VcsLogContentUtil.runInMainLog(project, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> consumer.consume((Object)((VcsLogUiImpl)ui2))));
    }

    public static void runInMainLog(@NotNull Project project, @NotNull Consumer<? super MainVcsLogUi> consumer) {
        ToolWindow window;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            VcsLogContentUtil.$$$reportNull$$$0(23);
        }
        if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) == null || !VcsLogContentUtil.selectMainLog(window.getContentManager())) {
            VcsLogContentUtil.showLogIsNotAvailableMessage(project);
            return;
        }
        Runnable runConsumer = () -> Objects.requireNonNull(VcsLogContentProvider.getInstance(project)).executeOnMainUiCreated(consumer);
        if (!window.isVisible()) {
            window.activate(runConsumer);
        } else {
            runConsumer.run();
        }
    }

    @RequiresEdt
    public static void showLogIsNotAvailableMessage(@NotNull Project project) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(24);
        }
        VcsBalloonProblemNotifier.showOverChangesView(project, VcsLogBundle.message((String)"vcs.log.is.not.available", (Object[])new Object[0]), MessageType.WARNING, new NamedRunnable[0]);
    }

    public static boolean selectMainLog(@NotNull ContentManager cm) {
        Content[] contents;
        if (cm == null) {
            VcsLogContentUtil.$$$reportNull$$$0(25);
        }
        for (Content content2 : contents = cm.getContents()) {
            if (!"Log".equals(content2.getTabName())) continue;
            cm.setSelectedContent(content2);
            return true;
        }
        return false;
    }

    public static void updateLogUiName(@NotNull Project project, @NotNull VcsLogUi ui2) {
        ToolWindow toolWindow;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(26);
        }
        if (ui2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(27);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) == null) {
            return;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> ui2 == VcsLogContentUtil.getLogUi(c));
        if (component == null) {
            return;
        }
        ContentUtilEx.updateTabbedContentDisplayName((ContentManager)manager, (JComponent)component);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @RequiresBackgroundThread
    @Nullable
    public static VcsLogManager getOrCreateLog(@NotNull Project project) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(28);
        }
        VcsProjectLog.ensureLogCreated(project);
        return VcsProjectLog.getInstance(project).getLogManager();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabGroupId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cm";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingLogIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLogUi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLogUis";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectLogPanelInstances";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelect";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExistingLogIds";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closeLogTab";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "openMainLogAndExecute";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runInMainLog";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showLogIsNotAvailableMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "selectMainLog";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateLogUiName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

