/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J:\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00182\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0!H\u0002JL\u0010#\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0!H\u0002J(\u0010&\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J(\u0010*\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J(\u0010+\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl;", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "()V", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "canShowHistoryInLog", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "correctedPath", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "canShowSingleFileHistory", "path", "isRevisionHistory", "createHashFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "hash", "Lcom/intellij/vcs/log/Hash;", "createPathsFilter", "findOrOpenFolderHistory", "", "hashFilter", "pathsFilter", "consumer", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "findOrOpenHistory", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "getCorrectedPath", "matches", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "showFileHistory", "triggerFileHistoryUsage", "intellij.platform.vcs.log.impl"})
public final class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    private final TabGroupId tabGroupId;

    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled()) {
            return false;
        }
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogData vcsLogData = vcsProjectLog.getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"VcsProjectLog.getInstanc\u2026taManager ?: return false");
        VcsLogData dataManager = vcsLogData;
        if (paths.size() == 1) {
            return this.canShowSingleFileHistory(project, dataManager, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        }
        return revisionNumber == null && this.createPathsFilter(project, dataManager, paths) != null;
    }

    private final boolean canShowSingleFileHistory(Project project, VcsLogData dataManager, FilePath path2, boolean isRevisionHistory) {
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, path2);
        if (virtualFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VcsLogUtil.getActualRoot\u2026ct, path) ?: return false");
        VirtualFile root = virtualFile;
        return dataManager.getIndex().isIndexingEnabled(root) || this.canShowHistoryInLog(dataManager, this.getCorrectedPath(project, path2, root, isRevisionHistory), root);
    }

    public void showFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String string = revisionNumber;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VcsLogUtil.getActualRoot(project, paths.first())!!");
        VirtualFile root = virtualFile;
        this.triggerFileHistoryUsage(project, paths, hash2);
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogManager vcsLogManager = vcsProjectLog.getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogManager, (String)"VcsProjectLog.getInstance(project).logManager!!");
        VcsLogManager logManager = vcsLogManager;
        Function2 historyUiConsumer2 = (Function2)new Function2<VcsLogUiEx, Boolean, Unit>(hash2, logManager, root){
            final /* synthetic */ Hash $hash;
            final /* synthetic */ VcsLogManager $logManager;
            final /* synthetic */ VirtualFile $root;

            public final void invoke(@NotNull VcsLogUiEx ui2, boolean firstTime) {
                Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
                if (this.$hash != null) {
                    VcsLogData vcsLogData = this.$logManager.getDataManager();
                    Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
                    VcsLogStorage vcsLogStorage = vcsLogData.getStorage();
                    Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"logManager.dataManager.storage");
                    VcsLogFileHistoryProviderImplKt.access$jumpToNearestCommit(ui2, vcsLogStorage, this.$hash, this.$root, true);
                } else if (firstTime) {
                    VcsLogUtil.jumpToRow(ui2, 0, true);
                }
            }
            {
                this.$hash = hash;
                this.$logManager = vcsLogManager;
                this.$root = virtualFile;
                super(2);
            }
        };
        if (paths.size() == 1) {
            FilePath correctedPath = this.getCorrectedPath(project, (FilePath)CollectionsKt.single((Iterable)paths), root, revisionNumber != null);
            VcsLogData vcsLogData = logManager.getDataManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
            if (!this.canShowHistoryInLog(vcsLogData, correctedPath, root)) {
                this.findOrOpenHistory(project, logManager, root, correctedPath, hash2, (Function2<? super VcsLogUiEx, ? super Boolean, Unit>)historyUiConsumer2);
                return;
            }
        }
        VcsLogFilter vcsLogFilter = this.createHashFilter(hash2, root);
        VcsLogData vcsLogData = logManager.getDataManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
        VcsLogFilter vcsLogFilter2 = this.createPathsFilter(project, vcsLogData, paths);
        Intrinsics.checkNotNull((Object)vcsLogFilter2);
        this.findOrOpenFolderHistory(project, vcsLogFilter, vcsLogFilter2, (Function2<? super VcsLogUiEx, ? super Boolean, Unit>)historyUiConsumer2);
    }

    private final boolean canShowHistoryInLog(VcsLogData dataManager, FilePath correctedPath, VirtualFile root) {
        if (!correctedPath.isDirectory()) {
            return false;
        }
        VcsLogProvider vcsLogProvider = dataManager.getLogProviders().get(root);
        if (vcsLogProvider == null) {
            return false;
        }
        VcsLogProvider logProvider = vcsLogProvider;
        Object object = VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(logProvider);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VcsLogProperties.SUPPORT\u2026getOrDefault(logProvider)");
        return (Boolean)object;
    }

    private final void triggerFileHistoryUsage(Project project, Collection<? extends FilePath> paths, Hash hash) {
        VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.HISTORY_SHOWN, new Consumer<FeatureUsageData>(paths, hash){
            final /* synthetic */ Collection $paths;
            final /* synthetic */ Hash $hash;

            public final void accept(FeatureUsageData data) {
                String kind = this.$paths.size() > 1 ? "multiple" : (((FilePath)CollectionsKt.first((Iterable)this.$paths)).isDirectory() ? "folder" : "file");
                data.addData("kind", kind).addData("has_revision", this.$hash != null);
            }
            {
                this.$paths = collection;
                this.$hash = hash;
            }
        }, project);
    }

    private final void findOrOpenHistory(Project project, VcsLogManager logManager, VirtualFile root, FilePath path2, Hash hash, Function2<? super VcsLogUiEx, ? super Boolean, Unit> consumer) {
        boolean firstTime;
        FileHistoryUi fileHistoryUi2 = VcsLogContentUtil.findAndSelect(project, FileHistoryUi.class, (Condition)new Condition<FileHistoryUi>(path2, hash){
            final /* synthetic */ FilePath $path;
            final /* synthetic */ Hash $hash;

            public final boolean value(FileHistoryUi ui2) {
                return ui2.matches(this.$path, this.$hash);
            }
            {
                this.$path = filePath;
                this.$hash = hash;
            }
        });
        boolean bl = firstTime = fileHistoryUi2 == null;
        if (firstTime) {
            String suffix = hash != null ? " (" + hash.toShortString() + ")" : "";
            fileHistoryUi2 = (FileHistoryUi)VcsLogContentUtil.openLogTab(project, logManager, this.tabGroupId, (Function)new Function<FileHistoryUi, String>(path2, suffix){
                final /* synthetic */ FilePath $path;
                final /* synthetic */ String $suffix;

                public final String apply(FileHistoryUi it) {
                    return this.$path.getName() + this.$suffix;
                }
                {
                    this.$path = filePath;
                    this.$suffix = string;
                }
            }, new FileHistoryUiFactory(path2, root, hash), true);
        }
        FileHistoryUi fileHistoryUi3 = fileHistoryUi2;
        Intrinsics.checkNotNull((Object)fileHistoryUi3);
        consumer.invoke((Object)fileHistoryUi3, (Object)firstTime);
    }

    private final void findOrOpenFolderHistory(Project project, VcsLogFilter hashFilter, VcsLogFilter pathsFilter, Function2<? super VcsLogUiEx, ? super Boolean, Unit> consumer) {
        boolean firstTime;
        MainVcsLogUi ui2 = VcsLogContentUtil.findAndSelect(project, MainVcsLogUi.class, (Condition)new Condition<MainVcsLogUi>(this, pathsFilter, hashFilter){
            final /* synthetic */ VcsLogFileHistoryProviderImpl this$0;
            final /* synthetic */ VcsLogFilter $pathsFilter;
            final /* synthetic */ VcsLogFilter $hashFilter;

            public final boolean value(MainVcsLogUi logUi) {
                MainVcsLogUi mainVcsLogUi = logUi;
                Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"logUi");
                VcsLogFilterUiEx vcsLogFilterUiEx = mainVcsLogUi.getFilterUi();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterUiEx, (String)"logUi.filterUi");
                VcsLogFilterCollection vcsLogFilterCollection = vcsLogFilterUiEx.getFilters();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"logUi.filterUi.filters");
                return VcsLogFileHistoryProviderImpl.access$matches(this.this$0, vcsLogFilterCollection, this.$pathsFilter, this.$hashFilter);
            }
            {
                this.this$0 = vcsLogFileHistoryProviderImpl;
                this.$pathsFilter = vcsLogFilter;
                this.$hashFilter = vcsLogFilter2;
            }
        });
        boolean bl = firstTime = ui2 == null;
        if (firstTime) {
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(pathsFilter, hashFilter);
            MainVcsLogUi mainVcsLogUi = VcsProjectLog.getInstance(project).openLogTab(filters);
            if (mainVcsLogUi == null) {
                return;
            }
            ui2 = mainVcsLogUi;
            ui2.getProperties().set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, true);
        }
        MainVcsLogUi mainVcsLogUi = ui2;
        Intrinsics.checkNotNull((Object)mainVcsLogUi);
        consumer.invoke((Object)mainVcsLogUi, (Object)firstTime);
    }

    private final VcsLogFilter createPathsFilter(Project project, VcsLogData dataManager, Collection<? extends FilePath> paths) {
        boolean bl = false;
        Set forRootFilter = new LinkedHashSet();
        boolean bl2 = false;
        List forPathsFilter = new ArrayList();
        for (FilePath filePath : paths) {
            VirtualFile root = VcsLogUtil.getActualRoot(project, filePath);
            if (root == null) {
                return null;
            }
            if (!dataManager.getRoots().contains(root) || !((Boolean)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(dataManager.getLogProvider(root))).booleanValue()) {
                return null;
            }
            FilePath correctedPath = this.getCorrectedPath(project, filePath, root, false);
            if (!correctedPath.isDirectory()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root)) {
                forRootFilter.add(root);
            } else {
                forPathsFilter.add(correctedPath);
            }
            Collection collection = forPathsFilter;
            boolean bl3 = false;
            if (!(!collection.isEmpty())) continue;
            collection = forRootFilter;
            bl3 = false;
            if (!(!collection.isEmpty())) continue;
            return null;
        }
        Collection collection = forPathsFilter;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            return (VcsLogFilter)VcsLogFilterObject.fromPaths(forPathsFilter);
        }
        return (VcsLogFilter)VcsLogFilterObject.fromRoots(forRootFilter);
    }

    private final VcsLogFilter createHashFilter(Hash hash, VirtualFile root) {
        if (hash == null) {
            return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
        }
        return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root));
    }

    private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
        VcsLogFilterCollection.FilterKey filterKey = hashFilter.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"hashFilter.key");
        filterKeyArray[0] = filterKey;
        VcsLogFilterCollection.FilterKey filterKey2 = pathsFilter.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)filterKey2, (String)"pathsFilter.key");
        filterKeyArray[1] = filterKey2;
        if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
            return false;
        }
        return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
    }

    private final FilePath getCorrectedPath(Project project, FilePath path2, VirtualFile root, boolean isRevisionHistory) {
        FilePath correctedPath = path2;
        if (Intrinsics.areEqual((Object)root, (Object)VcsUtil.getVcsRootFor((Project)project, (FilePath)correctedPath)) ^ true && correctedPath.isDirectory()) {
            FilePath filePath = VcsUtil.getFilePath((String)correctedPath.getPath(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(correctedPath.path, false)");
            correctedPath = filePath;
        }
        if (!isRevisionHistory) {
            FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)correctedPath);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getLastCommitPath(project, correctedPath)");
            return filePath;
        }
        return correctedPath;
    }

    public VcsLogFileHistoryProviderImpl() {
        Supplier supplier = VcsBundle.messagePointer((String)"file.history.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"VcsBundle.messagePointer(\"file.history.tab.name\")");
        this.tabGroupId = new TabGroupId("History", supplier, false);
    }

    public static final /* synthetic */ boolean access$matches(VcsLogFileHistoryProviderImpl $this, VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        return $this.matches(filters, pathsFilter, hashFilter);
    }
}

