/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogStorageImpl
implements Disposable,
VcsLogStorage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogStorage.class);
    @NotNull
    @NonNls
    private static final String HASHES_STORAGE = "hashes";
    @NotNull
    @NonNls
    private static final String REFS_STORAGE = "refs";
    @NotNull
    @NonNls
    private static final String STORAGE = "storage";
    @NotNull
    public static final VcsLogStorage EMPTY = new EmptyLogStorage();
    public static final int VERSION = 8;
    public static final int NO_INDEX = -1;
    private static final int REFS_VERSION = 2;
    @NotNull
    private final MyPersistentBTreeEnumerator myCommitIdEnumerator;
    @NotNull
    private final PersistentEnumerator<VcsRef> myRefsEnumerator;
    @NotNull
    private final FatalErrorHandler myExceptionReporter;
    private volatile boolean myDisposed;

    public VcsLogStorageImpl(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler exceptionReporter, @NotNull Disposable parent) throws IOException {
        if (project == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(1);
        }
        if (exceptionReporter == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(3);
        }
        this.myDisposed = false;
        this.myExceptionReporter = exceptionReporter;
        List roots = ((StreamEx)StreamEx.ofKeys(logProviders).sortedBy(VirtualFile::getPath)).toList();
        String logId = PersistentUtil.calcLogId(project, logProviders);
        MyCommitIdKeyDescriptor commitIdKeyDescriptor = new MyCommitIdKeyDescriptor(roots);
        StorageId hashesStorageId = new StorageId(project.getName(), HASHES_STORAGE, logId, 8);
        StorageLockContext storageLockContext = new StorageLockContext(true);
        this.myCommitIdEnumerator = (MyPersistentBTreeEnumerator)((Object)IOUtil.openCleanOrResetBroken(() -> new MyPersistentBTreeEnumerator(hashesStorageId, commitIdKeyDescriptor, storageLockContext), (File)hashesStorageId.getStorageFile(STORAGE).toFile()));
        VcsRefKeyDescriptor refsKeyDescriptor = new VcsRefKeyDescriptor(logProviders, commitIdKeyDescriptor);
        StorageId refsStorageId = new StorageId(project.getName(), REFS_STORAGE, logId, 10);
        this.myRefsEnumerator = (PersistentEnumerator)IOUtil.openCleanOrResetBroken(() -> new PersistentEnumerator(refsStorageId.getStorageFile(STORAGE), (KeyDescriptor)refsKeyDescriptor, Page.PAGE_SIZE, storageLockContext, refsStorageId.getVersion()), (File)refsStorageId.getStorageFile(STORAGE).toFile());
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public static Function<Integer, Hash> createHashGetter(@NotNull VcsLogStorage storage) {
        if (storage == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(4);
        }
        Function function = commitIndex -> {
            CommitId commitId = storage.getCommitId((int)commitIndex);
            if (commitId == null) {
                return null;
            }
            return commitId.getHash();
        };
        if (function == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(5);
        }
        return function;
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myCommitIdEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(7);
        }
        return this.myCommitIdEnumerator.enumerate(new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(8);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(9);
        }
        this.checkDisposed();
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        this.checkDisposed();
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                this.myExceptionReporter.consume(this, new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId;
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        if (id == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(10);
        }
        this.checkDisposed();
        try {
            return this.myCommitIdEnumerator.contains(id);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return false;
        }
    }

    @Override
    public void iterateCommits(final @NotNull Predicate<? super CommitId> consumer) {
        if (consumer == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        try {
            this.myCommitIdEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId) {
                    return !consumer.test(commitId);
                }
            });
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
        }
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(12);
        }
        this.checkDisposed();
        try {
            return this.myRefsEnumerator.enumerate((Object)ref);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        this.checkDisposed();
        try {
            return (VcsRef)this.myRefsEnumerator.valueOf(refIndex);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.checkDisposed();
        this.myCommitIdEnumerator.force();
        this.myRefsEnumerator.force();
    }

    public void dispose() {
        try {
            this.myDisposed = true;
            this.myCommitIdEnumerator.close();
            this.myRefsEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = STORAGE;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHashGetter";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrPut";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsCommit";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRefIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyPersistentBTreeEnumerator
    extends PersistentBTreeEnumerator<CommitId> {
        MyPersistentBTreeEnumerator(@NotNull StorageId storageId, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor, @Nullable StorageLockContext storageLockContext) throws IOException {
            if (storageId == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(1);
            }
            super(storageId.getStorageFile(VcsLogStorageImpl.STORAGE), commitIdKeyDescriptor, Page.PAGE_SIZE, storageLockContext, storageId.getVersion());
        }

        public boolean contains(@NotNull CommitId id) throws IOException {
            if (id == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(2);
            }
            return this.tryEnumerate(id) != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyPersistentBTreeEnumerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VcsRefKeyDescriptor
    implements KeyDescriptor<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myLogProviders;
        @NotNull
        private final KeyDescriptor<CommitId> myCommitIdKeyDescriptor;

        VcsRefKeyDescriptor(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor) {
            if (logProviders == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(1);
            }
            this.myLogProviders = logProviders;
            this.myCommitIdKeyDescriptor = commitIdKeyDescriptor;
        }

        public int getHashCode(@NotNull VcsRef value) {
            if (value == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(2);
            }
            return value.hashCode();
        }

        public boolean isEqual(@NotNull VcsRef val1, @NotNull VcsRef val2) {
            if (val1 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(3);
            }
            if (val2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(4);
            }
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, @NotNull VcsRef value) throws IOException {
            if (out == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(5);
            }
            if (value == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(6);
            }
            this.myCommitIdKeyDescriptor.save(out, (Object)new CommitId(value.getCommitHash(), value.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
            this.myLogProviders.get(value.getRoot()).getReferenceManager().serialize(out, value.getType());
        }

        public VcsRef read(@NotNull DataInput in) throws IOException {
            CommitId commitId;
            if (in == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(7);
            }
            if ((commitId = (CommitId)this.myCommitIdKeyDescriptor.read(in)) == null) {
                throw new IOException("Can not read commit id for reference");
            }
            String name = IOUtil.readUTF((DataInput)in);
            VcsRefType type = this.myLogProviders.get(commitId.getRoot()).getReferenceManager().deserialize(in);
            return new VcsRefImpl(commitId.getHash(), name, type, commitId.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEqual";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EmptyLogStorage
    implements VcsLogStorage {
        private EmptyLogStorage() {
        }

        @Override
        public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
            if (hash == null) {
                EmptyLogStorage.$$$reportNull$$$0(0);
            }
            if (root == null) {
                EmptyLogStorage.$$$reportNull$$$0(1);
            }
            return 0;
        }

        @Override
        @NotNull
        public CommitId getCommitId(int commitIndex) {
            throw new UnsupportedOperationException("Illegal access to empty hash map by index " + commitIndex);
        }

        @Override
        public boolean containsCommit(@NotNull CommitId id) {
            if (id == null) {
                EmptyLogStorage.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        public void iterateCommits(@NotNull Predicate<? super CommitId> consumer) {
            if (consumer == null) {
                EmptyLogStorage.$$$reportNull$$$0(3);
            }
        }

        @Override
        public int getRefIndex(@NotNull VcsRef ref) {
            if (ref == null) {
                EmptyLogStorage.$$$reportNull$$$0(4);
            }
            return 0;
        }

        @Override
        @Nullable
        public VcsRef getVcsRef(int refIndex) {
            throw new UnsupportedOperationException("Illegal access to empty ref map by index " + refIndex);
        }

        @Override
        public void flush() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCommitIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsCommit";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterateCommits";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRefIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final List<? extends VirtualFile> myRoots;
        @NotNull
        private final TObjectIntHashMap<VirtualFile> myRootsReversed;

        MyCommitIdKeyDescriptor(@NotNull List<? extends VirtualFile> roots) {
            if (roots == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = roots;
            this.myRootsReversed = new TObjectIntHashMap();
            for (int i = 0; i < roots.size(); ++i) {
                this.myRootsReversed.put((Object)roots.get(i), i);
            }
        }

        public void save(@NotNull DataOutput out, CommitId value) throws IOException {
            if (out == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(1);
            }
            ((HashImpl)value.getHash()).write(out);
            out.writeInt(this.myRootsReversed.get((Object)value.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(2);
            }
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRoots.get(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value) {
            return value.hashCode();
        }

        public boolean isEqual(CommitId val1, CommitId val2) {
            return val1.equals((Object)val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

