/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import gnu.trove.TIntHashSet;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final Cache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;
    @NotNull
    protected final VcsLogIndex myIndex;

    AbstractDataGetter(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        if (storage == null) {
            AbstractDataGetter.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            AbstractDataGetter.$$$reportNull$$$0(1);
        }
        if (index == null) {
            AbstractDataGetter.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            AbstractDataGetter.$$$reportNull$$$0(3);
        }
        this.myCache = Caffeine.newBuilder().maximumSize(10000L).build();
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myStorage = storage;
        this.myLogProviders = logProviders;
        this.myIndex = index;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor(this, 10, task2 -> {
            this.preLoadCommitData(task2.myCommits, EmptyConsumer.getInstance());
            this.notifyLoaded();
        });
    }

    protected void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            for (Runnable loadingFinishedListener : this.myLoadingFinishedListeners) {
                loadingFinishedListener.run();
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(int hash, @NotNull Iterable<Integer> neighbourHashes) {
        if (neighbourHashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(4);
        }
        assert (EventQueue.isDispatchThread());
        T details = this.getCommitDataIfAvailable(hash);
        if (details != null) {
            T t = details;
            if (t == null) {
                AbstractDataGetter.$$$reportNull$$$0(5);
            }
            return t;
        }
        this.runLoadCommitsData(neighbourHashes);
        T result2 = this.getFromCache(hash);
        assert (result2 != null);
        T t = result2;
        if (t == null) {
            AbstractDataGetter.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> hashes, @NotNull Consumer<? super List<T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(8);
        }
        if (errorConsumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(9);
        }
        assert (EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsMap(hashes), consumer, errorConsumer, indicator);
    }

    private void loadCommitsData(final @NotNull Int2IntMap commits, final @NotNull Consumer<? super List<T>> consumer, final @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(11);
        }
        if (errorConsumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(12);
        }
        final ArrayList<T> result2 = new ArrayList<T>();
        final TIntHashSet toLoad = new TIntHashSet();
        long taskNumber = this.myCurrentTaskIndex++;
        IntIterator keyIterator = commits.keySet().iterator();
        while (keyIterator.hasNext()) {
            int id = keyIterator.nextInt();
            T details = this.getCommitDataIfAvailable(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                this.cacheCommit(id, taskNumber);
                continue;
            }
            result2.add(details);
        }
        if (toLoad.isEmpty()) {
            --this.myCurrentTaskIndex;
            Runnable process = () -> {
                this.sortCommitsByRow(result2, commits);
                consumer.consume((Object)result2);
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcess(process, indicator);
            } else {
                process.run();
            }
        } else {
            Task.Backgroundable task2 = new Task.Backgroundable(null, VcsLogBundle.message((String)"vcs.log.loading.selected.details.process", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.checkCanceled();
                    try {
                        AbstractDataGetter.this.preLoadCommitData(toLoad, new CollectConsumer((Collection)result2));
                        AbstractDataGetter.this.sortCommitsByRow(result2, commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    consumer.consume((Object)result2);
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errorConsumer.consume((Object)error);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/vcs/log/data/AbstractDataGetter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<? extends T> result2, @NotNull Int2IntMap rowsForCommits) {
        if (result2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(13);
        }
        if (rowsForCommits == null) {
            AbstractDataGetter.$$$reportNull$$$0(14);
        }
        result2.sort((details1, details2) -> {
            int row1 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details1.getId(), details1.getRoot()));
            int row2 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details2.getId(), details2.getRoot()));
            return Comparing.compare((int)row1, (int)row2);
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        T details = this.getFromCache(hash);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.asMap().remove(hash, details);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(hash);
    }

    @Nullable
    protected T getFromCache(int hash) {
        return (T)((VcsShortCommitDetails)this.myCache.getIfPresent((Object)hash));
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(15);
        }
        long taskNumber = this.myCurrentTaskIndex++;
        Int2IntMap commits = AbstractDataGetter.getCommitsMap(hashes);
        TIntHashSet toLoad = new TIntHashSet();
        IntIterator iterator = commits.keySet().iterator();
        while (iterator.hasNext()) {
            int id = iterator.nextInt();
            this.cacheCommit(id, taskNumber);
            toLoad.add(id);
        }
        this.myLoader.queue(new TaskDescriptor(toLoad));
    }

    private void cacheCommit(int commitId, long taskNumber) {
        if (this.getFromCache(commitId) == null) {
            IndexDataGetter dataGetter = this.myIndex.getDataGetter();
            if (dataGetter != null && Registry.is((String)"vcs.log.use.indexed.details")) {
                this.myCache.put((Object)commitId, (Object)new IndexedDetails(dataGetter, this.myStorage, commitId, taskNumber));
            } else {
                this.myCache.put((Object)commitId, (Object)new LoadingDetails((Computable<? extends CommitId>)((Computable)() -> this.myStorage.getCommitId(commitId)), taskNumber));
            }
        }
    }

    @NotNull
    private static Int2IntMap getCommitsMap(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(16);
        }
        Int2IntOpenHashMap commits = new Int2IntOpenHashMap();
        int row2 = 0;
        for (Integer commitId : hashes) {
            commits.put(commitId.intValue(), row2);
            ++row2;
        }
        Int2IntOpenHashMap int2IntOpenHashMap = commits;
        if (int2IntOpenHashMap == null) {
            AbstractDataGetter.$$$reportNull$$$0(17);
        }
        return int2IntOpenHashMap;
    }

    protected void preLoadCommitData(@NotNull TIntHashSet commits, @NotNull Consumer<? super T> consumer) throws VcsException {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(19);
        }
        MultiMap rootsAndHashes = MultiMap.create();
        commits.forEach(commit -> {
            CommitId commitId = this.myStorage.getCommitId(commit);
            if (commitId != null) {
                rootsAndHashes.putValue((Object)commitId.getRoot(), (Object)commitId.getHash().asString());
            }
            return true;
        });
        for (Map.Entry entry : rootsAndHashes.entrySet()) {
            VcsLogProvider logProvider = this.myLogProviders.get(entry.getKey());
            if (logProvider != null) {
                this.readDetails(logProvider, (VirtualFile)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), details -> {
                    this.saveInCache(this.myStorage.getCommitIndex((Hash)details.getId(), details.getRoot()), details);
                    consumer.consume(details);
                });
                continue;
            }
            LOG.error("No log provider for root " + ((VirtualFile)entry.getKey()).getPath() + ". All known log providers " + this.myLogProviders);
        }
    }

    protected abstract void readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3, @NotNull Consumer<? super T> var4) throws VcsException;

    protected void saveInCache(int index, @NotNull T details) {
        if (details == null) {
            AbstractDataGetter.$$$reportNull$$$0(20);
        }
        this.myCache.put((Object)index, details);
    }

    protected void clear() {
        EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
            Iterator iterator = this.myCache.asMap().entrySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getValue() instanceof LoadingDetails) continue;
                iterator.remove();
            }
        });
    }

    public void addDetailsLoadedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractDataGetter.$$$reportNull$$$0(21);
        }
        this.myLoadingFinishedListeners.add(runnable);
    }

    public void removeDetailsLoadedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractDataGetter.$$$reportNull$$$0(22);
        }
        this.myLoadingFinishedListeners.remove(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neighbourHashes";
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsForCommits";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommitData";
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitsData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortCommitsByRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runLoadCommitsData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preLoadCommitData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveInCache";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDetailsLoadedListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeDetailsLoadedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TaskDescriptor {
        @NotNull
        private final TIntHashSet myCommits;

        private TaskDescriptor(@NotNull TIntHashSet commits) {
            if (commits == null) {
                TaskDescriptor.$$$reportNull$$$0(0);
            }
            this.myCommits = commits;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter$TaskDescriptor", "<init>"));
        }
    }
}

