/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.editor;

import com.google.gson.Gson;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/editor/GsonComplexPathSerializer;", "P", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "pathClass", "Ljava/lang/Class;", "gson", "Lcom/google/gson/Gson;", "(Ljava/lang/Class;Lcom/google/gson/Gson;)V", "deserialize", "rawPath", "", "(Ljava/lang/String;)Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "serialize", "path", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Ljava/lang/String;", "intellij.platform.vcs.impl"})
public final class GsonComplexPathSerializer<P extends ComplexPathVirtualFileSystem.ComplexPath>
implements ComplexPathVirtualFileSystem.ComplexPathSerializer<P> {
    private final Class<P> pathClass;
    private final Gson gson;

    @Override
    @NotNull
    public String serialize(@NotNull P path2) {
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        String string = this.gson.toJson(path2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(path)");
        return string;
    }

    @Override
    @NotNull
    public P deserialize(@NotNull String rawPath) {
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        Object object = this.gson.fromJson(rawPath, this.pathClass);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(rawPath, pathClass)");
        return (P)((ComplexPathVirtualFileSystem.ComplexPath)object);
    }

    public GsonComplexPathSerializer(@NotNull Class<P> pathClass, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter(pathClass, (String)"pathClass");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.pathClass = pathClass;
        this.gson = gson;
    }

    public /* synthetic */ GsonComplexPathSerializer(Class clazz, Gson gson, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            gson = new Gson();
        }
        this(clazz, gson);
    }
}

