/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.ui.GuiUtils;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import com.intellij.vcs.commit.message.CommitMessageInspectionDetailsPanel;
import java.awt.Component;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CommitMessageInspectionDetails
implements UnnamedConfigurable,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final InspectionProfileImpl myProfile;
    @NotNull
    private final Descriptor myDefaultDescriptor;
    @NotNull
    private final ScopeToolState myToolState;
    private final LevelChooserAction mySeverityChooser;
    private final ConfigurableUi<Project> myOptionsConfigurable;
    private final CommitMessageInspectionDetailsPanel myMainPanel;
    @NotNull
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CommitMessageInspectionDetails(@NotNull Project project, @NotNull InspectionProfileImpl profile, @NotNull Descriptor defaultDescriptor) {
        if (project == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(1);
        }
        if (defaultDescriptor == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project;
        this.myProfile = profile;
        this.myDefaultDescriptor = defaultDescriptor;
        this.myToolState = this.myDefaultDescriptor.getState();
        this.mySeverityChooser = new MySeverityChooser(this.myProfile.getProfileManager().getSeverityRegistrar());
        JComponent severityPanel = this.mySeverityChooser.createCustomComponent(this.mySeverityChooser.getTemplatePresentation(), "unknown");
        BaseCommitMessageInspection tool = (BaseCommitMessageInspection)((Object)ObjectUtils.tryCast((Object)this.myToolState.getTool().getTool(), BaseCommitMessageInspection.class));
        this.myOptionsConfigurable = tool != null ? tool.createOptionsConfigurable() : null;
        JComponent options = this.myOptionsConfigurable != null ? this.myOptionsConfigurable.getComponent() : this.myToolState.getAdditionalConfigPanel();
        this.myMainPanel = new CommitMessageInspectionDetailsPanel(severityPanel, options);
        this.reset();
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = this.myDefaultDescriptor.getKey();
        if (highlightDisplayKey == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(3);
        }
        return highlightDisplayKey;
    }

    public void update() {
        this.mySeverityChooser.setChosen(ScopesAndSeveritiesTable.getSeverity(Collections.singletonList(this.myToolState)));
        GuiUtils.enableChildren((boolean)this.myToolState.isEnabled(), (Component[])new Component[]{this.myMainPanel.getComponent()});
    }

    public void addListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(4);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.myMainPanel.getComponent();
        if (jComponent == null) {
            CommitMessageInspectionDetails.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public boolean isModified() {
        return this.myOptionsConfigurable != null && this.myOptionsConfigurable.isModified((Object)this.myProject);
    }

    public void apply() throws ConfigurationException {
        if (this.myOptionsConfigurable != null) {
            this.myOptionsConfigurable.apply((Object)this.myProject);
        }
    }

    public void reset() {
        if (this.myOptionsConfigurable != null) {
            this.myOptionsConfigurable.reset((Object)this.myProject);
        }
    }

    public void dispose() {
        if (this.myOptionsConfigurable instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myOptionsConfigurable));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDescriptor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/message/CommitMessageInspectionDetails";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/message/CommitMessageInspectionDetails";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeListener
    extends EventListener {
        public void onSeverityChanged(@NotNull HighlightSeverity var1);
    }

    private class MySeverityChooser
    extends LevelChooserAction {
        MySeverityChooser(SeverityRegistrar registrar) {
            if (registrar == null) {
                MySeverityChooser.$$$reportNull$$$0(0);
            }
            super(registrar);
        }

        protected void onChosen(@NotNull HighlightSeverity severity) {
            if (severity == null) {
                MySeverityChooser.$$$reportNull$$$0(1);
            }
            HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            CommitMessageInspectionDetails.this.myProfile.setErrorLevel(CommitMessageInspectionDetails.this.myDefaultDescriptor.getKey(), level, null, CommitMessageInspectionDetails.this.myProject);
            ((ChangeListener)CommitMessageInspectionDetails.this.myEventDispatcher.getMulticaster()).onSeverityChanged(severity);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                MySeverityChooser.$$$reportNull$$$0(2);
            }
            if (place == null) {
                MySeverityChooser.$$$reportNull$$$0(3);
            }
            ComboBoxAction.ComboBoxButton comboBoxButton = this.createComboBoxButton(presentation);
            if (comboBoxButton == null) {
                MySeverityChooser.$$$reportNull$$$0(4);
            }
            return comboBoxButton;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/message/CommitMessageInspectionDetails$MySeverityChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/message/CommitMessageInspectionDetails$MySeverityChooser";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onChosen";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

