/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.util.Function;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0003J\r\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "committer", "Lcom/intellij/vcs/commit/AbstractCommitter;", "(Lcom/intellij/vcs/commit/AbstractCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "getCommitSummary", "", "getFileSummaryReport", "Lorg/jetbrains/annotations/Nls;", "onCancel", "", "onFailure", "errors", "", "Lcom/intellij/openapi/vcs/VcsException;", "onSuccess", "commitMessage", "reportResult", "intellij.platform.vcs.impl"})
public final class ShowNotificationCommitResultHandler
implements CommitResultHandler {
    private final VcsNotifier notifier;
    private final AbstractCommitter committer;

    public void onSuccess(@NotNull String commitMessage2) {
        Intrinsics.checkNotNullParameter((Object)commitMessage2, (String)"commitMessage");
        this.reportResult();
    }

    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message((String)"vcs.commit.canceled", (Object[])new Object[0]));
    }

    public void onFailure(@NotNull List<? extends VcsException> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        this.reportResult();
    }

    private final void reportResult() {
        List<VcsException> allExceptions = this.committer.getExceptions();
        List<VcsException> errors = AbstractCommitter.Companion.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        String message = this.getCommitSummary();
        if (errorsSize > 0) {
            String string = VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[]{errorsSize});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"message.text.co\u2026.with.error\", errorsSize)");
            String title2 = string;
            this.notifier.notifyError("vcs.commit.failed", title2, message);
        } else if (warningsSize > 0) {
            String string = VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[]{warningsSize});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"message.text.co\u2026h.warning\", warningsSize)");
            String title3 = string;
            this.notifier.notifyImportantWarning("vcs.commit.finished.with.warnings", title3, message);
        } else {
            this.notifier.notifySuccess("vcs.commit.finished", "", message);
        }
    }

    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions;
        StringBuilder stringBuilder = new StringBuilder(this.getFileSummaryReport());
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        String commitMessage2 = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage2)) {
            $this$apply.append(": ").append(ShowNotificationCommitResultHandlerKt.access$escape(commitMessage2));
        }
        Set<String> feedback = this.committer.getFeedback();
        Collection collection = feedback;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            $this$apply.append("<br/>");
            $this$apply.append(StringUtil.join((Collection)feedback, (String)"<br/>"));
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            $this$apply.append("<br/>");
            $this$apply.append(StringUtil.join((Collection)exceptions, (Function)getCommitSummary.1.1.INSTANCE, (String)"<br/>"));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(getFileSum\u2026BR))\n    }\n  }.toString()");
        return string;
    }

    private final String getFileSummaryReport() {
        int failed = this.committer.getFailedToCommitChanges().size();
        int committed = this.committer.getChanges().size() - failed;
        if (failed > 0) {
            String string = VcsBundle.message((String)"vcs.commit.files.committed.and.files.failed.to.commit", (Object[])new Object[]{committed, failed});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"vcs.commit.file\u2026mmit\", committed, failed)");
            return string;
        }
        String string = VcsBundle.message((String)"vcs.commit.files.committed", (Object[])new Object[]{committed});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"vcs.commit.files.committed\", committed)");
        return string;
    }

    public ShowNotificationCommitResultHandler(@NotNull AbstractCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        this.notifier = VcsNotifier.getInstance(this.committer.getProject());
    }
}

