/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.browser.LoadingChangesPanel;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithLocalDialog {
    public static void showDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, final @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(0);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(1);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(2);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(3);
        }
        Disposable loadingDisposable = Disposer.newDisposable();
        MyChangesBrowser changesBrowser2 = new MyChangesBrowser(project, localContent);
        MyLoadingChangesPanel changesPanel = new MyLoadingChangesPanel(changesBrowser2, loadingDisposable){

            @Override
            @NotNull
            protected Collection<Change> loadChanges() throws VcsException {
                Collection collection = (Collection)changesLoader.compute();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/CompareWithLocalDialog$1", "loadChanges"));
            }
        };
        changesPanel.reloadChanges();
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(dialogTitle);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        dialogBuilder.setCenterPanel((JComponent)changesPanel);
        dialogBuilder.setPreferredFocusComponent(changesPanel.getChangesBrowser().getPreferredFocusedComponent());
        dialogBuilder.addDisposable(loadingDisposable);
        dialogBuilder.setDimensionServiceKey("Git.DiffForPathsDialog");
        dialogBuilder.showNotModal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dialogTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "localContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "changesLoader";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/CompareWithLocalDialog";
        objectArray[2] = "showDialog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum LocalContent {
        BEFORE,
        AFTER,
        NONE;

    }

    private static class MyGetVersionAction
    extends DumbAwareAction {
        private MyGetVersionAction() {
            super(VcsBundle.messagePointer((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Download);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGetVersionAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getData(MyLoadingChangesPanel.DATA_KEY);
            if (project == null || changesPanel == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            MyChangesBrowser browser2 = (MyChangesBrowser)ObjectUtils.tryCast((Object)changesPanel.getChangesBrowser(), MyChangesBrowser.class);
            boolean isVisible2 = browser2 != null && browser2.myLocalContent != LocalContent.NONE;
            boolean isEnabled = isVisible2 && !browser2.getSelectedChanges().isEmpty();
            e.getPresentation().setVisible(isVisible2);
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGetVersionAction.$$$reportNull$$$0(1);
            }
            Project project = Objects.requireNonNull(e.getProject());
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getRequiredData(MyLoadingChangesPanel.DATA_KEY);
            MyChangesBrowser browser2 = (MyChangesBrowser)changesPanel.getChangesBrowser();
            List fileContentProviders = ContainerUtil.map(changesPanel.getChangesBrowser().getSelectedChanges(), change -> new MyFileContentProvider((Change)change, browser2.myLocalContent));
            GetVersionAction.doGet(project, VcsBundle.message((String)"compare.with.dialog.get.from.vcs.action.title", (Object[])new Object[0]), fileContentProviders, () -> changesPanel.reloadChanges());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyFileContentProvider
        implements GetVersionAction.FileRevisionProvider {
            @NotNull
            private final Change myChange;
            @NotNull
            private final LocalContent myLocalContent;

            private MyFileContentProvider(@NotNull Change change, @NotNull LocalContent localContent) {
                if (change == null) {
                    MyFileContentProvider.$$$reportNull$$$0(0);
                }
                if (localContent == null) {
                    MyFileContentProvider.$$$reportNull$$$0(1);
                }
                this.myChange = change;
                this.myLocalContent = localContent;
            }

            @Override
            @NotNull
            public FilePath getFilePath() {
                FilePath filePath = ChangesUtil.getFilePath((Change)this.myChange);
                if (filePath == null) {
                    MyFileContentProvider.$$$reportNull$$$0(2);
                }
                return filePath;
            }

            @Override
            public byte @Nullable [] getContent() throws VcsException {
                ContentRevision revision;
                ContentRevision contentRevision = revision = this.myLocalContent == LocalContent.AFTER ? this.myChange.getBeforeRevision() : this.myChange.getAfterRevision();
                if (revision == null) {
                    return null;
                }
                return ChangesUtil.loadContentRevision((ContentRevision)revision);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localContent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction$MyFileContentProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction$MyFileContentProvider";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class MyChangesBrowser
    extends SimpleChangesBrowser {
        @NotNull
        private final LocalContent myLocalContent;

        private MyChangesBrowser(@NotNull Project project, @NotNull LocalContent localContent) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (localContent == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.myLocalContent = localContent;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List list = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyGetVersionAction()});
            if (list == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyGetVersionAction()});
            if (list == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localContent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MyLoadingChangesPanel
    extends JPanel
    implements DataProvider {
        public static final DataKey<MyLoadingChangesPanel> DATA_KEY = DataKey.create((String)"git4idea.log.MyLoadingChangesPanel");
        private final SimpleChangesBrowser myChangesBrowser;
        private final LoadingChangesPanel myLoadingPanel;

        private MyLoadingChangesPanel(@NotNull SimpleChangesBrowser changesBrowser2, @NotNull Disposable disposable) {
            if (changesBrowser2 == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myChangesBrowser = changesBrowser2;
            StatusText emptyText = this.myChangesBrowser.getViewer().getEmptyText();
            this.myLoadingPanel = new LoadingChangesPanel(this.myChangesBrowser, emptyText, disposable);
            this.add((Component)this.myLoadingPanel, "Center");
        }

        @NotNull
        public SimpleChangesBrowser getChangesBrowser() {
            SimpleChangesBrowser simpleChangesBrowser = this.myChangesBrowser;
            if (simpleChangesBrowser == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(2);
            }
            return simpleChangesBrowser;
        }

        public void reloadChanges() {
            this.myLoadingPanel.loadChangesInBackground(this::loadChanges, this::applyResult);
        }

        @NotNull
        protected abstract Collection<Change> loadChanges() throws VcsException;

        private void applyResult(@Nullable Collection<Change> changes) {
            this.myChangesBrowser.setChangesToDisplay(changes != null ? changes : Collections.emptyList());
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(3);
            }
            if (DATA_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesBrowser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

