/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.cloneDialog;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem;", "()V", "accountRenderer", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer$AccountItemRenderer;", "actionRenderer", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer$ActionItemRenderer;", "emptyMenuRightArrowIcon", "Lcom/intellij/util/ui/EmptyIcon;", "Lorg/jetbrains/annotations/NotNull;", "innerInset", "", "leftInset", "listSelectionBackground", "Ljava/awt/Color;", "separatorBorder", "Ljavax/swing/border/Border;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "selected", "", "focused", "AccountItemRenderer", "ActionItemRenderer", "intellij.platform.vcs.impl"})
public final class AccountMenuItemRenderer
implements ListCellRenderer<AccountMenuItem> {
    private final int leftInset;
    private final int innerInset;
    private final EmptyIcon emptyMenuRightArrowIcon;
    private final Border separatorBorder;
    private final Color listSelectionBackground;
    private final AccountItemRenderer accountRenderer;
    private final ActionItemRenderer actionRenderer;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@Nullable JList<? extends AccountMenuItem> list, @NotNull AccountMenuItem value, int index, boolean selected, boolean focused) {
        Color color;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AccountMenuItem accountMenuItem = value;
        if (accountMenuItem instanceof AccountMenuItem.Account) {
            jComponent = this.accountRenderer.getListCellRendererComponent((JList<? extends AccountMenuItem.Account>)null, (AccountMenuItem.Account)value, index, selected, focused);
        } else if (accountMenuItem instanceof AccountMenuItem.Action) {
            jComponent = this.actionRenderer.getListCellRendererComponent((JList<? extends AccountMenuItem.Action>)null, (AccountMenuItem.Action)value, index, selected, focused);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JComponent renderer = jComponent;
        Component component = renderer;
        if (selected) {
            color = this.listSelectionBackground;
        } else {
            Color color2 = UIUtil.getPanelBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getPanelBackground()");
        }
        UIUtil.setBackgroundRecursively((Component)component, (Color)color);
        renderer.setBorder(value.getShowSeparatorAbove() ? this.separatorBorder : null);
        return renderer;
    }

    public AccountMenuItemRenderer() {
        this.leftInset = 12;
        this.innerInset = 8;
        EmptyIcon emptyIcon = EmptyIcon.create((Icon)AllIcons.General.ArrowRight);
        Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(AllIcons.General.ArrowRight)");
        this.emptyMenuRightArrowIcon = emptyIcon;
        Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Popup.separatorColor(), (int)1, (int)0, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"JBUI.Borders.customLine(\u2026ratorColor(), 1, 0, 0, 0)");
        this.separatorBorder = border;
        Color color = UIUtil.getListSelectionBackground((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"UIUtil.getListSelectionBackground(true)");
        this.listSelectionBackground = color;
        this.accountRenderer = new AccountItemRenderer();
        this.actionRenderer = new ActionItemRenderer();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer$AccountItemRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Account;", "(Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer;)V", "avatarLabel", "Ljavax/swing/JLabel;", "getAvatarLabel", "()Ljavax/swing/JLabel;", "infoComponent", "getInfoComponent", "listSelectionForeground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "nextStepIconLabel", "getNextStepIconLabel", "titleComponent", "getTitleComponent", "getListCellRendererComponent", "Ljavax/swing/JComponent;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "focused", "intellij.platform.vcs.impl"})
    private final class AccountItemRenderer
    extends JPanel
    implements ListCellRenderer<AccountMenuItem.Account> {
        private final Color listSelectionForeground;
        @NotNull
        private final JLabel avatarLabel;
        @NotNull
        private final JLabel titleComponent;
        @NotNull
        private final JLabel infoComponent;
        @NotNull
        private final JLabel nextStepIconLabel;

        @NotNull
        public final JLabel getAvatarLabel() {
            return this.avatarLabel;
        }

        @NotNull
        public final JLabel getTitleComponent() {
            return this.titleComponent;
        }

        @NotNull
        public final JLabel getInfoComponent() {
            return this.infoComponent;
        }

        @NotNull
        public final JLabel getNextStepIconLabel() {
            return this.nextStepIconLabel;
        }

        @NotNull
        public JComponent getListCellRendererComponent(@Nullable JList<? extends AccountMenuItem.Account> list, @NotNull AccountMenuItem.Account value, int index, boolean selected, boolean focused) {
            Color color;
            Color color2;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.avatarLabel.setIcon(value.getIcon());
            JLabel jLabel = this.titleComponent;
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$apply = jLabel;
            boolean bl3 = false;
            $this$apply.setText(value.getTitle());
            if (selected) {
                color2 = this.listSelectionForeground;
            } else {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES");
                color2 = simpleTextAttributes.getFgColor();
            }
            $this$apply.setForeground(color2);
            jLabel = this.infoComponent;
            bl = false;
            bl2 = false;
            $this$apply = jLabel;
            boolean bl4 = false;
            $this$apply.setText(value.getInfo());
            if (selected) {
                color = this.listSelectionForeground;
            } else {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES");
                color = simpleTextAttributes.getFgColor();
            }
            $this$apply.setForeground(color);
            jLabel = this.nextStepIconLabel;
            bl = false;
            bl2 = false;
            $this$apply = jLabel;
            boolean bl5 = false;
            $this$apply.setIcon(value.getActions().isEmpty() ? (Icon)AccountMenuItemRenderer.this.emptyMenuRightArrowIcon : (selected && ColorUtil.isDark((Color)AccountMenuItemRenderer.this.listSelectionBackground) ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep));
            return this;
        }

        public AccountItemRenderer() {
            JLabel $this$apply;
            super(new GridBagLayout());
            Color color = UIUtil.getListSelectionForeground((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"UIUtil.getListSelectionForeground(true)");
            this.listSelectionForeground = color;
            this.avatarLabel = new JLabel();
            JLabel jLabel = new JLabel();
            boolean bl = false;
            boolean bl2 = false;
            JLabel jLabel2 = jLabel;
            AccountItemRenderer accountItemRenderer = this;
            boolean bl3 = false;
            $this$apply.setFont((Font)JBUI.Fonts.label().asBold());
            Unit unit = Unit.INSTANCE;
            accountItemRenderer.titleComponent = jLabel;
            jLabel = new JLabel();
            bl = false;
            bl2 = false;
            $this$apply = jLabel;
            accountItemRenderer = this;
            boolean bl4 = false;
            $this$apply.setFont((Font)JBUI.Fonts.smallFont());
            unit = Unit.INSTANCE;
            accountItemRenderer.infoComponent = jLabel;
            this.nextStepIconLabel = new JLabel();
            JBInsets jBInsets = JBUI.insets((int)AccountMenuItemRenderer.this.innerInset, (int)AccountMenuItemRenderer.this.leftInset, (int)AccountMenuItemRenderer.this.innerInset, (int)AccountMenuItemRenderer.this.innerInset);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"JBUI.insets(innerInset, \u2026, innerInset, innerInset)");
            JBInsets insets = jBInsets;
            GridBag gridBag = new GridBag().setDefaultAnchor(17);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag().setDefaultAnchor(GridBag.WEST)");
            GridBag gbc = gridBag;
            GridBag gridBag2 = gbc.nextLine().next().weightx(0.0).fillCellVertically().insets((Insets)insets).coverColumn();
            Intrinsics.checkNotNullExpressionValue((Object)gridBag2, (String)"gbc.nextLine().next() //\u2026ets(insets).coverColumn()");
            gbc = gridBag2;
            this.add((Component)this.avatarLabel, gbc);
            GridBag gridBag3 = gbc.next().weightx(1.0).weighty(0.5).fillCellHorizontally().anchor(25);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag3, (String)"gbc.next() // 2, 1\n     \u2026(GridBag.LAST_LINE_START)");
            gbc = gridBag3;
            this.add((Component)this.titleComponent, gbc);
            GridBag gridBag4 = gbc.next().weightx(0.0).insets((Insets)insets).coverColumn();
            Intrinsics.checkNotNullExpressionValue((Object)gridBag4, (String)"gbc.next() // 3, |\n     \u2026ets(insets).coverColumn()");
            gbc = gridBag4;
            this.add((Component)this.nextStepIconLabel, gbc);
            GridBag gridBag5 = gbc.nextLine().next().next().weightx(1.0).weighty(0.5).fillCellHorizontally().anchor(23);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag5, (String)"gbc.nextLine().next().ne\u2026GridBag.FIRST_LINE_START)");
            gbc = gridBag5;
            this.add((Component)this.infoComponent, gbc);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J:\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer$ActionItemRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "(Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer;)V", "actionTextLabel", "Ljavax/swing/JLabel;", "getActionTextLabel", "()Ljavax/swing/JLabel;", "rightIconLabel", "getRightIconLabel", "getListCellRendererComponent", "Ljavax/swing/JComponent;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "focused", "intellij.platform.vcs.impl"})
    private final class ActionItemRenderer
    extends JPanel
    implements ListCellRenderer<AccountMenuItem.Action> {
        @NotNull
        private final JLabel actionTextLabel;
        @NotNull
        private final JLabel rightIconLabel;

        @NotNull
        public final JLabel getActionTextLabel() {
            return this.actionTextLabel;
        }

        @NotNull
        public final JLabel getRightIconLabel() {
            return this.rightIconLabel;
        }

        @NotNull
        public JComponent getListCellRendererComponent(@Nullable JList<? extends AccountMenuItem.Action> list, @NotNull AccountMenuItem.Action value, int index, boolean selected, boolean focused) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.actionTextLabel.setText(value.getText());
            this.rightIconLabel.setIcon(value.getRightIcon());
            this.actionTextLabel.setForeground(UIUtil.getListForeground((boolean)selected, (boolean)true));
            return this;
        }

        public ActionItemRenderer() {
            super(new GridBagLayout());
            this.actionTextLabel = new JLabel();
            this.rightIconLabel = new JLabel();
            int topBottom = 3;
            JBInsets jBInsets = JBUI.insets((int)topBottom, (int)AccountMenuItemRenderer.this.leftInset, (int)topBottom, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"JBUI.insets(topBottom, leftInset, topBottom, 0)");
            JBInsets insets = jBInsets;
            GridBag gridBag = new GridBag().setDefaultAnchor(17);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag().setDefaultAnchor(GridBag.WEST)");
            GridBag gbc = gridBag;
            GridBag gridBag2 = gbc.nextLine().next().insets((Insets)insets);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag2, (String)"gbc.nextLine().next().insets(insets)");
            gbc = gridBag2;
            this.add((Component)this.actionTextLabel, gbc);
            GridBag gridBag3 = gbc.next();
            Intrinsics.checkNotNullExpressionValue((Object)gridBag3, (String)"gbc.next()");
            gbc = gridBag3;
            this.add((Component)this.rightIconLabel, gbc);
            GridBag gridBag4 = gbc.next().fillCellHorizontally().weightx(1.0).anchor(13).insets((Insets)JBUI.insets((int)topBottom, (int)AccountMenuItemRenderer.this.leftInset, (int)topBottom, (int)AccountMenuItemRenderer.this.innerInset));
            Intrinsics.checkNotNullExpressionValue((Object)gridBag4, (String)"gbc.next().fillCellHoriz\u2026, topBottom, innerInset))");
            gbc = gridBag4;
            this.add((Component)new JLabel((Icon)AccountMenuItemRenderer.this.emptyMenuRightArrowIcon), gbc);
        }
    }
}

