/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.hosting;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.UriUtil;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/util/hosting/GitHostingUrlUtil;", "", "()V", "getUriFromRemoteUrl", "Ljava/net/URI;", "remoteUrl", "", "removeProtocolPrefix", "url", "intellij.platform.vcs.codeReview"})
public final class GitHostingUrlUtil {
    @NotNull
    public static final GitHostingUrlUtil INSTANCE;

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String removeProtocolPrefix(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int index = StringsKt.indexOf$default((CharSequence)url, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string2 = url;
            int n = index + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return StringsKt.replace$default((String)string3, (char)':', (char)'/', (boolean)false, (int)4, null);
        }
        index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string4 = url;
            int n = index + 3;
            boolean bl = false;
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = url;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final URI getUriFromRemoteUrl(@NotNull String remoteUrl) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
        String string = UriUtil.trimTrailingSlashes((String)remoteUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UriUtil.trimTrailingSlashes(remoteUrl)");
        String fixed = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"/"), (CharSequence)".git");
        try {
            uRI = !StringsKt.contains$default((CharSequence)fixed, (CharSequence)"://", (boolean)false, (int)2, null) ? new URI("https://" + StringsKt.replace$default((String)GitHostingUrlUtil.removeProtocolPrefix(fixed), (char)':', (char)'/', (boolean)false, (int)4, null)) : new URI(fixed);
        }
        catch (URISyntaxException e) {
            uRI = null;
        }
        return uRI;
    }

    private GitHostingUrlUtil() {
    }

    static {
        GitHostingUrlUtil gitHostingUrlUtil;
        INSTANCE = gitHostingUrlUtil = new GitHostingUrlUtil();
    }
}

