/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ContentRevisionVirtualFile
extends AbstractVcsVirtualFile {
    @NotNull
    private final ContentRevision myContentRevision;
    private volatile byte[] myContent;
    private volatile boolean myContentLoadFailed;
    private final Object LOCK;
    private static final Map<ContentRevision, ContentRevisionVirtualFile> ourMap = ContainerUtil.createWeakMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentRevisionVirtualFile create(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(0);
        }
        Map<ContentRevision, ContentRevisionVirtualFile> map2 = ourMap;
        synchronized (map2) {
            ContentRevisionVirtualFile revisionVirtualFile = ourMap.get(contentRevision);
            if (revisionVirtualFile == null) {
                revisionVirtualFile = new ContentRevisionVirtualFile(contentRevision);
                ourMap.put(contentRevision, revisionVirtualFile);
            }
            return revisionVirtualFile;
        }
    }

    private ContentRevisionVirtualFile(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(1);
        }
        super(contentRevision.getFile().getPath(), (VirtualFileSystem)VcsFileSystem.getInstance());
        this.LOCK = new Object();
        this.myContentRevision = contentRevision;
        this.setCharset(StandardCharsets.UTF_8);
    }

    public boolean isDirectory() {
        return false;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() {
        if (this.myContentLoadFailed) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                ContentRevisionVirtualFile.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        if (this.myContent == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(3);
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() {
        try {
            byte[] bytes = ChangesUtil.loadContentRevision((ContentRevision)this.myContentRevision);
            Object object = this.LOCK;
            synchronized (object) {
                this.myContent = bytes;
                this.myContentLoadFailed = false;
                this.setRevision(this.myContentRevision.getRevisionNumber().asString());
            }
        }
        catch (VcsException e) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myContentLoadFailed = true;
                this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.setRevision("0");
            }
            this.showLoadingContentFailedMessage(e);
        }
    }

    @NotNull
    public ContentRevision getContentRevision() {
        ContentRevision contentRevision = this.myContentRevision;
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(4);
        }
        return contentRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

