/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.FilesCollector;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronouslyKt;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.Wrapper;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J*\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010H\u0002J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007J\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0007J\u0015\u0010\u0018\u001a\u00020\u000b2\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020 0\u000eH\u0007J\u0016\u0010!\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/update/RefreshVFsSynchronously;", "", "()V", "TRACE_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findValidParent", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "refresh", "", "T", "changes", "", "wrapper", "Lcom/intellij/openapi/vcs/update/Wrapper;", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "isRollback", "", "refreshDeletedFiles", "files", "refreshFiles", "refreshVirtualFiles", "trace", "message", "", "Lorg/jetbrains/annotations/NonNls;", "updateAllChanged", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "updateChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "updateChangesForRollback", "", "intellij.platform.vcs.impl"})
public final class RefreshVFsSynchronously {
    private static final Logger TRACE_LOG;
    @NotNull
    public static final RefreshVFsSynchronously INSTANCE;

    @JvmStatic
    public static final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously: " + message);
        }
    }

    @JvmStatic
    public static final void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"updatedFiles");
        FilesCollector collector = new FilesCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, collector);
        INSTANCE.refreshDeletedFiles((Collection<? extends File>)collector.getDeletedFiles());
        RefreshVFsSynchronously.refreshFiles((Collection<? extends File>)collector.getFiles());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void refreshFiles(@NotNull Collection<? extends File> files) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            File it = (File)element$iv;
            boolean bl3 = false;
            if (INSTANCE.findValidParent(it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            VirtualFile it$iv = virtualFile;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        Collection $this$toTypedArray$iv = toRefresh;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        if (virtualFileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFiles: " + files, new Throwable());
        }
        Collection<? extends VirtualFile> $this$toTypedArray$iv = files;
        boolean $i$f$toTypedArray = false;
        Collection<? extends VirtualFile> thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        if (virtualFileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDeletedFiles(Collection<? extends File> files) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshDeletedFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            File it = (File)element$iv;
            boolean bl3 = false;
            if (INSTANCE.findValidParent(it.getParentFile()) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            VirtualFile it$iv = virtualFile;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        Collection $this$toTypedArray$iv = toRefresh;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        if (virtualFileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    private final VirtualFile findValidParent(File file) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, (Function1)findValidParent.1.INSTANCE), (Function1)findValidParent.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                if (!virtualFile.isValid()) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @JvmStatic
    public static final void updateChangesForRollback(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh((Collection)changes, RefreshVFsSynchronouslyKt.access$getREVERSED_CHANGE_WRAPPER$p());
    }

    @JvmStatic
    public static final void updateChanges(@NotNull Collection<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh(changes, RefreshVFsSynchronouslyKt.access$getCHANGE_WRAPPER$p());
    }

    public final void refresh(@NotNull Collection<? extends FilePathChange> changes, boolean isRollback) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.refresh(changes, isRollback ? RefreshVFsSynchronouslyKt.access$getREVERSED_FILE_PATH_CHANGE_WRAPPER$p() : RefreshVFsSynchronouslyKt.access$getFILE_PATH_CHANGE_WRAPPER$p());
    }

    public static /* synthetic */ void refresh$default(RefreshVFsSynchronously refreshVFsSynchronously, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        refreshVFsSynchronously.refresh(collection, bl);
    }

    private final <T> void refresh(Collection<? extends T> changes, Wrapper<T> wrapper) {
        boolean bl = false;
        Set files = new LinkedHashSet();
        boolean bl2 = false;
        Set deletedFiles = new LinkedHashSet();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            File file;
            Collection collection;
            FilePath it;
            FilePath filePath;
            boolean bl4;
            boolean bl5;
            Object element$iv;
            Object change = element$iv = iterator.next();
            boolean bl6 = false;
            FilePath beforePath = wrapper.getBeforePath(change);
            FilePath afterPath = wrapper.getAfterPath(change);
            if (beforePath != null) {
                bl5 = false;
                bl4 = false;
                it = filePath;
                boolean bl7 = false;
                collection = wrapper.isBeforePathDeleted(change) ? deletedFiles : files;
                file = it.getIOFile();
                bl3 = false;
                collection.add(file);
            }
            if (afterPath == null) continue;
            bl5 = false;
            bl4 = false;
            it = filePath;
            boolean bl8 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)beforePath) ^ true)) continue;
            collection = files;
            file = it.getIOFile();
            bl3 = false;
            collection.add(file);
        }
        RefreshVFsSynchronously.refreshFiles(files);
        this.refreshDeletedFiles(deletedFiles);
    }

    private RefreshVFsSynchronously() {
    }

    static {
        RefreshVFsSynchronously refreshVFsSynchronously;
        INSTANCE = refreshVFsSynchronously = new RefreshVFsSynchronously();
        Logger logger = Logger.getInstance((String)"#trace.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#tra\u2026RefreshVFsSynchronously\")");
        TRACE_LOG = logger;
    }
}

