/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.message.BodyLimitSettings;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageUi,
CommitMessageI,
LafManagerListener {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    @NotNull
    private final LoadingDecorator myLoadingDecorator;
    @Nullable
    @Nls
    private final String myMessagePlaceholder;
    @NotNull
    private static final EditorCustomization COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION = editor -> {
        editor.setBackgroundColor(null);
        editor.setColorsScheme(CommitMessage.getCommitMessageColorScheme());
    };
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;
    @NotNull
    private List<ChangeList> myChangeLists;

    @NotNull
    private static EditorColorsScheme getCommitMessageColorScheme() {
        boolean isEditorDark;
        boolean isLaFDark = ColorUtil.isDark((Color)UIUtil.getPanelBackground());
        EditorColorsScheme editorColorsScheme = isLaFDark == (isEditorDark = EditorColorsManager.getInstance().isDarkEditor()) ? EditorColorsManager.getInstance().getGlobalScheme() : EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        if (editorColorsScheme == null) {
            CommitMessage.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    public CommitMessage(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(1);
        }
        this(project, true, true, true);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(2);
        }
        this(project, withSeparator, showToolbar, runInspections, null);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections, @Nullable @Nls String messagePlaceholder) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myChangeLists = Collections.emptyList();
        this.myMessagePlaceholder = messagePlaceholder;
        this.myEditorField = CommitMessage.createCommitMessageEditor(project, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.myEditorField.setPlaceholder((CharSequence)this.myMessagePlaceholder);
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myEditorField, (Disposable)this, 0);
        this.add((Component)this.myLoadingDecorator.getComponent(), "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)this.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)this.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.updateOnInspectionProfileChanged(project);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LafManagerListener.TOPIC, (Object)this);
    }

    public void stopLoading() {
        this.myLoadingDecorator.stopLoading();
        this.myEditorField.setEnabled(true);
        this.myEditorField.setPlaceholder((CharSequence)this.myMessagePlaceholder);
    }

    public void startLoading() {
        this.myEditorField.setEnabled(false);
        this.myEditorField.setPlaceholder(null);
        this.myLoadingDecorator.startLoading(false);
    }

    private void updateOnInspectionProfileChanged(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(4);
        }
        project.getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> {
            Editor editor = this.myEditorField.getEditor();
            if (editor instanceof EditorEx) {
                RightMarginCustomization.customize(project, (EditorEx)editor);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        Editor editor;
        if (source == null) {
            CommitMessage.$$$reportNull$$$0(5);
        }
        if ((editor = this.myEditorField.getEditor()) instanceof EditorEx) {
            COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION.customize((EditorEx)editor);
        }
    }

    @NotNull
    private JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            CommitMessage.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CommitMessage.$$$reportNull$$$0(7);
        }
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull @NlsContexts.Separator String text2) {
        if (text2 == null) {
            CommitMessage.$$$reportNull$$$0(8);
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text2);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static EditorTextField createCommitTextEditor(@NotNull Project project, boolean forceSpellCheckOn) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(9);
        }
        return CommitMessage.createCommitMessageEditor(project, false);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(10);
        }
        HashSet<Object> features = new HashSet<Object>();
        features.add(new RightMarginCustomization(project));
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION);
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextField editorField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        editorField.setFontInheritedFromLAF(false);
        EditorTextField editorTextField = editorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(11);
        }
        return editorTextField;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element) {
        Document document;
        if (element == null) {
            CommitMessage.$$$reportNull$$$0(12);
        }
        return (document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile())) != null && document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        CommitMessage commitMessage2;
        if (document == null) {
            CommitMessage.$$$reportNull$$$0(13);
        }
        return (commitMessage2 = (CommitMessage)document.getUserData(DATA_KEY)) != null ? commitMessage2.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup == null) {
            CommitMessage.$$$reportNull$$$0(14);
        }
        return actionGroup;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField = this.myEditorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(15);
        }
        return editorTextField;
    }

    @NotNull
    public String getText() {
        String string = this.getComment();
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    public void focus() {
        this.requestFocusInMessage();
    }

    @NotNull
    public String getComment() {
        String string = StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorField, true));
        this.myEditorField.selectAll();
    }

    public void dispose() {
        this.removeAll();
        this.myEditorField.getDocument().putUserData(DATA_KEY, null);
    }

    @RequiresEdt
    public synchronized void setChangeList(@NotNull ChangeList value) {
        if (value == null) {
            CommitMessage.$$$reportNull$$$0(18);
        }
        this.setChangeLists(Collections.singletonList(value));
    }

    @RequiresEdt
    public synchronized void setChangeLists(@NotNull List<ChangeList> value) {
        if (value == null) {
            CommitMessage.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChangeLists = ContainerUtil.newUnmodifiableList(value);
    }

    @NotNull
    @RequiresReadLock
    public synchronized List<ChangeList> getChangeLists() {
        List<ChangeList> list = this.myChangeLists;
        if (list == null) {
            CommitMessage.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageColorScheme";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorField";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateOnInspectionProfileChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lookAndFeelChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSeparatorText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommitTextEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setChangeList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        ConditionalTrafficLightRenderer(@NotNull Project project, @NotNull Document document) {
            if (project == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(0);
            }
            if (document == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(1);
            }
            super(project, document);
        }

        protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
            super.refresh(editorMarkupModel);
            if (editorMarkupModel != null) {
                editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.getErrorCount()));
            }
        }

        private boolean hasHighSeverities(int @NotNull [] errorCount) {
            if (errorCount == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(2);
            }
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            for (int i = 0; i < errorCount.length; ++i) {
                if (errorCount[i] <= 0 || this.getSeverityRegistrar().compare(this.getSeverityRegistrar().getSeverityByIndex(i), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCount";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasHighSeverities";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        InspectionCustomization(@NotNull Project project) {
            if (project == null) {
                InspectionCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            PsiFile file;
            if (editor == null) {
                InspectionCustomization.$$$reportNull$$$0(1);
            }
            if ((file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument())) != null) {
                file.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, profile -> new InspectionProfileWrapper((InspectionProfileImpl)CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
            ((EditorMarkupModelImpl)editor.getMarkupModel()).setErrorStripeRenderer((ErrorStripeRenderer)new ConditionalTrafficLightRenderer(this.myProject, (Document)editor.getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RightMarginCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        private RightMarginCustomization(@NotNull Project project) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            if (editor == null) {
                RightMarginCustomization.$$$reportNull$$$0(1);
            }
            RightMarginCustomization.customize(this.myProject, editor);
        }

        private static void customize(@NotNull Project project, @NotNull EditorEx editor) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                RightMarginCustomization.$$$reportNull$$$0(3);
            }
            BodyLimitSettings settings = CommitMessageInspectionProfile.getBodyLimitSettings(project);
            editor.getSettings().setRightMargin(settings.getRightMargin());
            editor.getSettings().setRightMarginShown(settings.isShowRightMargin());
            editor.getSettings().setWrapWhenTypingReachesRightMargin(settings.isWrapOnTyping());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$RightMarginCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

