/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.FilePathIconProvider;
import com.intellij.openapi.vcs.impl.RepositoryBrowserKt;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.impl.VcsVirtualFileContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PlatformIcons;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 J\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "fileSystemTree", "Lcom/intellij/openapi/fileChooser/ex/FileSystemTreeImpl;", "getLocalRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "createChangeVsLocal", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vcs/vfs/VcsVirtualFile;", "dispose", "", "getData", "", "dataId", "", "getLocalFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getSelectionAsChanges", "", "hasSelectedFiles", "", "intellij.platform.vcs.impl"})
public final class RepositoryBrowserPanel
extends JPanel
implements DataProvider,
Disposable {
    private final FileSystemTreeImpl fileSystemTree;
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcsVirtualFile root;
    @NotNull
    private final VirtualFile localRoot;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            serializable = (Serializable)this.fileSystemTree.getSelectedFiles();
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            VirtualFile[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            VirtualFile[] virtualFileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[i];
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                if (!(!v2.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.project, (VirtualFile)it);
                collection.add(openFileDescriptor);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            OpenFileDescriptor[] openFileDescriptorArray = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
            if (openFileDescriptorArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            serializable = (Serializable)openFileDescriptorArray;
        } else {
            serializable = RepositoryBrowserKt.getREPOSITORY_BROWSER_DATA_KEY().is(dataId) ? (Serializable)this : null;
        }
        return serializable;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.fileSystemTree));
    }

    public final boolean hasSelectedFiles() {
        boolean bl;
        block1: {
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            VirtualFile[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            VirtualFile[] virtualFileArray2 = $this$any$iv;
            int n = virtualFileArray2.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray2[i];
                boolean bl2 = false;
                if (!(it instanceof VcsVirtualFile)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Change> getSelectionAsChanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
        VirtualFile[] $this$filterIsInstance$iv = virtualFileArray;
        boolean $i$f$filterIsInstance = false;
        VirtualFile[] virtualFileArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsVirtualFile vcsVirtualFile = (VcsVirtualFile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Change change = this.createChangeVsLocal((VcsVirtualFile)it);
            collection.add(change);
        }
        return (List)destination$iv$iv;
    }

    private final Change createChangeVsLocal(VcsVirtualFile file) {
        VcsVirtualFileContentRevision repoRevision = new VcsVirtualFileContentRevision(file);
        FilePath localPath = this.getLocalFilePath(file);
        CurrentContentRevision localRevision = new CurrentContentRevision(localPath);
        return new Change((ContentRevision)repoRevision, (ContentRevision)localRevision);
    }

    private final FilePath getLocalFilePath(VcsVirtualFile file) {
        File localFile = new File(this.localRoot.getPath(), file.getPath());
        FilePath filePath = VcsUtil.getFilePath((File)localFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(localFile)");
        return filePath;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AbstractVcsVirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final VirtualFile getLocalRoot() {
        return this.localRoot;
    }

    public RepositoryBrowserPanel(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        super(new BorderLayout());
        this.project = project;
        this.root = root;
        this.localRoot = localRoot;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(this, true, false, false, false, false, true){
            final /* synthetic */ RepositoryBrowserPanel this$0;

            @NotNull
            public List<VirtualFile> getRoots() {
                return CollectionsKt.listOf((Object)((Object)this.this$0.getRoot()));
            }

            @Nullable
            public Icon getIcon(@NotNull VirtualFile file) {
                FilePath localPath;
                Icon icon2;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isDirectory()) {
                    return PlatformIcons.FOLDER_ICON;
                }
                if (file instanceof VcsVirtualFile && (icon2 = (Icon)FilePathIconProvider.EP_NAME.computeSafeIfAny((Function)new Function<FilePathIconProvider, Icon>(this, localPath = RepositoryBrowserPanel.access$getLocalFilePath(this.this$0, (VcsVirtualFile)file)){
                    final /* synthetic */ fileChooserDescriptor.1 this$0;
                    final /* synthetic */ FilePath $localPath;

                    @Nullable
                    public final Icon apply(FilePathIconProvider it) {
                        return it.getIcon(this.$localPath, this.this$0.this$0.getProject());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$localPath = filePath;
                    }
                })) != null) {
                    return icon2;
                }
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence());
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeManager.getInsta\u2026leName(file.nameSequence)");
                return fileType.getIcon();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        this.fileSystemTree = new FileSystemTreeImpl(fileChooserDescriptor2, this.project, fileChooserDescriptor2){
            final /* synthetic */ fileChooserDescriptor.1 $fileChooserDescriptor;

            protected boolean useNewAsyncModel() {
                return true;
            }
            {
                this.$fileChooserDescriptor = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        this.fileSystemTree.addOkAction(new Runnable(){

            @Override
            public final void run() {
                VirtualFile[] files;
                for (VirtualFile file : files = (fileSystemTree).getSelectedFiles()) {
                    FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
                }
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        actionGroup.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        this.fileSystemTree.registerMouseListener((ActionGroup)actionGroup);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)(this.fileSystemTree).getTree());
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026Pane(fileSystemTree.tree)");
        JScrollPane scrollPane = jScrollPane;
        this.add((Component)scrollPane, "Center");
    }

    public static final /* synthetic */ FilePath access$getLocalFilePath(RepositoryBrowserPanel $this, VcsVirtualFile file) {
        return $this.getLocalFilePath(file);
    }
}

