/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcs.console.VcsConsoleView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ProjectLevelVcsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ProjectLevelVcsManagerImpl.class);
    @NonNls
    private static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final ProjectLevelVcsManagerSerialization mySerialization;
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    private boolean myHaveLegacyVcsConfiguration;
    @NotNull
    private final AtomicInteger myBackgroundOperationCounter;
    private final Set<ActionKey> myBackgroundRunningTasks;
    private final List<VcsConsoleLine> myPendingOutput;
    private final FileIndexFacade myExcludedIndex;

    public ProjectLevelVcsManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(0);
        }
        this.myBackgroundOperationCounter = new AtomicInteger();
        this.myBackgroundRunningTasks = new HashSet<ActionKey>();
        this.myPendingOutput = new ArrayList<VcsConsoleLine>();
        this.myProject = project;
        this.myExcludedIndex = FileIndexFacade.getInstance((Project)project);
        this.mySerialization = new ProjectLevelVcsManagerSerialization();
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myMappings = new NewMappings(this.myProject, this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myMappings);
    }

    public static ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project) {
        if (project == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(1);
        }
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerImpl.getInstance((Project)project);
    }

    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(@Nullable String name) {
        AbstractVcs result2 = name == null || this.myProject.isDisposed() ? null : AllVcses.getInstance(this.myProject).getByName(name);
        ProgressManager.checkCanceled();
        return result2;
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file, Processor<? super VirtualFile> processor) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file, processor);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public AbstractVcs @NotNull [] getAllSupportedVcss() {
        AbstractVcs[] abstractVcsArray = AllVcses.getInstance(this.myProject).getSupportedVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(2);
        }
        return abstractVcsArray;
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        VcsAnnotationLocalChangesListener vcsAnnotationLocalChangesListener = (VcsAnnotationLocalChangesListener)this.myProject.getService(VcsAnnotationLocalChangesListener.class);
        if (vcsAnnotationLocalChangesListener == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(3);
        }
        return vcsAnnotationLocalChangesListener;
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (this.getVcsFor(file) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull FilePath file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(6);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        return changes == null ? null : changes.getContentManager();
    }

    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs @NotNull [] getAllActiveVcss() {
        AbstractVcs[] abstractVcsArray = this.myMappings.getActiveVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(7);
        }
        return abstractVcsArray;
    }

    @Nullable
    public AbstractVcs getSingleVCS() {
        AbstractVcs[] vcses = this.getAllActiveVcss();
        return vcses.length == 1 ? vcses[0] : null;
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Deprecated
    public void addMessageToConsoleWindow(String message, TextAttributes attributes2) {
        this.addMessageToConsoleWindow(message, new ConsoleViewContentType("", attributes2));
    }

    public void addMessageToConsoleWindow(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(8);
        }
        this.addMessageToConsoleWindow(VcsConsoleLine.create((String)message, (ConsoleViewContentType)contentType));
    }

    public void addMessageToConsoleWindow(@Nullable VcsConsoleLine line) {
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        if (line == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return;
            }
            ContentManager contentManager = this.getContentManager();
            if (contentManager == null) {
                this.myPendingOutput.add(line);
            } else {
                VcsConsoleContent panel2 = this.getOrCreateConsoleContent(contentManager);
                panel2.printToConsole(line);
            }
        }, ModalityState.defaultModalityState());
    }

    @Nullable
    private static VcsConsoleContent getConsoleContent(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(9);
        }
        return (VcsConsoleContent)((Object)ContainerUtil.findInstance((Object[])contentManager.getContents(), VcsConsoleContent.class));
    }

    @RequiresEdt
    @NotNull
    private VcsConsoleContent getOrCreateConsoleContent(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(Registry.is((String)"vcs.showConsole"));
        VcsConsoleContent console = ProjectLevelVcsManagerImpl.getConsoleContent(contentManager);
        if (console != null) {
            VcsConsoleContent vcsConsoleContent = console;
            if (vcsConsoleContent == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(11);
            }
            return vcsConsoleContent;
        }
        VcsConsoleContent newConsole = new VcsConsoleContent(this.myProject);
        for (VcsConsoleLine line : this.myPendingOutput) {
            newConsole.printToConsole(line);
        }
        this.myPendingOutput.clear();
        contentManager.addContent((Content)newConsole);
        VcsConsoleContent vcsConsoleContent = newConsole;
        if (vcsConsoleContent == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(12);
        }
        return vcsConsoleContent;
    }

    @Override
    @NotNull
    public PersistentVcsShowSettingOption getOptions(VcsConfiguration.StandardOption option2) {
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.myOptionsAndConfirmations.getOption(option2);
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(13);
        }
        return persistentVcsShowSettingOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowSettingOption> getAllOptions() {
        List<PersistentVcsShowSettingOption> list = this.myOptionsAndConfirmations.getAllOptions();
        if (list == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option2, @NotNull AbstractVcs vcs) {
        if (option2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(15);
        }
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(16);
        }
        PersistentVcsShowSettingOption options = this.getOptions(option2);
        options.addApplicableVcs(vcs);
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = options;
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(17);
        }
        return persistentVcsShowSettingOption;
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull @NonNls String vcsActionName, @NotNull AbstractVcs vcs) {
        if (vcsActionName == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(18);
        }
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(19);
        }
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.myOptionsAndConfirmations.getOrCreateCustomOption(vcsActionName, vcs);
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(20);
        }
        return persistentVcsShowSettingOption;
    }

    @RequiresEdt
    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        UpdateInfoTree tree = this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree);
        }
    }

    @Override
    @RequiresEdt
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        String tabName = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        ContentUtilEx.addTabbedContent((ContentManager)contentManager, (JComponent)((Object)updateInfoTree), (String)"Update Info", (Supplier)VcsBundle.messagePointer((String)"vcs.update.tab.name", (Object[])new Object[0]), () -> tabName, (boolean)false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    @Nullable
    private VcsDirectoryMapping getDirectoryMappingFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    public void setDirectoryMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (path2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(21);
        }
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path2), activeVcsName);
    }

    public void setAutoDirectoryMappings(@NotNull List<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(22);
        }
        this.myMappings.setDirectoryMappings(mappings);
        this.myMappings.cleanupMappings();
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(23);
        }
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items) {
        if (items == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(24);
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items);
    }

    @Override
    public void scheduleMappedRootsUpdate() {
        this.myMappings.scheduleMappedRootsUpdate();
    }

    public void updateMappedVcsesImmediately() {
        this.myMappings.updateMappedVcsesImmediately();
    }

    private void activateActiveVcses() {
        this.myMappings.activateActiveVcses();
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        this.mySerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        if (this.myHaveLegacyVcsConfiguration) {
            element.setAttribute(SETTINGS_EDITED_MANUALLY, "true");
        }
        Element element2 = element;
        if (element2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(25);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(26);
        }
        this.mySerialization.readExternalUtil(state, this.myOptionsAndConfirmations);
        Attribute attribute = state.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option2, AbstractVcs vcs) {
        if (option2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(27);
        }
        PersistentVcsShowConfirmationOption result2 = this.getConfirmation(option2);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = result2;
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(28);
        }
        return persistentVcsShowConfirmationOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowConfirmationOption> getAllConfirmations() {
        List<PersistentVcsShowConfirmationOption> list = this.myOptionsAndConfirmations.getAllConfirmations();
        if (list == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Override
    @NotNull
    public PersistentVcsShowConfirmationOption getConfirmation(VcsConfiguration.StandardConfirmation option2) {
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = this.myOptionsAndConfirmations.getConfirmation(option2);
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(30);
        }
        return persistentVcsShowConfirmationOption;
    }

    public void startBackgroundVcsOperation() {
        this.myBackgroundOperationCounter.incrementAndGet();
    }

    public void stopBackgroundVcsOperation() {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        int counter = this.myBackgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter.get() > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    public VirtualFile @NotNull [] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(31);
        }
        VirtualFile[] virtualFileArray = MappingsToRoots.getRootsUnderVcs(this.myProject, this.myMappings, vcs);
        if (virtualFileArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(32);
        }
        return virtualFileArray;
    }

    public List<VirtualFile> getDetailedVcsMappings(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(33);
        }
        return MappingsToRoots.getDetailedVcsMappings(this.myProject, this.myMappings, vcs);
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    public VcsRoot @NotNull [] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        VcsRoot[] vcsRootArray = vcsRoots.toArray(new VcsRoot[0]);
        if (vcsRootArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(34);
        }
        return vcsRootArray;
    }

    public String getConsolidatedVcsName() {
        AbstractVcs singleVcs = this.getSingleVCS();
        return singleVcs != null ? singleVcs.getShortNameWithMnemonic() : VcsBundle.message((String)"vcs.generic.name.with.mnemonic", (Object[])new Object[0]);
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    void readDirectoryMappings(@NotNull Element element) {
        if (element == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(35);
        }
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        boolean haveNonEmptyMappings = false;
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            String vcs = child.getAttributeValue(ATTRIBUTE_VCS);
            String directory = child.getAttributeValue(ATTRIBUTE_DIRECTORY);
            if (directory == null) continue;
            VcsRootSettings rootSettings = null;
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement != null) {
                AbstractVcs vcsInstance;
                String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
                AbstractVcs abstractVcs = vcsInstance = vcs == null ? null : this.findVcsByName(vcs);
                if (vcsInstance != null && className != null && (rootSettings = vcsInstance.createEmptyVcsRootSettings()) != null) {
                    try {
                        rootSettings.readExternal(rootSettingsElement);
                    }
                    catch (InvalidDataException e) {
                        LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
                    }
                }
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(directory, vcs, rootSettings);
            mappingsList.add(mapping);
            haveNonEmptyMappings |= !mapping.isDefaultMapping();
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    void writeDirectoryMappings(@NotNull Element element) {
        if (element == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(36);
        }
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && mapping.isDefaultMapping() && mapping.isNoneMapping()) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(37);
        }
        HashSet<String> checkedVcses = new HashSet<String>();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            String vcsName = checker.getSupportedVcs().getName();
            checkedVcses.add(vcsName);
            if (!checker.isRoot(file.getPath())) continue;
            return this.findVcsByName(vcsName);
        }
        String foundVcs = null;
        for (VcsDescriptor vcsDescriptor : this.getAllVcss()) {
            String vcsName = vcsDescriptor.getName();
            if (checkedVcses.contains(vcsName) || !vcsDescriptor.probablyUnderVcs(file)) continue;
            if (foundVcs != null) {
                return null;
            }
            foundVcs = vcsName;
        }
        return this.findVcsByName(foundVcs);
    }

    @NotNull
    public VcsRootChecker getRootChecker(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(38);
        }
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getIterable()) {
            if (!checker.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
            VcsRootChecker vcsRootChecker = checker;
            if (vcsRootChecker == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(39);
            }
            return vcsRootChecker;
        }
        return new DefaultVcsRootChecker(vcs);
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.mappingsChanged();
        }
    }

    @Override
    @Nullable
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public BackgroundableActionEnabledHandler getBackgroundableActionHandler(VcsBackgroundableActions action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return new BackgroundableActionEnabledHandler(this.myProject, action);
    }

    @RequiresEdt
    boolean isBackgroundTaskRunning(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    @RequiresEdt
    void startBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(41);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    @RequiresEdt
    void stopBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (vcsInitObject == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(43);
        }
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(44);
        }
        VcsInitialization.getInstance(this.myProject).add(vcsInitObject, runnable);
    }

    public void runAfterInitialization(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(45);
        }
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, runnable);
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            boolean isUnderProject = this.isFileInBaseDir(vf) || this.isInDirectoryBasedRoot(vf) || this.hasExplicitMapping(vf) || this.myExcludedIndex.isInContent(vf) || !Registry.is((String)"ide.hide.excluded.files") && this.myExcludedIndex.isExcludedFile(vf);
            return isUnderProject && !this.isIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull VirtualFile vf) {
        if (vf == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(46);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                return this.myExcludedIndex.isExcludedFile(vf);
            }
            return this.myExcludedIndex.isUnderIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull FilePath filePath) {
        if (filePath == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(47);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                VirtualFile vf = ChangesUtil.findValidParentAccurately((FilePath)filePath);
                return vf != null && this.myExcludedIndex.isExcludedFile(vf);
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (String name : StringUtil.tokenize((String)filePath.getPath(), (String)"/")) {
                if (!fileTypeManager.isFileIgnored(name)) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isInDirectoryBasedRoot(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(48);
        }
        if (ProjectKt.isDirectoryBased((Project)this.myProject)) {
            return ProjectKt.getStateStore((Project)this.myProject).isProjectFile(file);
        }
        return false;
    }

    private boolean isFileInBaseDir(@NotNull VirtualFile file) {
        VirtualFile baseDir;
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(49);
        }
        if ((baseDir = this.myProject.getBaseDir()) == null) {
            return false;
        }
        if (file.isDirectory()) {
            return baseDir.equals(file);
        }
        return baseDir.equals(file.getParent());
    }

    private boolean hasExplicitMapping(@NotNull VirtualFile vFile) {
        VcsDirectoryMapping mapping;
        if (vFile == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(50);
        }
        return (mapping = this.getDirectoryMappingFor(vFile)) != null && !mapping.isDefaultMapping();
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return VcsCacheManager.getInstance(this.myProject).getVcsHistoryCache();
    }

    public ContentRevisionCache getContentRevisionCache() {
        return VcsCacheManager.getInstance(this.myProject).getContentRevisionCache();
    }

    @TestOnly
    public void waitForInitialized() {
        VcsInitialization.getInstance(this.myProject).waitFinished();
    }

    public void showConsole() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.showConsole(null);
    }

    public void showConsole(@Nullable Runnable then) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        ToolWindow vcsToolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        if (vcsToolWindow == null) {
            return;
        }
        if (vcsToolWindow.isVisible()) {
            this.showConsoleInternal();
            if (then != null) {
                then.run();
            }
        } else {
            vcsToolWindow.show(() -> {
                this.showConsoleInternal();
                if (then != null) {
                    then.run();
                }
            });
        }
    }

    public void scrollConsoleToTheEnd() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        ContentManager cm = this.getContentManager();
        if (cm == null) {
            return;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        if (consoleContent == null) {
            return;
        }
        consoleContent.scrollToEnd();
    }

    public boolean isConsoleVisible() {
        if (!Registry.is((String)"vcs.showConsole")) {
            return false;
        }
        ContentManager cm = this.getContentManagerIfCreated();
        if (cm == null) {
            return false;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        return consoleContent != null;
    }

    @Nullable
    private ContentManager getContentManagerIfCreated() {
        ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        return changes == null ? null : changes.getContentManagerIfCreated();
    }

    private void showConsoleInternal() {
        ContentManager cm = this.getContentManager();
        if (cm == null) {
            return;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        if (consoleContent == null) {
            return;
        }
        cm.setSelectedContent((Content)consoleContent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 37: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 31: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_VCS;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsActionName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MAPPING;
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsInitObject";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupportedVcss";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationLocalChangesListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActiveVcss";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateConsoleContent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOptions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardOption";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCustomOption";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardConfirmation";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfirmations";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsUnderVcs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVcsRoots";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterVcs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessageToConsoleWindow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateConsoleContent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStandardOption";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCustomOption";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMapping";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setAutoDirectoryMappings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getStandardConfirmation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedVcsMappings";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readDirectoryMappings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "writeDirectoryMappings";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findVersioningVcs";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRootChecker";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBackgroundTaskRunning";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "startBackgroundTask";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "stopBackgroundTask";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addInitializationRequest";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runAfterInitialization";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isInDirectoryBasedRoot";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isFileInBaseDir";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ActivateVcsesStartupActivity
    implements VcsStartupActivity {
        ActivateVcsesStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                ActivateVcsesStartupActivity.$$$reportNull$$$0(0);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(project).activateActiveVcses();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActivateVcsesStartupActivity", "runActivity"));
        }
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            if (objects == null) {
                ActionKey.$$$reportNull$$$0(0);
            }
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return this.getClass() + " - " + Arrays.toString(this.myObjects);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey", "<init>"));
        }
    }

    private static final class VcsConsoleContent
    extends ContentImpl {
        @NotNull
        private final ConsoleView myConsole;

        private VcsConsoleContent(@NotNull Project project) {
            if (project == null) {
                VcsConsoleContent.$$$reportNull$$$0(0);
            }
            super(null, VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]), true);
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            this.myConsole = new VcsConsoleView(project);
            Disposer.register((Disposable)this, (Disposable)this.myConsole);
            panel2.setContent(this.myConsole.getComponent());
            DefaultActionGroup actionGroup = new DefaultActionGroup(this.myConsole.createConsoleActions());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)actionGroup, false);
            panel2.setToolbar(toolbar.getComponent());
            this.setComponent((JComponent)panel2);
            this.setPreferredFocusedComponent(() -> ((ConsoleView)this.myConsole).getPreferredFocusableComponent());
        }

        public void scrollToEnd() {
            this.myConsole.requestScrollingToEnd();
        }

        public void printToConsole(@NotNull VcsConsoleLine line) {
            if (line == null) {
                VcsConsoleContent.$$$reportNull$$$0(1);
            }
            line.print(this.myConsole);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$VcsConsoleContent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printToConsole";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

