/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.codeWithMe.ClientIdService;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListAvailabilityListener;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTrackerImpl;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.BaseRevisionStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.ChangelistsLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.DefaultLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$restoreTrackersForPartiallyChangedFiles$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.LocalLineStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.PartialLineStatusTrackerManagerState;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b.\u0018\u0000 _2\u00020\u00012\u00020\u0002:\u0014^_`abcdefghijklmnopqB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0002J\b\u0010$\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0012\u0010&\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\fH\u0003J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0003J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010(\u001a\u00020\fH\u0016J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u00101\u001a\u00020\u0014H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000*J\b\u00105\u001a\u000206H\u0002J&\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u0001082\u0006\u0010%\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\f2\u0006\u00109\u001a\u000203H\u0002J\u0010\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<H\u0016J\u001c\u0010=\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0002J\u0015\u0010@\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\bAJ\u0018\u0010B\u001a\u00020!2\u0006\u0010(\u001a\u00020\f2\u0006\u0010C\u001a\u00020DH\u0007J\b\u0010E\u001a\u00020!H\u0003J\u0010\u0010F\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0003J\u001c\u0010G\u001a\u00020!2\n\u0010H\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u000203H\u0003J\u0010\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001fH\u0002J\b\u0010K\u001a\u00020!H\u0007J\u0010\u0010L\u001a\u00020!2\u0006\u0010(\u001a\u00020\fH\u0003J\u0018\u0010M\u001a\u00020!2\u0006\u0010(\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u0007H\u0017J\u0018\u0010O\u001a\u00020!2\u0006\u0010(\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u0007H\u0017J\u0010\u0010P\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001fH\u0002J\b\u0010Q\u001a\u00020!H\u0007J\u001b\u0010R\u001a\u00020!2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00150*H\u0001\u00a2\u0006\u0002\bTJ\b\u0010U\u001a\u00020!H\u0002J\b\u0010V\u001a\u00020!H\u0002J\"\u0010W\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\f2\b\b\u0002\u0010X\u001a\u00020\u001aH\u0002J\u0010\u0010Y\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001fH\u0002J\b\u0010Z\u001a\u00020!H\u0002J\b\u0010[\u001a\u00020!H\u0002J\b\u0010\\\u001a\u00020!H\u0007J\u001c\u0010]\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u0010(\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010]\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOCK", "", "clmFreezeCounter", "", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "fileStatesAwaitingRefresh", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "filesWithDamagedInactiveRanges", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "addTrackerListener", "", "listener", "disposable", "arePartialChangelistsEnabled", "virtualFile", "canCreateTrackerFor", "checkIfTrackerCanBeReleased", "document", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "dispose", "expireInactiveRangesDamagedNotifications", "getLineStatusTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "file", "getTrackerProvider", "Lcom/intellij/openapi/vcs/impl/LocalLineStatusTrackerProvider;", "getTrackers", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "installTracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "provider", "invokeAfterUpdate", "task", "Ljava/lang/Runnable;", "log", "message", "", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "offerTrackerContent", "text", "", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "registerTrackerInCLM", "data", "releaseAllTrackers", "releaseTracker", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "resetExcludedFromCommitMarkers", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl", "showInactiveRangesDamagedNotification", "startListenForEditors", "switchTracker", "refreshExisting", "unregisterTrackerInCLM", "updatePartialChangeListsAvailability", "updateTrackingSettings", "waitUntilBaseContentsLoaded", "warn", "CheckinFactory", "Companion", "InactiveRangesDamagedNotification", "Listener", "ListenerAdapter", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListAvailabilityListener", "MyChangeListListener", "MyCommandListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileStatusListener", "MyFreezeListener", "MyLineStatusTrackerSettingListener", "MyStartupActivity", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "intellij.platform.vcs.impl"})
public final class LineStatusTrackerManager
implements LineStatusTrackerManagerI,
Disposable {
    private final Object LOCK;
    private boolean isDisposed;
    private final HashMap<Document, TrackerData> trackers;
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private final EventDispatcher<Listener> eventDispatcher;
    private boolean partialChangeListsEnabled;
    private final HashSet<Document> documentsInDefaultChangeList;
    private int clmFreezeCounter;
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    private final HashMap<VirtualFile, ChangelistsLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    private final MyBaseRevisionLoader loader;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final void startListenForEditors() {
        Application app$iv;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection busConnection = messageBusConnection;
        busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)new MyLineStatusTrackerSettingListener());
        busConnection.subscribe(VcsFreezingProcess.Listener.TOPIC, (Object)new MyFreezeListener());
        busConnection.subscribe(CommandListener.TOPIC, (Object)new MyCommandListener());
        busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
        busConnection.subscribe(ChangeListAvailabilityListener.TOPIC, (Object)new MyChangeListAvailabilityListener());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVirtualFileListener());
        LocalLineStatusTrackerProvider.Companion.getEP_NAME().addChangeListener(new Runnable(this){
            final /* synthetic */ LineStatusTrackerManager this$0;

            public final void run() {
                LineStatusTrackerManager.access$updateTrackingSettings(this.this$0);
            }
            {
                this.this$0 = lineStatusTrackerManager;
            }
        }, (Disposable)this);
        this.updatePartialChangeListsAvailability();
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application2 = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"app");
        if (application2.isDispatchThread()) {
            boolean bl = false;
            if (!this.project.isDisposed()) {
                ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
                FileStatusManager.getInstance((Project)this.project).addFileStatusListener((FileStatusListener)new MyFileStatusListener(), (Disposable)this);
                EditorFactory editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
                new MyEditorFactoryListener().install(this);
                this.onEverythingChanged();
                PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(this.project);
            }
        } else {
            boolean $i$f$invokeLater = false;
            Application application3 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(this){
                final /* synthetic */ LineStatusTrackerManager this$0;
                {
                    this.this$0 = lineStatusTrackerManager;
                }

                public final void run() {
                    boolean bl = false;
                    if (!LineStatusTrackerManager.access$getProject$p(this.this$0).isDisposed()) {
                        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), (Disposable)this.this$0);
                        FileStatusManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0)).addFileStatusListener((FileStatusListener)this.this$0.new MyFileStatusListener(), (Disposable)this.this$0);
                        EditorFactory editorFactory = EditorFactory.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), (Disposable)this.this$0);
                        this.this$0.new MyEditorFactoryListener().install(this.this$0);
                        LineStatusTrackerManager.access$onEverythingChanged(this.this$0);
                        PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(LineStatusTrackerManager.access$getProject$p(this.this$0));
                    }
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application3.invokeLater(runnable, modalityState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void dispose() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.loader);
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map map2 = this.forcedDocuments;
            boolean bl4 = false;
            Iterator<Object> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl5 = false;
                map2 = (Document)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    void document;
                    this.warn("Tracker is being held on dispose by " + requester, (Document)document);
                }
            }
            this.forcedDocuments.clear();
            iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                TrackerData trackerData = data = (TrackerData)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"data");
                this.unregisterTrackerInCLM(trackerData);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            TrackerData trackerData = this.trackers.get(document);
            LineStatusTracker lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document document2 = document;
        return this.getLineStatusTracker(document2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                this.warn("Tracker is being requested after dispose by " + requester, document);
                return;
            }
            Multiset<Object> multiset2 = this.forcedDocuments.computeIfAbsent(document, requestTrackerFor.1.multiset.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(multiset2, (String)"forcedDocuments.computeI\u2026hMultiset.create<Any>() }");
            Multiset<Object> multiset3 = multiset2;
            multiset3.add(requester);
            if (this.trackers.get(document) == null) {
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile virtualFile2 = virtualFile;
                LineStatusTrackerManager.switchTracker$default(this, virtualFile2, document, false, 4, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Multiset<Object> multiset2 = this.forcedDocuments.get(document);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove(document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.loader.addAfterUpdateRunnable(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl3 = false;
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                LocalLineStatusTracker<?> localLineStatusTracker = it.getTracker();
                collection2.add(localLineStatusTracker);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            TrackerData trackerData = this.trackers.get(document);
            if (trackerData == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers[document] ?: return");
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey(document)) {
                return;
            }
            if (data.getTracker() instanceof ChangelistsLocalLineStatusTracker) {
                boolean hasPartialChanges = ((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPartialState$intellij_platform_vcs_impl();
                if (hasPartialChanges) {
                    this.log("checkIfTrackerCanBeReleased - hasPartialChanges", data.getTracker().getVirtualFile());
                    return;
                }
                boolean isLoading = this.loader.hasRequestFor(document);
                if (isLoading) {
                    this.log("checkIfTrackerCanBeReleased - isLoading", data.getTracker().getVirtualFile());
                    if (((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPendingPartialState$intellij_platform_vcs_impl() || this.fileStatesAwaitingRefresh.containsKey(data.getTracker().getVirtualFile())) {
                        this.log("checkIfTrackerCanBeReleased - has pending state", data.getTracker().getVirtualFile());
                        return;
                    }
                }
            }
            this.releaseTracker(document);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onEverythingChanged() {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (TrackerData data : this.trackers.values()) {
                files.add(data.getTracker().getVirtualFile());
            }
            for (Document document : this.forcedDocuments.keySet()) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if (file == null) continue;
                files.add(file);
            }
            Iterator<TrackerData> iterator = files.iterator();
            while (iterator.hasNext()) {
                VirtualFile file;
                VirtualFile virtualFile = file = (VirtualFile)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                this.onFileChanged(virtualFile);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026nt(virtualFile) ?: return");
        Document document2 = document;
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            LocalLineStatusTracker<?> tracker;
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document2);
            LocalLineStatusTracker<Object> localLineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker != null || this.forcedDocuments.containsKey(document2)) {
                this.switchTracker(virtualFile, document2, true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath filePath2 = filePath;
        if (data.getClmFilePath() != null) {
            LOG.error("[registerTrackerInCLM] tracker already registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(filePath2, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(filePath2);
    }

    private final void unregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = data.getClmFilePath();
        if (filePath == null) {
            LOG.error("[unregisterTrackerInCLM] tracker is not registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(null);
        FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath actualFilePath = filePath2;
        if (Intrinsics.areEqual((Object)filePath, (Object)actualFilePath) ^ true) {
            LOG.error("[unregisterTrackerInCLM] unexpected file path: expected: " + filePath + ", actual: " + actualFilePath);
        }
    }

    private final void reregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath oldFilePath = data.getClmFilePath();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath newFilePath = filePath;
        if (oldFilePath == null) {
            LOG.error("[reregisterTrackerInCLM] tracker is not registered");
            return;
        }
        if (Intrinsics.areEqual((Object)oldFilePath, (Object)newFilePath) ^ true) {
            ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(oldFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(newFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            data.setClmFilePath(newFilePath);
        }
    }

    private final boolean canCreateTrackerFor(VirtualFile virtualFile) {
        if (this.isDisposed) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile){
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.$virtualFile$inlined = virtualFile;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final T compute() {
                boolean bl;
                boolean bl2 = false;
                if (this.$virtualFile$inlined.isValid()) {
                    FileType fileType = this.$virtualFile$inlined.getFileType();
                    Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"virtualFile.fileType");
                    if (!fileType.isBinary() && !FileUtilRt.isTooLarge((long)this.$virtualFile$inlined.getLength())) {
                        bl = false;
                        return (T)Boolean.valueOf(bl);
                    }
                }
                bl = true;
                return (T)Boolean.valueOf(bl);
            }
        }) == false;
    }

    @Override
    public boolean arePartialChangelistsEnabled() {
        return this.partialChangeListsEnabled;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void switchTracker(VirtualFile virtualFile, Document document, boolean refreshExisting) {
        LocalLineStatusTracker<?> oldTracker;
        LocalLineStatusTrackerProvider provider = this.getTrackerProvider(virtualFile);
        TrackerData trackerData = this.trackers.get(document);
        LocalLineStatusTracker<Object> localLineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
        if (oldTracker != null && provider != null && provider.isMyTracker(oldTracker)) {
            if (refreshExisting) {
                this.refreshTracker(oldTracker, provider);
            }
        } else {
            this.releaseTracker(document);
            if (provider != null) {
                this.installTracker(virtualFile, document, provider);
            }
        }
    }

    static /* synthetic */ void switchTracker$default(LineStatusTrackerManager lineStatusTrackerManager, VirtualFile virtualFile, Document document, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.switchTracker(virtualFile, document, bl);
    }

    private final LocalLineStatusTracker<?> installTracker(VirtualFile virtualFile, Document document, LocalLineStatusTrackerProvider provider) {
        if (this.isDisposed) {
            return null;
        }
        if (this.trackers.get(document) != null) {
            return null;
        }
        LocalLineStatusTracker<?> localLineStatusTracker = provider.createTracker(this.project, virtualFile);
        if (localLineStatusTracker == null) {
            return null;
        }
        LocalLineStatusTracker<?> tracker = localLineStatusTracker;
        tracker.setMode(this.getTrackingMode());
        TrackerData data = new TrackerData(tracker, null, null, 6, null);
        TrackerData replacedData = this.trackers.put(document, data);
        LOG.assertTrue(replacedData == null);
        this.registerTrackerInCLM(data);
        this.refreshTracker(tracker, provider);
        ((Listener)this.eventDispatcher.getMulticaster()).onTrackerAdded((LineStatusTracker)tracker);
        if (this.clmFreezeCounter > 0) {
            tracker.freeze();
        }
        this.log("Tracker installed", virtualFile);
        return tracker;
    }

    private final LocalLineStatusTrackerProvider getTrackerProvider(VirtualFile virtualFile) {
        Object v0;
        block3: {
            if (!this.canCreateTrackerFor(virtualFile)) {
                return null;
            }
            LocalLineStatusTrackerProvider customTracker2 = (LocalLineStatusTrackerProvider)LocalLineStatusTrackerProvider.Companion.getEP_NAME().findFirstSafe((Predicate)new Predicate<LocalLineStatusTrackerProvider>(this, virtualFile){
                final /* synthetic */ LineStatusTrackerManager this$0;
                final /* synthetic */ VirtualFile $virtualFile;

                public final boolean test(LocalLineStatusTrackerProvider it) {
                    return it.isTrackedFile(LineStatusTrackerManager.access$getProject$p(this.this$0), this.$virtualFile);
                }
                {
                    this.this$0 = lineStatusTrackerManager;
                    this.$virtualFile = virtualFile;
                }
            });
            if (customTracker2 != null) {
                return customTracker2;
            }
            Iterable iterable = CollectionsKt.listOf((Object[])new BaseRevisionStatusTrackerContentLoader[]{ChangelistsLocalStatusTrackerProvider.INSTANCE, DefaultLocalStatusTrackerProvider.INSTANCE});
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                BaseRevisionStatusTrackerContentLoader it = (BaseRevisionStatusTrackerContentLoader)t;
                boolean bl3 = false;
                if (!it.isTrackedFile(this.project, virtualFile)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    @RequiresEdt
    private final void releaseTracker(Document document) {
        TrackerData trackerData = this.trackers.remove(document);
        if (trackerData == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers.remove(document) ?: return");
        TrackerData data = trackerData;
        ((Listener)this.eventDispatcher.getMulticaster()).onTrackerRemoved((LineStatusTracker)data.getTracker());
        this.unregisterTrackerInCLM(data);
        data.getTracker().release();
        this.log("Tracker released", data.getTracker().getVirtualFile());
    }

    private final void updatePartialChangeListsAvailability() {
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && ChangeListManager.getInstance((Project)this.project).areChangeListsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTrackingSettings() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            LocalLineStatusTracker.Mode mode = this.getTrackingMode();
            for (TrackerData data : this.trackers.values()) {
                data.getTracker().setMode(mode);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.onEverythingChanged();
    }

    private final LocalLineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        return new LocalLineStatusTracker.Mode(settings.SHOW_LST_GUTTER_MARKERS, settings.SHOW_LST_ERROR_STRIPE_MARKERS, settings.SHOW_WHITESPACES_IN_LST);
    }

    @RequiresEdt
    private final void refreshTracker(LocalLineStatusTracker<?> tracker, LocalLineStatusTrackerProvider provider) {
        if (this.isDisposed) {
            return;
        }
        if (!(provider instanceof LineStatusTrackerContentLoader)) {
            return;
        }
        this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument(), (LineStatusTrackerContentLoader)provider));
        this.log("Refresh queued", tracker.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @RequiresEdt
    @ApiStatus.Internal
    public final void offerTrackerContent(@NotNull Document document, @NotNull CharSequence text) {
        block17: {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            try {
                tracker = null;
                var4_5 = this.LOCK;
                var5_6 = false;
                var6_8 = false;
                synchronized (var4_5) {
                    $i$a$-synchronized-LineStatusTrackerManager$offerTrackerContent$1 = false;
                    data = this.trackers.get(document);
                    if (data == null || data.getContentInfo() != null) {
                        return;
                    }
                    tracker = data.getTracker();
                    var6_9 = Unit.INSTANCE;
                }
                if (!(tracker instanceof LocalLineStatusTrackerImpl)) break block17;
                var4_5 = ClientId.Companion;
                clientId$iv = ClientId.Companion.getLocalId();
                $i$f$withClientId = false;
                v0 = ClientIdService.Companion.tryGetInstance();
                if (v0 == null) {
                    $i$a$-withClientId-LineStatusTrackerManager$offerTrackerContent$2 = false;
                    ((LocalLineStatusTrackerImpl)tracker).setBaseRevision(text);
                    this.log("Offered content", tracker.getVirtualFile());
                    break block17;
                }
                clientIdService$iv = v0;
                if (!clientIdService$iv.isValid(clientId$iv)) {
                    Logger.getInstance(ClientId.class).warn("Invalid clientId: " + clientId$iv, new Throwable());
                }
                if (!clientIdService$iv.getCheckLongActivity()) ** GOTO lbl-1000
                v1 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ApplicationManager.getApplication()");
                if (v1.isDispatchThread() && !this_$iv.isLocal(clientId$iv)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                foreignMainThreadActivity$iv = v2;
                old$iv = clientIdService$iv.getClientIdValue();
                try {
                    v3 = clientId$iv;
                    clientIdService$iv.setClientIdValue(v3 != null ? v3.getValue() : null);
                    if (foreignMainThreadActivity$iv) {
                        beforeActionTime$iv = System.currentTimeMillis();
                        $i$a$-withClientId-LineStatusTrackerManager$offerTrackerContent$2 = false;
                        ((LocalLineStatusTrackerImpl)tracker).setBaseRevision(text);
                        this.log("Offered content", tracker.getVirtualFile());
                        result$iv = Unit.INSTANCE;
                        delta$iv = System.currentTimeMillis() - beforeActionTime$iv;
                        if (delta$iv > (long)1000) {
                            v4 = clientId$iv;
                            Logger.getInstance(ClientId.class).warn("LONG MAIN THREAD ACTIVITY by " + (v4 != null ? v4.getValue() : null) + ". Stack trace:\n" + ClientIdKt.getStackTrace());
                        }
                        var16_22 = result$iv;
                    } else {
                        $i$a$-withClientId-LineStatusTrackerManager$offerTrackerContent$2 = false;
                        ((LocalLineStatusTrackerImpl)tracker).setBaseRevision(text);
                        this.log("Offered content", tracker.getVirtualFile());
                        var7_13 = Unit.INSTANCE;
                    }
                }
                finally {
                    clientIdService$iv.setClientIdValue(old$iv);
                }
            }
            catch (Throwable e) {
                LineStatusTrackerManager.LOG.error(e);
            }
        }
    }

    private final void log(@NonNls String message, VirtualFile file) {
        if (LOG.isDebugEnabled()) {
            if (file != null) {
                LOG.debug(message + "; file: " + file.getPath());
            } else {
                LOG.debug(message);
            }
        }
    }

    private final void warn(@NonNls String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document document3 = document2;
            boolean bl = false;
            boolean bl2 = false;
            Document it = document3;
            boolean bl3 = false;
            virtualFile = FileDocumentManager.getInstance().getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file = virtualFile;
        this.warn(message, file);
    }

    private final void warn(@NonNls String message, VirtualFile file) {
        if (file != null) {
            LOG.warn(message + "; file: " + file.getPath());
        } else {
            LOG.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void resetExcludedFromCommitMarkers() {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = false;
            List documents = new ArrayList();
            for (TrackerData data : this.trackers.values()) {
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                ((ChangelistsLocalLineStatusTracker)tracker).resetExcludedFromCommitMarkers$intellij_platform_vcs_impl();
                documents.add(tracker.getDocument());
            }
            for (Document document : documents) {
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl = false;
        List result2 = new ArrayList();
        Object object = this.LOCK;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            for (TrackerData data : this.trackers.values()) {
                boolean hasPartialChanges;
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker) || !(hasPartialChanges = ((ChangelistsLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((ChangelistsLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    @RequiresEdt
    public final void restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(@NotNull List<? extends ChangelistsLocalLineStatusTracker.State> trackerStates) {
        Intrinsics.checkNotNullParameter(trackerStates, (String)"trackerStates");
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, trackerStates){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ List $trackerStates$inlined;
            {
                this.this$0 = lineStatusTrackerManager;
                this.$trackerStates$inlined = list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object) {
                    boolean bl4 = false;
                    if (LineStatusTrackerManager.access$isDisposed$p(this.this$0)) {
                    } else {
                        for (ChangelistsLocalLineStatusTracker.State state : this.$trackerStates$inlined) {
                            Document document;
                            VirtualFile virtualFile = state.getVirtualFile();
                            if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) {
                                continue;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026(virtualFile) ?: continue");
                            LocalLineStatusTrackerProvider provider = LineStatusTrackerManager.access$getTrackerProvider(this.this$0, virtualFile);
                            if (Intrinsics.areEqual((Object)provider, (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE) ^ true) continue;
                            LineStatusTrackerManager.switchTracker$default(this.this$0, virtualFile, document, false, 4, null);
                            TrackerData trackerData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0).get(document);
                            LocalLineStatusTracker<Object> tracker = trackerData != null ? trackerData.getTracker() : null;
                            if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                            boolean isLoading = LineStatusTrackerManager.access$getLoader$p(this.this$0).hasRequestFor(document);
                            if (isLoading) {
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                                LineStatusTrackerManager.access$log(this.this$0, "State restoration scheduled", virtualFile);
                                continue;
                            }
                            boolean success2 = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                            LineStatusTrackerManager.access$log(this.this$0, "State restored. success - " + success2, virtualFile);
                        }
                        LineStatusTrackerManager.access$getLoader$p(this.this$0).addAfterUpdateRunnable(new Runnable(this){
                            final /* synthetic */ restoreTrackersForPartiallyChangedFiles$$inlined$runWriteAction$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void run() {
                                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0);
                                boolean bl = false;
                                boolean bl2 = false;
                                synchronized (object) {
                                    boolean bl3 = false;
                                    LineStatusTrackerManager.access$log(this.this$0.this$0, "State restoration finished", null);
                                    LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0.this$0).clear();
                                    Unit unit = Unit.INSTANCE;
                                }
                            }
                        });
                        Unit unit = Unit.INSTANCE;
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
        this.onEverythingChanged();
    }

    @RequiresEdt
    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                ApplicationManager.getApplication().assertIsWriteThread();
                if (this.filesWithDamagedInactiveRanges.contains(virtualFile)) break block2;
                FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorManagerEx, (String)"FileEditorManagerEx.getInstanceEx(project)");
                if (!Intrinsics.areEqual((Object)virtualFile, (Object)fileEditorManagerEx.getCurrentFile())) break block3;
            }
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void showInactiveRangesDamagedNotification() {
        InactiveRangesDamagedNotification lastNotification;
        int n;
        InactiveRangesDamagedNotification[] currentNotifications;
        block4: {
            InactiveRangesDamagedNotification inactiveRangesDamagedNotification;
            currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)currentNotifications, (String)"currentNotifications");
            InactiveRangesDamagedNotification[] $this$lastOrNull$iv = currentNotifications;
            boolean $i$f$lastOrNull = false;
            int n2 = $this$lastOrNull$iv.length;
            --n2;
            n = 0;
            while (n2 >= 0) {
                void index$iv;
                InactiveRangesDamagedNotification element$iv;
                InactiveRangesDamagedNotification it = element$iv = $this$lastOrNull$iv[index$iv];
                boolean bl = false;
                InactiveRangesDamagedNotification inactiveRangesDamagedNotification2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)inactiveRangesDamagedNotification2), (String)"it");
                if (!inactiveRangesDamagedNotification2.isExpired()) {
                    inactiveRangesDamagedNotification = element$iv;
                    break block4;
                }
                --index$iv;
            }
            inactiveRangesDamagedNotification = lastNotification = null;
        }
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray = $this$forEach$iv;
        n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
        Set files = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files).notify(this.project);
    }

    @RequiresEdt
    private final void expireInactiveRangesDamagedNotifications() {
        this.filesWithDamagedInactiveRanges.clear();
        InactiveRangesDamagedNotification[] currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)currentNotifications, (String)"currentNotifications");
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray = $this$forEach$iv;
        int n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
    }

    @TestOnly
    public final void waitUntilBaseContentsLoaded() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = application.isUnitTestMode();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.loader.addAfterUpdateRunnable(new Runnable(semaphore){
            final /* synthetic */ Semaphore $semaphore;

            public final void run() {
                this.$semaphore.up();
            }
            {
                this.$semaphore = semaphore;
            }
        });
        long start2 = System.currentTimeMillis();
        do {
            Application application3 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application3, (String)"ApplicationManager.getApplication()");
            if (application3.isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if (!semaphore.waitFor(10L)) continue;
            return;
        } while (System.currentTimeMillis() - start2 <= (long)10000);
        this.loader.dumpInternalState();
        System.err.println(ThreadDumper.dumpThreadsToString());
        throw (Throwable)new IllegalStateException("Couldn't await base contents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void releaseAllTrackers() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.forcedDocuments.clear();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                TrackerData trackerData = data = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"data");
                this.unregisterTrackerInCLM(trackerData);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public LineStatusTrackerManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.LOCK = new Object();
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(Listener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LineStatusTrackerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(LineS\u2026ackerManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setDisposed$p(LineStatusTrackerManager $this, boolean bl) {
        $this.isDisposed = bl;
    }

    public static final /* synthetic */ void access$setPartialChangeListsEnabled$p(LineStatusTrackerManager $this, boolean bl) {
        $this.partialChangeListsEnabled = bl;
    }

    public static final /* synthetic */ void access$reregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.reregisterTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$releaseTracker(LineStatusTrackerManager $this, Document document) {
        $this.releaseTracker(document);
    }

    public static final /* synthetic */ MyBaseRevisionLoader access$getLoader$p(LineStatusTrackerManager $this) {
        return $this.loader;
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "getOrder", "", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstanceImpl(project).startListenForEditors();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerAdded(this, tracker);
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerRemoved(this, tracker);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        public void onTrackerAdded(@NotNull LineStatusTracker<?> var1);

        public void onTrackerRemoved(@NotNull LineStatusTracker<?> var1);

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onTrackerAdded(@NotNull Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            }

            public static void onTrackerRemoved(@NotNull Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0015J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleCanceled", "", "document", "Lcom/intellij/openapi/editor/Document;", "handleError", "request", "handleResult", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "handleSuccess", "refreshData", "hasRequestFor", "", "loadRequest", "restorePendingTrackerState", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        public final boolean hasRequestFor(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return this.hasRequest((Function1)new Function1<RefreshRequest, Boolean>(document){
                final /* synthetic */ Document $document;

                public final boolean invoke(@NotNull RefreshRequest it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getDocument(), (Object)this.$document);
                }
                {
                    this.$document = document;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LineStatusTrackerContentLoader loader = request.getLoader();
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canCreateTrackerFor(virtualFile) || !loader.isTrackedFile(LineStatusTrackerManager.this.project, virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not a tracked file", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerContentLoader.ContentInfo newContentInfo = loader.getContentInfo(LineStatusTrackerManager.this.project, virtualFile);
            if (newContentInfo == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                block11: {
                    TrackerData data;
                    block10: {
                        boolean bl3 = false;
                        data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                        if (data != null) break block10;
                        LineStatusTrackerManager.this.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (loader.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    LineStatusTrackerManager.this.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTrackerContentLoader.TrackerContent content2 = loader.loadContent(LineStatusTrackerManager.this.project, newContentInfo);
            if (content2 == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            return new Result.Success<RefreshData>(new RefreshData(content2, newContentInfo));
        }

        @Override
        @RequiresEdt
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                this.handleCanceled(document);
            } else if (result3 instanceof Result.Error) {
                this.handleError(request, document);
            } else if (result3 instanceof Result.Success) {
                this.handleSuccess(request, document, (RefreshData)((Result.Success)result2).getData());
            }
            LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
        }

        private final void handleCanceled(Document document) {
            this.restorePendingTrackerState(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleError(RefreshRequest request, Document document) {
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                LineStatusTrackerContentLoader loader = request.getLoader();
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                if (trackerData == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers[document] ?: return");
                TrackerData data = trackerData;
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (loader.isMyTracker(tracker)) {
                    loader.handleLoadingError(tracker);
                }
                data.setContentInfo(null);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleSuccess(RefreshRequest request, Document document, RefreshData refreshData) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            Intrinsics.checkNotNull((Object)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026nce().getFile(document)!!");
            VirtualFile virtualFile2 = virtualFile;
            LineStatusTrackerContentLoader loader = request.getLoader();
            LocalLineStatusTracker<?> tracker = null;
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                TrackerData data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                if (data == null) {
                    LineStatusTrackerManager.this.log("Loading finished: tracker already released", virtualFile2);
                    return;
                }
                if (!loader.shouldBeUpdated(data.getContentInfo(), refreshData.getContentInfo())) {
                    LineStatusTrackerManager.this.log("Loading finished: no need to update", virtualFile2);
                    return;
                }
                data.setContentInfo(refreshData.getContentInfo());
                tracker = data.getTracker();
                Unit unit = Unit.INSTANCE;
            }
            if (loader.isMyTracker(tracker)) {
                loader.setLoadedContent(tracker, refreshData.getContent());
                LineStatusTrackerManager.this.log("Loading finished: success", virtualFile2);
            } else {
                LineStatusTrackerManager.this.log("Loading finished: wrong tracker. tracker: " + tracker + ", loader: " + loader, virtualFile2);
            }
            this.restorePendingTrackerState(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void restorePendingTrackerState(Document document) {
            LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(document);
            if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                ChangelistsLocalLineStatusTracker.State state;
                VirtualFile virtualFile = tracker.getVirtualFile();
                Object object = LineStatusTrackerManager.this.LOCK;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    ChangelistsLocalLineStatusTracker.State state2 = (ChangelistsLocalLineStatusTracker.State)LineStatusTrackerManager.this.fileStatesAwaitingRefresh.remove(virtualFile);
                    if (state2 == null) {
                        return;
                    }
                    ChangelistsLocalLineStatusTracker.State state3 = state2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var5_4
                    state = state3;
                }
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"synchronized(LOCK) {\n   \u2026File) ?: return\n        }");
                ChangelistsLocalLineStatusTracker.State state4 = state;
                boolean success2 = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state4);
                LineStatusTrackerManager.this.log("Pending state restored. success - " + success2, virtualFile);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "install", "disposable", "Lcom/intellij/openapi/Disposable;", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public final void install(@NotNull Disposable disposable) {
            EditorFactory editorFactory;
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            EditorFactory editorFactory2 = editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory2, (String)"editorFactory");
            Editor[] editorArray = editorFactory2.getAllEditors();
            int n = editorArray.length;
            for (int i = 0; i < n; ++i) {
                Editor editor;
                Editor editor2 = editor = editorArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                if (!this.isTrackedEditor(editor2)) continue;
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor);
            }
            editorFactory.addEditorFactoryListener((EditorFactoryListener)this, disposable);
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor2);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.releaseTrackerFor(document, editor2);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            if (FileDocumentManager.getInstance().getFile(editor.getDocument()) == null) {
                return false;
            }
            return editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "forEachTrackerUnder", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "handleFileDeletion", "handleFileMovement", "intellij.platform.vcs.impl"})
    private final class MyVirtualFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.handleFileDeletion(virtualFile);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (Intrinsics.areEqual((Object)"encoding", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                        LineStatusTrackerManager.this.onFileChanged(virtualFile);
                        continue;
                    }
                    if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                    VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                    this.handleFileMovement(virtualFile);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.handleFileMovement(virtualFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileMovement(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, file){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$file$inlined = virtualFile;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        LineStatusTrackerManager.access$reregisterTrackerInCLM(this.this$0.LineStatusTrackerManager.this, data);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileDeletion(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, file){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$file$inlined = virtualFile;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        LineStatusTrackerManager.access$releaseTracker(this.this$0.LineStatusTrackerManager.this, data.getTracker().getDocument());
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void forEachTrackerUnder(VirtualFile file, Function1<? super TrackerData, Unit> action) {
            if (file.isDirectory()) {
                void $this$filterTo$iv$iv;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TrackerData it = (TrackerData)element$iv$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)it.getTracker().getVirtualFile(), (boolean)false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List affected = (List)destination$iv$iv;
                Iterator iterator = affected.iterator();
                while (iterator.hasNext()) {
                    TrackerData data;
                    TrackerData trackerData = data = (TrackerData)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"data");
                    action.invoke((Object)trackerData);
                }
            } else {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026dDocument(file) ?: return");
                Document document2 = document;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document2);
                if (trackerData == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers[document] ?: return");
                TrackerData data = trackerData;
                action.invoke((Object)data);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(@NotNull DocumentEvent event) {
            boolean inAnotherChangelist;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled || LineStatusTrackerManager.this.project.isDisposed()) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
            Document document2 = document;
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document2)) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
            VirtualFile virtualFile2 = virtualFile;
            if (LineStatusTrackerManager.this.getLineStatusTracker(document2) != null) {
                return;
            }
            LocalLineStatusTrackerProvider provider = LineStatusTrackerManager.this.getTrackerProvider(virtualFile2);
            if (Intrinsics.areEqual((Object)provider, (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE) ^ true) {
                return;
            }
            LocalChangeList changeList = ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).getChangeList(virtualFile2);
            boolean bl = inAnotherChangelist = changeList != null && !ActiveChangeListTracker.Companion.getInstance(LineStatusTrackerManager.this.project).isActiveChangeList(changeList);
            if (inAnotherChangelist) {
                LocalLineStatusTracker localLineStatusTracker;
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                Object object = LineStatusTrackerManager.this.LOCK;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object) {
                    boolean bl4 = false;
                    localLineStatusTracker = LineStatusTrackerManager.this.installTracker(virtualFile2, document2, provider);
                }
                LocalLineStatusTracker tracker = localLineStatusTracker;
                if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                    ((ChangelistsLocalLineStatusTracker)tracker).replayChangesFromDocumentEvents(CollectionsKt.listOf((Object)event));
                }
            } else {
                LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document2);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    Document document = it.getTracker().getDocument();
                    collection2.add(document);
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        public void settingsUpdated() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.updateTrackingSettings();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        /*
         * WARNING - void declaration
         */
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            Application app$iv;
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                if (!LineStatusTrackerManager.this.project.isDisposed()) {
                    void $this$forEach$iv;
                    LineStatusTrackerManager.this.expireInactiveRangesDamagedNotifications();
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                    Editor[] editorArray = editorFactory.getAllEditors();
                    Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"EditorFactory.getInstance().allEditors");
                    Editor[] editorArray2 = editorArray;
                    boolean $i$f$forEach = false;
                    void var9_9 = $this$forEach$iv;
                    int n = ((void)var9_9).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var9_9[i];
                        boolean bl2 = false;
                        if (!(it instanceof EditorEx)) continue;
                        ((EditorEx)it).getGutterComponentEx().repaint();
                    }
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ MyChangeListListener this$0;
                    {
                        this.this$0 = myChangeListListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!LineStatusTrackerManager.access$getProject$p(this.this$0.LineStatusTrackerManager.this).isDisposed()) {
                            LineStatusTrackerManager.access$expireInactiveRangesDamagedNotifications(this.this$0.LineStatusTrackerManager.this);
                            EditorFactory editorFactory = EditorFactory.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                            Editor[] editorArray = editorFactory.getAllEditors();
                            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"EditorFactory.getInstance().allEditors");
                            Editor[] $this$forEach$iv = editorArray;
                            boolean $i$f$forEach = false;
                            Editor[] editorArray2 = $this$forEach$iv;
                            int n = editorArray2.length;
                            for (int i = 0; i < n; ++i) {
                                Editor element$iv;
                                Editor it = element$iv = editorArray2[i];
                                boolean bl2 = false;
                                if (!(it instanceof EditorEx)) continue;
                                ((EditorEx)it).getGutterComponentEx().repaint();
                            }
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    ModalityState modalityState2 = ModalityState.defaultModalityState();
                    modalityState = modalityState2;
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"ModalityState.defaultModalityState()");
                }
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListAvailabilityListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAvailabilityListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onAfter", "", "onBefore", "intellij.platform.vcs.impl"})
    private final class MyChangeListAvailabilityListener
    implements ChangeListAvailabilityListener {
        public void onBefore() {
            if (ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).areChangeListsEnabled()) {
                List<ChangelistsLocalLineStatusTracker.FullState> fileStates = Companion.getInstanceImpl(LineStatusTrackerManager.this.project).collectPartiallyChangedFilesStates$intellij_platform_vcs_impl();
                Collection collection = fileStates;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    PartialLineStatusTrackerManagerState.Companion.saveCurrentState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project, fileStates);
                }
            }
        }

        public void onAfter() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.onEverythingChanged();
            if (ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).areChangeListsEnabled()) {
                PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
            if (commandProcessor.getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$CheckinFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.platform.vcs.impl"})
    public static final class CheckinFactory
    extends CheckinHandlerFactory {
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            Project project = panel2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"panel.project");
            Project project2 = project;
            return new CheckinHandler(project2, panel2){
                final /* synthetic */ Project $project;
                final /* synthetic */ CheckinProjectPanel $panel;

                public void checkinSuccessful() {
                    this.resetExcludedFromCommit();
                }

                public void checkinFailed(@Nullable List<VcsException> exception) {
                    this.resetExcludedFromCommit();
                }

                private final void resetExcludedFromCommit() {
                    Application app$iv;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        boolean bl = false;
                        if (!this.$project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit(this.$panel)) {
                            LineStatusTrackerManager.Companion.getInstanceImpl(this.$project).resetExcludedFromCommitMarkers();
                        }
                    } else {
                        boolean $i$f$invokeLater = false;
                        Application application2 = ApplicationManager.getApplication();
                        Runnable runnable = new Runnable(this){
                            final /* synthetic */ createHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                if (!this.this$0.$project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit(this.this$0.$panel)) {
                                    LineStatusTrackerManager.Companion.getInstanceImpl(this.this$0.$project).resetExcludedFromCommitMarkers();
                                }
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application2.invokeLater(runnable, modalityState);
                    }
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$panel = $captured_local_variable$1;
                }
            };
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFreezeListener;", "Lcom/intellij/openapi/vcs/changes/VcsFreezingProcess$Listener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFreeze", "", "onUnfreeze", "intellij.platform.vcs.impl"})
    private final class MyFreezeListener
    implements VcsFreezingProcess.Listener {
        @Override
        public void onFreeze() {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ MyFreezeListener this$0;
                {
                    this.this$0 = myFreezeListener;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T compute() {
                    boolean bl = false;
                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                    boolean bl2 = false;
                    int n = 0;
                    synchronized (object) {
                        boolean bl3 = false;
                        if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                            for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                try {
                                    data.getTracker().freeze();
                                }
                                catch (Throwable e) {
                                    LineStatusTrackerManager.access$getLOG$cp().error(e);
                                }
                            }
                        }
                        LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                        int n2 = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                        LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n2 + 1);
                        n = n2;
                    }
                    return (T)Integer.valueOf(n);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnfreeze() {
            Application app$iv;
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                Object object = LineStatusTrackerManager.this.LOCK;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object) {
                    boolean bl4 = false;
                    LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                    int n = lineStatusTrackerManager.clmFreezeCounter;
                    lineStatusTrackerManager.clmFreezeCounter = n + -1;
                    if (LineStatusTrackerManager.this.clmFreezeCounter == 0) {
                        for (TrackerData data : LineStatusTrackerManager.this.trackers.values()) {
                            try {
                                data.getTracker().unfreeze();
                            }
                            catch (Throwable e) {
                                LOG.error(e);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ MyFreezeListener this$0;
                    {
                        this.this$0 = myFreezeListener;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        boolean bl = false;
                        Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        synchronized (object) {
                            boolean bl4 = false;
                            LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                            int n = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                            LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n + -1);
                            if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                                for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                    try {
                                        data.getTracker().unfreeze();
                                    }
                                    catch (Throwable e) {
                                        LineStatusTrackerManager.access$getLOG$cp().error(e);
                                    }
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    ModalityState modalityState2 = ModalityState.defaultModalityState();
                    modalityState = modalityState2;
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"ModalityState.defaultModalityState()");
                }
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "clmFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;Lcom/intellij/openapi/vcs/FilePath;)V", "getClmFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "setClmFilePath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;
        @Nullable
        private LineStatusTrackerContentLoader.ContentInfo contentInfo;
        @Nullable
        private FilePath clmFilePath;

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Nullable
        public final FilePath getClmFilePath() {
            return this.clmFilePath;
        }

        public final void setClmFilePath(@Nullable FilePath filePath) {
            this.clmFilePath = filePath;
        }

        public TrackerData(@NotNull LocalLineStatusTracker<?> tracker, @Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo, @Nullable FilePath clmFilePath) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
            this.clmFilePath = clmFilePath;
        }

        public /* synthetic */ TrackerData(LocalLineStatusTracker localLineStatusTracker, LineStatusTrackerContentLoader.ContentInfo contentInfo, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            if ((n & 4) != 0) {
                filePath = null;
            }
            this(localLineStatusTracker, contentInfo, filePath);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getLoader", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;
        @NotNull
        private final LineStatusTrackerContentLoader loader;

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("RefreshRequest: ");
            Object object = FileDocumentManager.getInstance().getFile(this.document);
            if (object == null || (object = object.getPath()) == null) {
                object = "unknown";
            }
            return stringBuilder.append((String)object).toString();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final LineStatusTrackerContentLoader getLoader() {
            return this.loader;
        }

        public RefreshRequest(@NotNull Document document, @NotNull LineStatusTrackerContentLoader loader) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            this.document = document;
            this.loader = loader;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "content", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getContent", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final LineStatusTrackerContentLoader.TrackerContent content;
        @NotNull
        private final LineStatusTrackerContentLoader.ContentInfo contentInfo;

        @NotNull
        public final LineStatusTrackerContentLoader.TrackerContent getContent() {
            return this.content;
        }

        @NotNull
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public RefreshData(@NotNull LineStatusTrackerContentLoader.TrackerContent content2, @NotNull LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentInfo, (String)"contentInfo");
            this.content = content2;
            this.contentInfo = contentInfo;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        public InactiveRangesDamagedNotification(final @NotNull Project project, @NotNull Set<? extends VirtualFile> virtualFiles) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
            super(VcsNotifier.STANDARD_NOTIFICATION.getDisplayId(), AllIcons.Toolwindows.ToolWindowChanges, null, null, VcsBundle.message((String)"lst.inactive.ranges.damaged.notification", (Object[])new Object[0]), NotificationType.INFORMATION, null);
            this.virtualFiles = virtualFiles;
            this.addAction((AnAction)NotificationAction.createSimple((Supplier)1.INSTANCE, (Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void run() {
                    ToolWindow window;
                    void $this$filterTo$iv$iv;
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                    LocalChangeList localChangeList = changeListManager.getDefaultChangeList();
                    Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"ChangeListManager.getIns\u2026roject).defaultChangeList");
                    LocalChangeList defaultList = localChangeList;
                    Collection collection = defaultList.getChanges();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"defaultList.changes");
                    Iterable $this$filter$iv = collection;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Change it = (Change)element$iv$iv;
                        boolean bl = false;
                        Iterable iterable2 = this.getVirtualFiles();
                        Change change = it;
                        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"it");
                        if (!CollectionsKt.contains((Iterable)iterable2, (Object)change.getVirtualFile())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    final List changes = (List)destination$iv$iv;
                    ToolWindow toolWindow = window = ChangesViewContentManager.Companion.getToolWindowFor(project, "Local Changes");
                    if (toolWindow != null) {
                        toolWindow.activate(new Runnable(){

                            @Override
                            public final void run() {
                                ChangesViewManager.getInstance(project).selectChanges(changes);
                            }
                        });
                    }
                    this.expire();
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(LineStatusTrackerManagerI.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (LineStatusTrackerManagerI)object;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project);
            if (lineStatusTrackerManagerI == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            }
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

