/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsFileStatusProvider;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FileStatusManagerImpl
extends FileStatusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileStatusManagerImpl.class);
    private final Map<VirtualFile, FileStatus> myCachedStatuses;
    private final Map<VirtualFile, Boolean> myWhetherExactlyParentToChanged;
    private final Project myProject;
    private final List<FileStatusListener> myListeners;
    private final VcsFileStatusProvider myFileStatusProvider;

    public FileStatusManagerImpl(@NotNull Project project) {
        if (project == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(0);
        }
        this.myCachedStatuses = Collections.synchronizedMap(new HashMap());
        this.myWhetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myFileStatusProvider = VcsFileStatusProvider.getInstance(project);
        MessageBusConnection projectBus = project.getMessageBus().connect();
        projectBus.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        });
        projectBus.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::fileStatusesChanged);
        if (!project.isDefault()) {
            StartupManager.getInstance((Project)project).runAfterOpened(this::fileStatusesChanged);
        }
        FileStatusProvider.EP_NAME.addChangeListener((AreaInstance)this.myProject, this::fileStatusesChanged, (Disposable)project);
    }

    public FileStatus calcStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(1);
        }
        for (FileStatusProvider extension : FileStatusProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            FileStatus status = extension.getFileStatus(virtualFile);
            if (status == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("File status for file [%s] from provider %s: %s", virtualFile, extension.getClass().getName(), status));
            }
            return status;
        }
        if (virtualFile.isInLocalFileSystem()) {
            FileStatus status = this.myFileStatusProvider.getFileStatus(virtualFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("File status for file [%s] from default provider %s: %s", virtualFile, this.myFileStatusProvider, status));
            }
            return status;
        }
        FileStatus defaultStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Default status for file [%s]: %s", virtualFile, defaultStatus));
        }
        return defaultStatus;
    }

    @NotNull
    public static FileStatus getDefaultStatus(@NotNull VirtualFile file) {
        if (file == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(2);
        }
        FileStatus fileStatus = file.isValid() && file.is(VFileProperty.SPECIAL) ? FileStatus.IGNORED : FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(3);
        }
        return fileStatus;
    }

    public void dispose() {
        this.myCachedStatuses.clear();
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener2) {
        if (listener2 == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
    }

    public void addFileStatusListener(final @NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(6);
        }
        this.addFileStatusListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FileStatusManagerImpl.this.removeFileStatusListener(listener2);
            }
        });
    }

    public void fileStatusesChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(() -> this.fileStatusesChanged(), ModalityState.any());
            return;
        }
        this.myCachedStatuses.clear();
        this.myWhetherExactlyParentToChanged.clear();
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusesChanged();
        }
    }

    private void cacheChangedFileStatus(VirtualFile virtualFile, FileStatus fs) {
        this.myCachedStatuses.put(virtualFile, fs);
        if (FileStatus.NOT_CHANGED.equals(fs)) {
            ThreeState parentingStatus = this.myFileStatusProvider.getNotChangedDirectoryParentingStatus(virtualFile);
            if (ThreeState.YES.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, true);
            } else if (ThreeState.UNSURE.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, false);
            }
        } else {
            this.myWhetherExactlyParentToChanged.remove(virtualFile);
        }
    }

    public void fileStatusChanged(VirtualFile file) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && !application.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(() -> this.fileStatusChanged(file));
            return;
        }
        if (file == null || !file.isValid()) {
            return;
        }
        FileStatus cachedStatus = this.getCachedStatus(file);
        if (cachedStatus == FileStatusNull.INSTANCE) {
            return;
        }
        if (cachedStatus == null) {
            this.cacheChangedFileStatus(file, FileStatusNull.INSTANCE);
            return;
        }
        FileStatus newStatus = this.calcStatus(file);
        if (cachedStatus == newStatus) {
            return;
        }
        this.cacheChangedFileStatus(file, newStatus);
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusChanged(file);
        }
    }

    public FileStatus getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(7);
        }
        if (file.getFileSystem() instanceof NonPhysicalFileSystem) {
            return FileStatus.SUPPRESSED;
        }
        FileStatus status = this.getCachedStatus(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached status for file [" + file + "] is " + status);
        }
        if (status == null || status == FileStatusNull.INSTANCE) {
            status = this.calcStatus(file);
            this.cacheChangedFileStatus(file, status);
        }
        return status;
    }

    public FileStatus getCachedStatus(VirtualFile file) {
        return this.myCachedStatuses.get(file);
    }

    public void removeFileStatusListener(@NotNull FileStatusListener listener2) {
        if (listener2 == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(8);
        }
        this.myListeners.remove(listener2);
    }

    public Color getNotChangedDirectoryColor(@NotNull VirtualFile file) {
        if (file == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(9);
        }
        return this.getRecursiveStatus(file).getColor();
    }

    @NotNull
    public FileStatus getRecursiveStatus(@NotNull VirtualFile file) {
        FileStatus status;
        if (file == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(10);
        }
        if ((status = super.getRecursiveStatus(file)) != FileStatus.NOT_CHANGED || !file.isValid() || !file.isDirectory()) {
            FileStatus fileStatus = status;
            if (fileStatus == null) {
                FileStatusManagerImpl.$$$reportNull$$$0(11);
            }
            return fileStatus;
        }
        Boolean immediate = this.myWhetherExactlyParentToChanged.get(file);
        if (immediate == null) {
            FileStatus fileStatus = status;
            if (fileStatus == null) {
                FileStatusManagerImpl.$$$reportNull$$$0(12);
            }
            return fileStatus;
        }
        FileStatus fileStatus = immediate != false ? FileStatus.NOT_CHANGED_IMMEDIATE : FileStatus.NOT_CHANGED_RECURSIVE;
        if (fileStatus == null) {
            FileStatusManagerImpl.$$$reportNull$$$0(13);
        }
        return fileStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/FileStatusManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/FileStatusManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStatus";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecursiveStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcStatus";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStatus";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFileStatusListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeFileStatusListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNotChangedDirectoryColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRecursiveStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class FileStatusManagerDocumentListener
    implements FileDocumentManagerListener,
    DocumentListener {
        private final Key<Boolean> CHANGED = Key.create((String)"FileStatusManagerDocumentListener.document.changed");

        FileStatusManagerDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Document document;
            if (event == null) {
                FileStatusManagerDocumentListener.$$$reportNull$$$0(0);
            }
            if ((document = event.getDocument()).isInBulkUpdate()) {
                document.putUserData(this.CHANGED, (Object)Boolean.TRUE);
            } else {
                FileStatusManagerDocumentListener.refreshFileStatus(document);
            }
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            if (document == null) {
                FileStatusManagerDocumentListener.$$$reportNull$$$0(1);
            }
            if (document.getUserData(this.CHANGED) != null) {
                document.putUserData(this.CHANGED, null);
                FileStatusManagerDocumentListener.refreshFileStatus(document);
            }
        }

        public void unsavedDocumentDropped(@NotNull Document document) {
            if (document == null) {
                FileStatusManagerDocumentListener.$$$reportNull$$$0(2);
            }
            FileStatusManagerDocumentListener.refreshFileStatus(document);
        }

        private static void refreshFileStatus(@NotNull Document document) {
            VirtualFile file;
            if (document == null) {
                FileStatusManagerDocumentListener.$$$reportNull$$$0(3);
            }
            if ((file = FileDocumentManager.getInstance().getFile(document)) == null) {
                return;
            }
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager == null) {
                return;
            }
            for (Project project : projectManager.getOpenProjects()) {
                VcsFileStatusProvider.getInstance(project).refreshFileStatusFromDocument(file, document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/FileStatusManagerImpl$FileStatusManagerDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateFinished";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsavedDocumentDropped";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshFileStatus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileStatusNull
    implements FileStatus {
        private static final FileStatus INSTANCE = new FileStatusNull();

        private FileStatusNull() {
        }

        public String getText() {
            throw new AssertionError((Object)"Should not be called");
        }

        public Color getColor() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public ColorKey getColorKey() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public String getId() {
            throw new AssertionError((Object)"Should not be called");
        }
    }
}

