/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultVcsRootPolicy {
    @NotNull
    protected final Project myProject;

    protected DefaultVcsRootPolicy(@NotNull Project project) {
        if (project == null) {
            DefaultVcsRootPolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static DefaultVcsRootPolicy getInstance(Project project) {
        return (DefaultVcsRootPolicy)project.getService(DefaultVcsRootPolicy.class);
    }

    @NotNull
    public abstract Collection<VirtualFile> getDefaultVcsRoots();

    @Nls
    public String getProjectConfigurationMessage() {
        boolean isDirectoryBased = ProjectKt.isDirectoryBased((Project)this.myProject);
        if (isDirectoryBased) {
            String fileName = ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath().getFileName().toString();
            return VcsBundle.message((String)"settings.vcs.mapping.project.description.with.idea.directory", (Object[])new Object[]{fileName});
        }
        return VcsBundle.message((String)"settings.vcs.mapping.project.description", (Object[])new Object[0]);
    }

    protected void scheduleMappedRootsUpdate() {
        ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
        if (StringUtil.isNotEmpty((String)vcsManager2.haveDefaultMapping())) {
            vcsManager2.scheduleMappedRootsUpdate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy", "<init>"));
    }
}

