/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.checkin.CodeCleanupCheckinHandler$getBeforeCheckinConfigurationPanel$1;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/checkin/CodeCleanupCheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinMetaHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "settings", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "kotlin.jvm.PlatformType", "getSettings", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "runCheckinHandlers", "", "runnable", "Ljava/lang/Runnable;", "intellij.platform.vcs.impl"})
final class CodeCleanupCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    private final Project project;
    private final CheckinProjectPanel panel;

    private final VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.project);
    }

    @NotNull
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        String string = VcsBundle.message((String)"before.checkin.cleanup.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"before.checkin.cleanup.code\")");
        return new BooleanCommitOption(this.panel, string, true, (KMutableProperty0<Boolean>)new CodeCleanupCheckinHandler$getBeforeCheckinConfigurationPanel$1(this.getSettings()));
    }

    public void runCheckinHandlers(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.project)) {
            List<VirtualFile> filesToProcess = CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.panel.getVirtualFiles(), this.project);
            GlobalInspectionContextBase.modalCodeCleanup((Project)this.project, (AnalysisScope)new AnalysisScope(this.project, (Collection)filesToProcess), (Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    public CodeCleanupCheckinHandler(@NotNull CheckinProjectPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        Project project = this.panel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"panel.project");
        this.project = project;
    }
}

